/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.openejb;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingException;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.gbean.annotation.ParamSpecial;
import org.apache.geronimo.gbean.annotation.SpecialAttributeType;
import org.apache.geronimo.openejb.OpenEjbSystem;
import org.apache.geronimo.openejb.cdi.SharedOwbContext;
import org.apache.openejb.AppContext;
import org.apache.openejb.BeanContext;
import org.apache.openejb.NoSuchApplicationException;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.UndeployException;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.assembler.classic.EjbJarInfo;
import org.apache.webbeans.config.WebBeansContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GBean
public class AppInfoGBean
implements SharedOwbContext,
GBeanLifecycle {
    private static final Logger log = LoggerFactory.getLogger(AppInfoGBean.class);
    private final AppInfo appInfo;
    private final ClassLoader classLoader;
    private final OpenEjbSystem openEjbSystem;
    private final AppContext appContext;

    public AppInfoGBean(@ParamAttribute(name="appInfo") AppInfo appInfo, @ParamSpecial(type=SpecialAttributeType.classLoader) ClassLoader classLoader, @ParamReference(name="OpenEjbSystem") OpenEjbSystem openEjbSystem) throws NamingException, IOException, OpenEJBException {
        this.appInfo = appInfo;
        this.classLoader = classLoader;
        this.openEjbSystem = openEjbSystem;
        this.appContext = openEjbSystem.createApplication(appInfo, classLoader, false);
    }

    public void doStart() throws Exception {
    }

    public void doStop() {
        try {
            this.openEjbSystem.removeApplication(this.appInfo, this.classLoader);
        }
        catch (NoSuchApplicationException e) {
            log.error("Module does not exist.", (Throwable)e);
        }
        catch (UndeployException e) {
            List causes = e.getCauses();
            log.error(e.getMessage() + ": Encountered " + causes.size() + " failures.");
            for (Throwable throwable : causes) {
                log.info(throwable.toString(), throwable);
            }
        }
    }

    public void doFail() {
        this.doStop();
    }

    @Override
    public WebBeansContext getOWBContext() {
        return this.appContext.getWebBeansContext();
    }

    public List<BeanContext> getModuleBeanContexts(URI moduleURI) {
        ArrayList<BeanContext> beanContexts = new ArrayList<BeanContext>();
        for (BeanContext beanContext : this.appContext.getDeployments()) {
            if (!moduleURI.toString().equals(beanContext.getModuleID())) continue;
            beanContexts.add(beanContext);
        }
        return beanContexts;
    }

    public EjbJarInfo getEjbJarInfo(URI moduleURI) {
        return AppInfoGBean.getEjbJarInfo(this.appInfo, moduleURI);
    }

    public static EjbJarInfo getEjbJarInfo(AppInfo appInfo, URI moduleURI) {
        for (EjbJarInfo info : appInfo.ejbJars) {
            if (!moduleURI.equals(info.moduleUri)) continue;
            return info;
        }
        if (appInfo.ejbJars.size() == 1 && moduleURI.toString().isEmpty()) {
            return (EjbJarInfo)appInfo.ejbJars.get(0);
        }
        throw new IllegalStateException("No module named '" + moduleURI + "' found in appInfo " + appInfo);
    }
}

