/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.openejb;

import java.io.IOException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.ejb.spi.HandleDelegate;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.resource.spi.ResourceAdapter;
import org.apache.geronimo.connector.ResourceAdapterWrapper;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.ReferenceCollection;
import org.apache.geronimo.gbean.ReferenceCollectionEvent;
import org.apache.geronimo.gbean.ReferenceCollectionListener;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.gbean.annotation.ParamSpecial;
import org.apache.geronimo.gbean.annotation.SpecialAttributeType;
import org.apache.geronimo.j2ee.jndi.ApplicationJndi;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.openejb.GeronimoInboundRecovery;
import org.apache.geronimo.openejb.GeronimoSecurityService;
import org.apache.geronimo.openejb.GeronimoThreadContextListener;
import org.apache.geronimo.openejb.OpenEjbSystem;
import org.apache.geronimo.openejb.XBeanJndiFactory;
import org.apache.geronimo.openejb.cdi.ThreadSingletonServiceAdapter;
import org.apache.geronimo.persistence.PersistenceUnitGBean;
import org.apache.geronimo.transaction.manager.RecoverableTransactionManager;
import org.apache.openejb.AppContext;
import org.apache.openejb.BeanContext;
import org.apache.openejb.Container;
import org.apache.openejb.NoSuchApplicationException;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.UndeployException;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.assembler.classic.Assembler;
import org.apache.openejb.assembler.classic.ClientInfo;
import org.apache.openejb.assembler.classic.ContainerInfo;
import org.apache.openejb.assembler.classic.EjbJarInfo;
import org.apache.openejb.assembler.classic.MdbContainerInfo;
import org.apache.openejb.assembler.classic.ProxyFactoryInfo;
import org.apache.openejb.assembler.classic.SecurityServiceInfo;
import org.apache.openejb.assembler.classic.ServiceInfo;
import org.apache.openejb.assembler.classic.TransactionServiceInfo;
import org.apache.openejb.assembler.dynamic.PassthroughFactory;
import org.apache.openejb.cdi.OWBContextThreadListener;
import org.apache.openejb.cdi.ThreadSingletonService;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.ClientModule;
import org.apache.openejb.config.ConfigurationFactory;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.config.FinderFactory;
import org.apache.openejb.core.JndiFactory;
import org.apache.openejb.core.ServerFederation;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.core.ThreadContextListener;
import org.apache.openejb.core.mdb.InboundRecovery;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.osgi.core.BundleFinderFactory;
import org.apache.openejb.resource.GeronimoTransactionManagerFactory;
import org.apache.openejb.resource.XAResourceWrapper;
import org.apache.openejb.spi.ApplicationServer;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.openejb.util.proxy.Jdk13ProxyFactory;
import org.omg.CORBA.ORB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GBean
public class OpenEjbSystemGBean
implements OpenEjbSystem {
    private static final Logger log = LoggerFactory.getLogger(OpenEjbSystemGBean.class);
    private final ConfigurationFactory configurationFactory;
    private final Assembler assembler;
    private final Set<String> registeredResouceAdapters = new TreeSet<String>();
    private final ConcurrentMap<String, ResourceAdapterWrapper> processedResourceAdapterWrappers = new ConcurrentHashMap<String, ResourceAdapterWrapper>();
    private final Kernel kernel;
    private final ClassLoader classLoader;
    private ORB orb;
    private Properties properties;

    public OpenEjbSystemGBean(RecoverableTransactionManager transactionManager) throws Exception {
        this(transactionManager, null, null, null, null, OpenEjbSystemGBean.class.getClassLoader(), new Properties());
    }

    public OpenEjbSystemGBean(@ParamReference(name="TransactionManager", namingType="JTAResource") RecoverableTransactionManager transactionManager, @ParamReference(name="ResourceAdapterWrappers", namingType="JCAResourceAdapter") Collection<ResourceAdapterWrapper> resourceAdapters, @ParamReference(name="PersistenceUnitGBeans", namingType="PersistenceUnit") Collection<PersistenceUnitGBean> persistenceUnitGBeans, @ParamReference(name="ApplicationJndis") Collection<ApplicationJndi> applicationJndis, @ParamSpecial(type=SpecialAttributeType.kernel) Kernel kernel, @ParamSpecial(type=SpecialAttributeType.classLoader) ClassLoader classLoader, @ParamAttribute(name="properties") Properties properties) throws Exception {
        if (transactionManager == null) {
            throw new NullPointerException("transactionManager is null");
        }
        this.kernel = kernel;
        this.classLoader = classLoader;
        this.properties = properties;
        System.setProperty("openejb.geronimo", "true");
        System.setProperty("admin.disabled", "true");
        System.setProperty("openejb.logger.external", "true");
        this.setDefaultProperty("openejb.deploymentId.format", "{moduleUri}/{ejbName}");
        this.setDefaultProperty("openejb.jndiname.strategy.class", "org.apache.openejb.assembler.classic.JndiBuilder$TemplatedStrategy");
        this.setDefaultProperty("openejb.jndiname.format", "{ejbName}{interfaceType.annotationName}");
        this.setDefaultProperty("openejb.jndiname.failoncollision", "false");
        boolean offline = true;
        this.configurationFactory = new ConfigurationFactory(offline);
        final XBeanJndiFactory jndiFactory = new XBeanJndiFactory();
        this.assembler = new Assembler((JndiFactory)jndiFactory);
        ServerFederation applicationServer = new ServerFederation();
        SystemInstance.get().setComponent(ApplicationServer.class, (Object)applicationServer);
        transactionManager = OpenEjbSystemGBean.getRawService(kernel, transactionManager);
        TransactionServiceInfo transactionServiceInfo = new TransactionServiceInfo();
        PassthroughFactory.add((ServiceInfo)transactionServiceInfo, (Object)transactionManager);
        transactionServiceInfo.id = "Default Transaction Manager";
        transactionServiceInfo.service = "TransactionManager";
        this.assembler.createTransactionManager(transactionServiceInfo);
        SystemInstance.get().setComponent(XAResourceWrapper.class, (Object)new GeronimoTransactionManagerFactory.GeronimoXAResourceWrapper());
        SystemInstance.get().setComponent(InboundRecovery.class, (Object)new GeronimoInboundRecovery(transactionManager));
        GeronimoSecurityService securityService = new GeronimoSecurityService();
        SecurityServiceInfo securityServiceInfo = new SecurityServiceInfo();
        PassthroughFactory.add((ServiceInfo)securityServiceInfo, (Object)securityService);
        securityServiceInfo.id = "Default Security Service";
        securityServiceInfo.service = "SecurityService";
        this.assembler.createSecurityService(securityServiceInfo);
        ProxyFactoryInfo proxyFactoryInfo = new ProxyFactoryInfo();
        proxyFactoryInfo.id = "Default JDK 1.3 ProxyFactory";
        proxyFactoryInfo.service = "ProxyFactory";
        proxyFactoryInfo.className = Jdk13ProxyFactory.class.getName();
        proxyFactoryInfo.properties = new Properties();
        this.assembler.createProxyFactory(proxyFactoryInfo);
        GeronimoThreadContextListener.init();
        SystemInstance.get().setComponent(FinderFactory.class, (Object)new BundleFinderFactory());
        SystemInstance.get().setComponent(ThreadSingletonService.class, (Object)new ThreadSingletonServiceAdapter());
        ThreadContext.addThreadContextListener((ThreadContextListener)new OWBContextThreadListener());
        this.processResourceAdapterWrappers(resourceAdapters);
        this.processPersistenceUnitGBeans(persistenceUnitGBeans);
        if (applicationJndis instanceof ReferenceCollection) {
            ((ReferenceCollection)applicationJndis).addReferenceCollectionListener(new ReferenceCollectionListener(){

                public void memberAdded(ReferenceCollectionEvent referenceCollectionEvent) {
                    jndiFactory.addGlobals(((ApplicationJndi)referenceCollectionEvent.getMember()).getGlobalMap());
                }

                public void memberRemoved(ReferenceCollectionEvent referenceCollectionEvent) {
                    jndiFactory.removeGlobals(((ApplicationJndi)referenceCollectionEvent.getMember()).getGlobalMap());
                }
            });
        }
    }

    private void setDefaultProperty(String key, String value) {
        SystemInstance systemInstance = SystemInstance.get();
        String format = systemInstance.getProperty(key);
        if (format == null) {
            systemInstance.setProperty(key, value);
        }
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    private static <T> T getRawService(Kernel kernel, T proxy) {
        if (kernel == null) {
            return proxy;
        }
        AbstractName abstractName = kernel.getAbstractNameFor(proxy);
        if (abstractName == null) {
            return proxy;
        }
        try {
            Object service = kernel.getGBean(abstractName);
            return (T)service;
        }
        catch (GBeanNotFoundException gBeanNotFoundException) {
            return proxy;
        }
    }

    private void processPersistenceUnitGBeans(Collection<PersistenceUnitGBean> persistenceUnitGBeans) {
        if (persistenceUnitGBeans == null) {
            return;
        }
        if (persistenceUnitGBeans instanceof ReferenceCollection) {
            ReferenceCollection referenceCollection = (ReferenceCollection)persistenceUnitGBeans;
            referenceCollection.addReferenceCollectionListener(new ReferenceCollectionListener(){

                public void memberAdded(ReferenceCollectionEvent event) {
                    OpenEjbSystemGBean.this.addPersistenceUnitGBean((PersistenceUnitGBean)event.getMember());
                }

                public void memberRemoved(ReferenceCollectionEvent event) {
                    OpenEjbSystemGBean.this.removePersistenceUnitGBean((PersistenceUnitGBean)event.getMember());
                }
            });
        }
        for (PersistenceUnitGBean persistenceUnitGBean : persistenceUnitGBeans) {
            this.addPersistenceUnitGBean(persistenceUnitGBean);
        }
    }

    private void addPersistenceUnitGBean(PersistenceUnitGBean persistenceUnitGBean) {
        String unit = persistenceUnitGBean.getPersistenceUnitName();
        String rootUrl = persistenceUnitGBean.getPersistenceUnitRoot();
        String id = unit + " " + rootUrl.hashCode();
        Context context = ((ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class)).getJNDIContext();
        try {
            context.bind("java:openejb/PersistenceUnit/" + id, (Object)persistenceUnitGBean.getEntityManagerFactory());
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private void removePersistenceUnitGBean(PersistenceUnitGBean persistenceUnitGBean) {
        String unit = persistenceUnitGBean.getPersistenceUnitName();
        String rootUrl = persistenceUnitGBean.getPersistenceUnitRoot();
        String id = unit + " " + rootUrl.hashCode();
        Context context = ((ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class)).getJNDIContext();
        try {
            context.unbind("java:openejb/PersistenceUnit/" + id);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private void processResourceAdapterWrappers(Collection<ResourceAdapterWrapper> resourceAdapterWrappers) {
        if (resourceAdapterWrappers == null) {
            return;
        }
        if (resourceAdapterWrappers instanceof ReferenceCollection) {
            ReferenceCollection referenceCollection = (ReferenceCollection)resourceAdapterWrappers;
            referenceCollection.addReferenceCollectionListener(new ReferenceCollectionListener(){

                public void memberAdded(ReferenceCollectionEvent event) {
                    OpenEjbSystemGBean.this.addResourceAdapter((ResourceAdapterWrapper)event.getMember());
                }

                public void memberRemoved(ReferenceCollectionEvent event) {
                    OpenEjbSystemGBean.this.removeResourceAdapter((ResourceAdapterWrapper)event.getMember());
                }
            });
        }
        for (ResourceAdapterWrapper resourceAdapterWrapper : resourceAdapterWrappers) {
            this.addResourceAdapter(resourceAdapterWrapper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addResourceAdapter(ResourceAdapterWrapper resourceAdapterWrapper) {
        ResourceAdapter resourceAdapter = resourceAdapterWrapper.getResourceAdapter();
        if (resourceAdapter == null) {
            return;
        }
        if (this.registeredResouceAdapters.contains(resourceAdapterWrapper.getName())) {
            return;
        }
        this.registeredResouceAdapters.add(resourceAdapterWrapper.getName());
        Map listenerToActivationSpecMap = resourceAdapterWrapper.getMessageListenerToActivationSpecMap();
        if (listenerToActivationSpecMap == null) {
            return;
        }
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.classLoader);
        try {
            for (Map.Entry entry : listenerToActivationSpecMap.entrySet()) {
                String messageListenerInterface = (String)entry.getKey();
                String activationSpecClass = (String)entry.getValue();
                String containerName = this.getResourceAdapterId(resourceAdapterWrapper) + "-" + messageListenerInterface;
                if (this.processedResourceAdapterWrappers.putIfAbsent(containerName, resourceAdapterWrapper) != null) continue;
                try {
                    ContainerInfo containerInfo = (ContainerInfo)this.configurationFactory.configureService(MdbContainerInfo.class, containerName, null, null, "Container");
                    containerInfo.id = containerName;
                    containerInfo.displayName = containerName;
                    this.properties = this.properties == null ? new Properties() : this.properties;
                    String instanceLimit = (String)this.properties.get(containerName + "." + "InstanceLimit");
                    if (instanceLimit != null) {
                        containerInfo.properties.put("InstanceLimit", instanceLimit);
                    }
                    containerInfo.properties.put("MessageListenerInterface", resourceAdapter.getClass().getClassLoader().loadClass(messageListenerInterface));
                    containerInfo.properties.put("ActivationSpecClass", resourceAdapter.getClass().getClassLoader().loadClass(activationSpecClass));
                    containerInfo.properties.put("ResourceAdapter", resourceAdapter);
                    this.assembler.createContainer(containerInfo);
                }
                catch (Exception e) {
                    log.error("Unable to deploy mdb container " + containerName, (Throwable)e);
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    private void removeResourceAdapter(ResourceAdapterWrapper resourceAdapterWrapper) {
        Map listenerToActivationSpecMap = resourceAdapterWrapper.getMessageListenerToActivationSpecMap();
        if (listenerToActivationSpecMap != null) {
            for (String messageListenerInterface : listenerToActivationSpecMap.keySet()) {
                String containerName = this.getResourceAdapterId(resourceAdapterWrapper) + "-" + messageListenerInterface;
                this.processedResourceAdapterWrappers.remove(containerName);
                this.assembler.removeContainer(containerName);
            }
            this.registeredResouceAdapters.remove(resourceAdapterWrapper.getName());
        }
    }

    private String getResourceAdapterId(ResourceAdapterWrapper resourceAdapterWrapper) {
        String name = resourceAdapterWrapper.getName();
        try {
            ObjectName objectName = new ObjectName(name);
            Hashtable<String, String> properties = objectName.getKeyPropertyList();
            String shortName = (String)properties.get("name");
            String moduleName = (String)properties.get("ResourceAdapterModule");
            if (shortName != null && moduleName != null) {
                return moduleName + "." + shortName;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return name;
    }

    @Override
    public ContainerSystem getContainerSystem() {
        return this.assembler.getContainerSystem();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Container createContainer(Class<? extends ContainerInfo> type, String serviceId, Properties declaredProperties, String providerId) throws OpenEJBException {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.classLoader);
        try {
            Container container;
            ContainerInfo containerInfo = (ContainerInfo)this.configurationFactory.configureService(type, serviceId, declaredProperties, providerId, "Container");
            this.assembler.createContainer(containerInfo);
            Container container2 = container = this.assembler.getContainerSystem().getContainer((Object)serviceId);
            return container2;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClientInfo configureApplication(ClientModule clientModule) throws OpenEJBException {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(clientModule.getClassLoader());
        try {
            ClientInfo clientInfo = this.configurationFactory.configureApplication(clientModule);
            return clientInfo;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AppInfo configureApplication(AppModule appModule) throws OpenEJBException {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(appModule.getClassLoader());
        try {
            AppInfo appInfo = this.configurationFactory.configureApplication(appModule);
            return appInfo;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EjbJarInfo configureApplication(EjbModule ejbModule) throws OpenEJBException {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(ejbModule.getClassLoader());
        try {
            EjbJarInfo ejbJarInfo = this.configurationFactory.configureApplication(ejbModule);
            return ejbJarInfo;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createClient(ClientInfo clientInfo, ClassLoader classLoader) throws NamingException, IOException, OpenEJBException {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(classLoader);
        try {
            this.assembler.createClient(clientInfo, classLoader);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AppContext createApplication(AppInfo appInfo, ClassLoader classLoader, boolean start) throws NamingException, IOException, OpenEJBException {
        Set names = this.kernel.listGBeans(new AbstractNameQuery(ResourceAdapterWrapper.class.getName()));
        for (AbstractName name : names) {
            try {
                ResourceAdapterWrapper resourceAdapterWrapper = (ResourceAdapterWrapper)this.kernel.getGBean(name);
                this.addResourceAdapter(resourceAdapterWrapper);
            }
            catch (GBeanNotFoundException ignored) {}
        }
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(classLoader);
        try {
            AppContext appContext = this.assembler.createApplication(appInfo, classLoader, start);
            return appContext;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    @Override
    public void removeApplication(AppInfo appInfo, ClassLoader classLoader) throws UndeployException, NoSuchApplicationException {
        this.assembler.destroyApplication(appInfo.path);
    }

    @Override
    public BeanContext getDeploymentInfo(String deploymentId) {
        return this.getContainerSystem().getBeanContext((Object)deploymentId);
    }

    @Override
    public void setORBContext(ORB orb, HandleDelegate handleDelegate) {
        if (this.orb == null) {
            this.orb = orb;
            SystemInstance.get().setComponent(ORB.class, (Object)orb);
            SystemInstance.get().setComponent(HandleDelegate.class, (Object)handleDelegate);
        }
    }
}

