/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.openejb;

import java.util.Collections;
import java.util.Map;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.Reference;
import org.apache.geronimo.datasource.DataSourceService;
import org.apache.geronimo.openejb.DeepBindableContext;
import org.apache.openejb.SystemException;
import org.apache.openejb.core.JndiFactory;
import org.apache.xbean.naming.context.ImmutableFederatedContext;

public class XBeanJndiFactory
implements JndiFactory {
    private final Context rootContext;

    XBeanJndiFactory() throws NamingException {
        DeepBindableContext context = new DeepBindableContext("openejb", false, true, true, false);
        this.rootContext = context.newContextWrapper();
        this.rootContext.createSubcontext("local");
        this.rootContext.createSubcontext("remote");
        this.rootContext.createSubcontext("client");
        this.rootContext.createSubcontext("Deployment");
        this.rootContext.createSubcontext("global");
    }

    public Context createComponentContext(Map<String, Object> bindings) throws SystemException {
        try {
            DeepBindableContext context = new DeepBindableContext("", false, true, true, false);
            ImmutableFederatedContext rootContext = new ImmutableFederatedContext("", Collections.singleton(context));
            return context.newContextWrapper((Context)rootContext);
        }
        catch (NamingException e) {
            throw new IllegalStateException(e);
        }
    }

    public Context createRootContext() {
        return this.rootContext;
    }

    public void addGlobals(Map<String, Object> globals) {
        for (Map.Entry<String, Object> entry : globals.entrySet()) {
            Reference ref;
            if (!(entry.getValue() instanceof Reference) || !(ref = (Reference)entry.getValue()).getClassName().equals(DataSourceService.class.getName())) continue;
            String name = "openejb/global/" + entry.getKey();
            try {
                this.rootContext.bind(name, entry.getValue());
            }
            catch (Exception ignore) {}
        }
    }

    public void removeGlobals(Map<String, Object> globals) {
        for (Map.Entry<String, Object> entry : globals.entrySet()) {
            Reference ref;
            if (!(entry.getValue() instanceof Reference) || !(ref = (Reference)entry.getValue()).getClassName().equals(DataSourceService.class.getName())) continue;
            String name = "openejb/global/" + entry.getKey();
            try {
                this.rootContext.unbind(name);
            }
            catch (NamingException e) {}
        }
    }
}

