/*
 * Decompiled with CFR 0.152.
 */
package chat;

import chat.ChatServlet;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.comet.CometEvent;
import org.apache.catalina.comet.CometProcessor;

public class ChatServlet
extends HttpServlet
implements CometProcessor {
    private static final long serialVersionUID = 1L;
    private static final String CHARSET = "UTF-8";
    protected ArrayList<HttpServletResponse> connections = new ArrayList();
    protected transient MessageSender messageSender = null;

    public void init() throws ServletException {
        this.messageSender = new MessageSender(this);
        Thread messageSenderThread = new Thread((Runnable)this.messageSender, "MessageSender[" + this.getServletContext().getContextPath() + "]");
        messageSenderThread.setDaemon(true);
        messageSenderThread.start();
    }

    public void destroy() {
        this.connections.clear();
        this.messageSender.stop();
        this.messageSender = null;
    }

    public void event(CometEvent event) throws IOException, ServletException {
        HttpServletRequest request = event.getHttpServletRequest();
        HttpServletResponse response = event.getHttpServletResponse();
        if (event.getEventType() == CometEvent.EventType.BEGIN) {
            String action = request.getParameter("action");
            if (action != null) {
                if ("login".equals(action)) {
                    String nickname = request.getParameter("nickname");
                    request.getSession(true).setAttribute("nickname", (Object)nickname);
                    response.sendRedirect("index.jsp");
                    event.close();
                    return;
                }
                String nickname = (String)request.getSession(true).getAttribute("nickname");
                String message = request.getParameter("message");
                this.messageSender.send(nickname, message);
                response.sendRedirect("post.jsp");
                event.close();
                return;
            }
            if (request.getSession(true).getAttribute("nickname") == null) {
                this.log("Redirect to login for session: " + request.getSession(true).getId());
                response.sendRedirect("login.jsp");
                event.close();
                return;
            }
            this.begin(event, request, response);
        } else if (event.getEventType() == CometEvent.EventType.ERROR) {
            this.error(event, request, response);
        } else if (event.getEventType() == CometEvent.EventType.END) {
            this.end(event, request, response);
        } else if (event.getEventType() == CometEvent.EventType.READ) {
            this.read(event, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void begin(CometEvent event, HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.log("Begin for session: " + request.getSession(true).getId());
        response.setContentType("text/html; charset=UTF-8");
        PrintWriter writer = response.getWriter();
        writer.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">");
        writer.println("<html><head><title>JSP Chat</title></head><body bgcolor=\"#FFFFFF\">");
        writer.println("<div>Welcome to the chat. <a href='chat'>Click here to reload this window</a></div>");
        writer.flush();
        ArrayList arrayList = this.connections;
        synchronized (arrayList) {
            this.connections.add(response);
        }
        this.messageSender.send("Tomcat", request.getSession(true).getAttribute("nickname") + " joined the chat.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void end(CometEvent event, HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.log("End for session: " + request.getSession(true).getId());
        ArrayList arrayList = this.connections;
        synchronized (arrayList) {
            this.connections.remove(response);
        }
        PrintWriter writer = response.getWriter();
        writer.println("</body></html>");
        event.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void error(CometEvent event, HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.log("Error for session: " + request.getSession(true).getId());
        ArrayList arrayList = this.connections;
        synchronized (arrayList) {
            this.connections.remove(response);
        }
        event.close();
    }

    protected void read(CometEvent event, HttpServletRequest request, HttpServletResponse response) throws IOException {
        ServletInputStream is = request.getInputStream();
        byte[] buf = new byte[512];
        while (is.available() > 0) {
            this.log("Available: " + is.available());
            int n = is.read(buf);
            if (n > 0) {
                this.log("Read " + n + " bytes: " + new String(buf, 0, n) + " for session: " + request.getSession(true).getId());
                continue;
            }
            if (n >= 0) continue;
            this.log("End of file: " + n);
            this.end(event, request, response);
            return;
        }
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        response.setContentType("text/html; charset=UTF-8");
        PrintWriter writer = response.getWriter();
        writer.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">");
        writer.println("<html><head><title>JSP Chat</title></head><body bgcolor=\"#FFFFFF\">");
        writer.println("Chat example only supports Comet processing. ");
        writer.println("Configure a connector that supports Comet and try again.");
        writer.println("</body></html>");
    }

    protected static String filter(String message) {
        if (message == null) {
            return null;
        }
        char[] content = new char[message.length()];
        message.getChars(0, message.length(), content, 0);
        StringBuilder result = new StringBuilder(content.length + 50);
        block6: for (int i = 0; i < content.length; ++i) {
            switch (content[i]) {
                case '<': {
                    result.append("&lt;");
                    continue block6;
                }
                case '>': {
                    result.append("&gt;");
                    continue block6;
                }
                case '&': {
                    result.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    result.append("&quot;");
                    continue block6;
                }
                default: {
                    result.append(content[i]);
                }
            }
        }
        return result.toString();
    }
}

