/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.tool;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.apache.avro.Schema;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.JsonDecoder;
import org.apache.avro.tool.Tool;
import org.apache.avro.tool.Util;

public class DataFileWriteTool
implements Tool {
    @Override
    public String getName() {
        return "fromjson";
    }

    @Override
    public String getShortDescription() {
        return "Reads JSON records and writes an Avro data file.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int run(InputStream stdin, PrintStream out, PrintStream err, List<String> args) throws Exception {
        OptionParser p = new OptionParser();
        ArgumentAcceptingOptionSpec codec = p.accepts("codec", "Compression codec").withRequiredArg().defaultsTo((Object)"null", (Object[])new String[0]).ofType(String.class);
        OptionSet opts = p.parse(args.toArray(new String[0]));
        if (opts.nonOptionArguments().size() != 2) {
            err.println("Expected 2 args: schema input_file");
            p.printHelpOn((OutputStream)err);
            return 1;
        }
        Schema schema = Schema.parse(args.get(0));
        GenericDatumReader<Object> reader = new GenericDatumReader<Object>(schema);
        InputStream input = Util.fileOrStdin(args.get(1), stdin);
        try {
            DataInputStream din = new DataInputStream(input);
            DataFileWriter writer = new DataFileWriter(new GenericDatumWriter());
            writer.setCodec(CodecFactory.fromString((String)codec.value(opts)));
            writer.create(schema, out);
            JsonDecoder decoder = new JsonDecoder(schema, (InputStream)din);
            while (true) {
                Object datum;
                try {
                    datum = reader.read(null, decoder);
                }
                catch (EOFException e) {
                    break;
                }
                writer.append(datum);
            }
            writer.close();
        }
        finally {
            if (input != stdin) {
                input.close();
            }
        }
        return 0;
    }
}

