/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.client;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.security.authentication.client.AuthenticatedURL;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.client.Authenticator;
import org.apache.hadoop.security.authentication.client.PseudoAuthenticator;
import org.apache.hadoop.security.authentication.util.KerberosUtil;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class KerberosAuthenticator
implements Authenticator {
    public static final String WWW_AUTHENTICATE = "WWW-Authenticate";
    public static final String AUTHORIZATION = "Authorization";
    public static final String NEGOTIATE = "Negotiate";
    private static final String AUTH_HTTP_METHOD = "OPTIONS";
    private URL url;
    private HttpURLConnection conn;
    private Base64 base64;

    @Override
    public void authenticate(URL url, AuthenticatedURL.Token token) throws IOException, AuthenticationException {
        if (!token.isSet()) {
            this.url = url;
            this.base64 = new Base64(0);
            this.conn = (HttpURLConnection)url.openConnection();
            this.conn.setRequestMethod(AUTH_HTTP_METHOD);
            this.conn.connect();
            if (this.isNegotiate()) {
                this.doSpnegoSequence(token);
            } else {
                this.getFallBackAuthenticator().authenticate(url, token);
            }
        }
    }

    protected Authenticator getFallBackAuthenticator() {
        return new PseudoAuthenticator();
    }

    private boolean isNegotiate() throws IOException {
        boolean negotiate = false;
        if (this.conn.getResponseCode() == 401) {
            String authHeader = this.conn.getHeaderField(WWW_AUTHENTICATE);
            negotiate = authHeader != null && authHeader.trim().startsWith(NEGOTIATE);
        }
        return negotiate;
    }

    private void doSpnegoSequence(AuthenticatedURL.Token token) throws IOException, AuthenticationException {
        try {
            AccessControlContext context = AccessController.getContext();
            Subject subject = Subject.getSubject(context);
            if (subject == null) {
                subject = new Subject();
                LoginContext login = new LoginContext("", subject, null, new KerberosConfiguration());
                login.login();
            }
            Subject.doAs(subject, new PrivilegedExceptionAction<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void run() throws Exception {
                    GSSContext gssContext = null;
                    try {
                        GSSManager gssManager = GSSManager.getInstance();
                        String servicePrincipal = "HTTP/" + KerberosAuthenticator.this.url.getHost();
                        GSSName serviceName = gssManager.createName(servicePrincipal, GSSName.NT_HOSTBASED_SERVICE);
                        Oid oid = KerberosUtil.getOidClassInstance(servicePrincipal, gssManager);
                        gssContext = gssManager.createContext(serviceName, oid, null, 0);
                        gssContext.requestCredDeleg(true);
                        gssContext.requestMutualAuth(true);
                        byte[] inToken = new byte[]{};
                        boolean established = false;
                        while (!established) {
                            byte[] outToken = gssContext.initSecContext(inToken, 0, inToken.length);
                            if (outToken != null) {
                                KerberosAuthenticator.this.sendToken(outToken);
                            }
                            if (!gssContext.isEstablished()) {
                                inToken = KerberosAuthenticator.this.readToken();
                                continue;
                            }
                            established = true;
                        }
                    }
                    finally {
                        if (gssContext != null) {
                            gssContext.dispose();
                            gssContext = null;
                        }
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException ex) {
            throw new AuthenticationException(ex.getException());
        }
        catch (LoginException ex) {
            throw new AuthenticationException(ex);
        }
        AuthenticatedURL.extractToken(this.conn, token);
    }

    private void sendToken(byte[] outToken) throws IOException, AuthenticationException {
        String token = this.base64.encodeToString(outToken);
        this.conn = (HttpURLConnection)this.url.openConnection();
        this.conn.setRequestMethod(AUTH_HTTP_METHOD);
        this.conn.setRequestProperty(AUTHORIZATION, "Negotiate " + token);
        this.conn.connect();
    }

    private byte[] readToken() throws IOException, AuthenticationException {
        int status = this.conn.getResponseCode();
        if (status == 200 || status == 401) {
            String authHeader = this.conn.getHeaderField(WWW_AUTHENTICATE);
            if (authHeader == null || !authHeader.trim().startsWith(NEGOTIATE)) {
                throw new AuthenticationException("Invalid SPNEGO sequence, 'WWW-Authenticate' header incorrect: " + authHeader);
            }
            String negotiation = authHeader.trim().substring("Negotiate ".length()).trim();
            return this.base64.decode(negotiation);
        }
        throw new AuthenticationException("Invalid SPNEGO sequence, status code: " + status);
    }

    private static class KerberosConfiguration
    extends Configuration {
        private static final String OS_LOGIN_MODULE_NAME;
        private static final boolean windows;
        private static final AppConfigurationEntry OS_SPECIFIC_LOGIN;
        private static final Map<String, String> USER_KERBEROS_OPTIONS;
        private static final AppConfigurationEntry USER_KERBEROS_LOGIN;
        private static final AppConfigurationEntry[] USER_KERBEROS_CONF;

        private KerberosConfiguration() {
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String appName) {
            return USER_KERBEROS_CONF;
        }

        static {
            windows = System.getProperty("os.name").startsWith("Windows");
            OS_LOGIN_MODULE_NAME = windows ? "com.sun.security.auth.module.NTLoginModule" : "com.sun.security.auth.module.UnixLoginModule";
            OS_SPECIFIC_LOGIN = new AppConfigurationEntry(OS_LOGIN_MODULE_NAME, AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, new HashMap());
            USER_KERBEROS_OPTIONS = new HashMap<String, String>();
            USER_KERBEROS_OPTIONS.put("doNotPrompt", "true");
            USER_KERBEROS_OPTIONS.put("useTicketCache", "true");
            USER_KERBEROS_OPTIONS.put("renewTGT", "true");
            String ticketCache = System.getenv("KRB5CCNAME");
            if (ticketCache != null) {
                USER_KERBEROS_OPTIONS.put("ticketCache", ticketCache);
            }
            USER_KERBEROS_LOGIN = new AppConfigurationEntry(KerberosUtil.getKrb5LoginModuleName(), AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL, USER_KERBEROS_OPTIONS);
            USER_KERBEROS_CONF = new AppConfigurationEntry[]{OS_SPECIFIC_LOGIN, USER_KERBEROS_LOGIN};
        }
    }
}

