/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.client;

import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.hadoop.security.authentication.client.AuthenticatedURL;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.client.Authenticator;
import org.apache.hadoop.security.authentication.client.ConnectionConfigurator;
import org.mockito.Mockito;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestAuthenticatedURL
extends TestCase {
    public void testToken() throws Exception {
        AuthenticatedURL.Token token = new AuthenticatedURL.Token();
        TestAuthenticatedURL.assertFalse((boolean)token.isSet());
        token = new AuthenticatedURL.Token("foo");
        TestAuthenticatedURL.assertTrue((boolean)token.isSet());
        TestAuthenticatedURL.assertEquals((String)"foo", (String)token.toString());
        AuthenticatedURL.Token token1 = new AuthenticatedURL.Token();
        AuthenticatedURL.Token token2 = new AuthenticatedURL.Token();
        TestAuthenticatedURL.assertEquals((int)token1.hashCode(), (int)token2.hashCode());
        TestAuthenticatedURL.assertTrue((boolean)token1.equals((Object)token2));
        token1 = new AuthenticatedURL.Token();
        token2 = new AuthenticatedURL.Token("foo");
        TestAuthenticatedURL.assertNotSame((Object)token1.hashCode(), (Object)token2.hashCode());
        TestAuthenticatedURL.assertFalse((boolean)token1.equals((Object)token2));
        token1 = new AuthenticatedURL.Token("foo");
        token2 = new AuthenticatedURL.Token();
        TestAuthenticatedURL.assertNotSame((Object)token1.hashCode(), (Object)token2.hashCode());
        TestAuthenticatedURL.assertFalse((boolean)token1.equals((Object)token2));
        token1 = new AuthenticatedURL.Token("foo");
        token2 = new AuthenticatedURL.Token("foo");
        TestAuthenticatedURL.assertEquals((int)token1.hashCode(), (int)token2.hashCode());
        TestAuthenticatedURL.assertTrue((boolean)token1.equals((Object)token2));
        token1 = new AuthenticatedURL.Token("bar");
        token2 = new AuthenticatedURL.Token("foo");
        TestAuthenticatedURL.assertNotSame((Object)token1.hashCode(), (Object)token2.hashCode());
        TestAuthenticatedURL.assertFalse((boolean)token1.equals((Object)token2));
        token1 = new AuthenticatedURL.Token("foo");
        token2 = new AuthenticatedURL.Token("bar");
        TestAuthenticatedURL.assertNotSame((Object)token1.hashCode(), (Object)token2.hashCode());
        TestAuthenticatedURL.assertFalse((boolean)token1.equals((Object)token2));
    }

    public void testInjectToken() throws Exception {
        HttpURLConnection conn = (HttpURLConnection)Mockito.mock(HttpURLConnection.class);
        AuthenticatedURL.Token token = new AuthenticatedURL.Token();
        token.set("foo");
        AuthenticatedURL.injectToken((HttpURLConnection)conn, (AuthenticatedURL.Token)token);
        ((HttpURLConnection)Mockito.verify((Object)conn)).addRequestProperty((String)Mockito.eq((Object)"Cookie"), Mockito.anyString());
    }

    public void testExtractTokenOK() throws Exception {
        HttpURLConnection conn = (HttpURLConnection)Mockito.mock(HttpURLConnection.class);
        Mockito.when((Object)conn.getResponseCode()).thenReturn((Object)200);
        String tokenStr = "foo";
        HashMap headers = new HashMap();
        ArrayList<String> cookies = new ArrayList<String>();
        cookies.add("hadoop.auth=" + tokenStr);
        headers.put("Set-Cookie", cookies);
        Mockito.when(conn.getHeaderFields()).thenReturn(headers);
        AuthenticatedURL.Token token = new AuthenticatedURL.Token();
        AuthenticatedURL.extractToken((HttpURLConnection)conn, (AuthenticatedURL.Token)token);
        TestAuthenticatedURL.assertEquals((String)tokenStr, (String)token.toString());
    }

    public void testExtractTokenFail() throws Exception {
        HttpURLConnection conn = (HttpURLConnection)Mockito.mock(HttpURLConnection.class);
        Mockito.when((Object)conn.getResponseCode()).thenReturn((Object)401);
        String tokenStr = "foo";
        HashMap headers = new HashMap();
        ArrayList<String> cookies = new ArrayList<String>();
        cookies.add("hadoop.auth=" + tokenStr);
        headers.put("Set-Cookie", cookies);
        Mockito.when(conn.getHeaderFields()).thenReturn(headers);
        AuthenticatedURL.Token token = new AuthenticatedURL.Token();
        token.set("bar");
        try {
            AuthenticatedURL.extractToken((HttpURLConnection)conn, (AuthenticatedURL.Token)token);
            TestAuthenticatedURL.fail();
        }
        catch (AuthenticationException ex) {
            Assert.assertFalse((boolean)token.isSet());
        }
        catch (Exception ex) {
            TestAuthenticatedURL.fail();
        }
    }

    public void testConnectionConfigurator() throws Exception {
        HttpURLConnection conn = (HttpURLConnection)Mockito.mock(HttpURLConnection.class);
        Mockito.when((Object)conn.getResponseCode()).thenReturn((Object)401);
        ConnectionConfigurator connConf = (ConnectionConfigurator)Mockito.mock(ConnectionConfigurator.class);
        Mockito.when((Object)connConf.configure((HttpURLConnection)Mockito.any())).thenReturn((Object)conn);
        Authenticator authenticator = (Authenticator)Mockito.mock(Authenticator.class);
        AuthenticatedURL aURL = new AuthenticatedURL(authenticator, connConf);
        aURL.openConnection(new URL("http://foo"), new AuthenticatedURL.Token());
        ((ConnectionConfigurator)Mockito.verify((Object)connConf)).configure((HttpURLConnection)Mockito.any());
    }
}

