/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a;

import java.io.IOException;
import org.apache.commons.lang3.StringUtils;

public enum S3AEncryptionMethods {
    NONE("", false),
    SSE_S3("AES256", true),
    SSE_KMS("SSE-KMS", true),
    SSE_C("SSE-C", true),
    CSE_KMS("CSE-KMS", false),
    CSE_CUSTOM("CSE-CUSTOM", false);

    static final String UNKNOWN_ALGORITHM = "Unknown encryption algorithm ";
    private String method;
    private boolean serverSide;

    private S3AEncryptionMethods(String method, boolean serverSide) {
        this.method = method;
        this.serverSide = serverSide;
    }

    public String getMethod() {
        return this.method;
    }

    public boolean isServerSide() {
        return this.serverSide;
    }

    public static S3AEncryptionMethods getMethod(String name) throws IOException {
        if (StringUtils.isBlank((CharSequence)name)) {
            return NONE;
        }
        for (S3AEncryptionMethods v : S3AEncryptionMethods.values()) {
            if (!v.getMethod().equals(name)) continue;
            return v;
        }
        throw new IOException(UNKNOWN_ALGORITHM + name);
    }
}

