/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.impl.streams;

import java.util.function.Function;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.s3a.impl.streams.AnalyticsStreamFactory;
import org.apache.hadoop.fs.s3a.impl.streams.ClassicObjectInputStreamFactory;
import org.apache.hadoop.fs.s3a.impl.streams.ObjectInputStreamFactory;
import org.apache.hadoop.fs.s3a.impl.streams.StreamIntegration;
import org.apache.hadoop.fs.s3a.prefetch.PrefetchingInputStreamFactory;

public enum InputStreamType {
    Classic("classic", 1, c -> new ClassicObjectInputStreamFactory()),
    Prefetch("prefetch", 2, c -> new PrefetchingInputStreamFactory()),
    Analytics("analytics", 3, c -> new AnalyticsStreamFactory()),
    Custom("custom", 4, c -> StreamIntegration.loadCustomFactory(c));

    private final String name;
    private final int streamID;
    private final Function<Configuration, ObjectInputStreamFactory> factory;

    public String getName() {
        return this.name;
    }

    private InputStreamType(String name, int id, Function<Configuration, ObjectInputStreamFactory> factory) {
        this.name = name;
        this.streamID = id;
        this.factory = factory;
    }

    public int streamID() {
        return this.streamID;
    }

    public String capability() {
        return "fs.s3a.input.stream.type." + this.getName();
    }

    public Function<Configuration, ObjectInputStreamFactory> factory() {
        return this.factory;
    }
}

