/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics.file;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.metrics.ContextFactory;
import org.apache.hadoop.metrics.spi.AbstractMetricsContext;
import org.apache.hadoop.metrics.spi.OutputRecord;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class FileContext
extends AbstractMetricsContext {
    @InterfaceAudience.Private
    protected static final String FILE_NAME_PROPERTY = "fileName";
    @InterfaceAudience.Private
    protected static final String PERIOD_PROPERTY = "period";
    private File file = null;
    private PrintWriter writer = null;

    @InterfaceAudience.Private
    public FileContext() {
    }

    @Override
    @InterfaceAudience.Private
    public void init(String contextName, ContextFactory factory) {
        super.init(contextName, factory);
        String fileName = this.getAttribute(FILE_NAME_PROPERTY);
        if (fileName != null) {
            this.file = new File(fileName);
        }
        this.parseAndSetPeriod(PERIOD_PROPERTY);
    }

    @InterfaceAudience.Private
    public String getFileName() {
        if (this.file == null) {
            return null;
        }
        return this.file.getName();
    }

    @Override
    @InterfaceAudience.Private
    public void startMonitoring() throws IOException {
        this.writer = this.file == null ? new PrintWriter(new BufferedOutputStream(System.out)) : new PrintWriter(new FileWriter(this.file, true));
        super.startMonitoring();
    }

    @Override
    @InterfaceAudience.Private
    public void stopMonitoring() {
        super.stopMonitoring();
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
    }

    @Override
    @InterfaceAudience.Private
    public void emitRecord(String contextName, String recordName, OutputRecord outRec) {
        this.writer.print(contextName);
        this.writer.print(".");
        this.writer.print(recordName);
        String separator = ": ";
        for (String tagName : outRec.getTagNames()) {
            this.writer.print(separator);
            separator = ", ";
            this.writer.print(tagName);
            this.writer.print("=");
            this.writer.print(outRec.getTag(tagName));
        }
        for (String metricName : outRec.getMetricNames()) {
            this.writer.print(separator);
            separator = ", ";
            this.writer.print(metricName);
            this.writer.print("=");
            this.writer.print(outRec.getMetric(metricName));
        }
        this.writer.println();
    }

    @Override
    @InterfaceAudience.Private
    public void flush() {
        this.writer.flush();
    }
}

