/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.security.Principal;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.security.UserGroupInformation;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Evolving
class User
implements Principal {
    private final String fullName;
    private final String shortName;
    private UserGroupInformation.AuthenticationMethod authMethod = null;

    public User(String name) {
        this(name, null);
    }

    public User(String name, UserGroupInformation.AuthenticationMethod authMethod) {
        int slashIdx;
        this.fullName = name;
        int atIdx = name.indexOf(64);
        this.shortName = atIdx == -1 ? name : ((slashIdx = name.indexOf(47)) == -1 || atIdx < slashIdx ? name.substring(0, atIdx) : name.substring(0, slashIdx));
        this.authMethod = authMethod;
    }

    @Override
    public String getName() {
        return this.fullName;
    }

    public String getShortName() {
        return this.shortName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.fullName.equals(((User)o).fullName) && this.authMethod == ((User)o).authMethod;
    }

    @Override
    public int hashCode() {
        return this.fullName.hashCode();
    }

    @Override
    public String toString() {
        return this.fullName;
    }

    public void setAuthenticationMethod(UserGroupInformation.AuthenticationMethod authMethod) {
        this.authMethod = authMethod;
    }

    public UserGroupInformation.AuthenticationMethod getAuthenticationMethod() {
        return this.authMethod;
    }
}

