/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authorize;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AuthorizationException;

@InterfaceAudience.Private
public class ProxyUsers {
    public static String getProxySuperuserGroupConfKey(String userName) {
        return "hadoop.proxyuser." + userName + ".users";
    }

    public static String getProxySuperuserIpConfKey(String userName) {
        return "hadoop.proxyuser." + userName + ".ip-addresses";
    }

    public static void authorize(UserGroupInformation user, String remoteAddress, Configuration conf) throws AuthorizationException {
        if (user.getRealUser() == null) {
            return;
        }
        boolean groupAuthorized = false;
        UserGroupInformation superUser = user.getRealUser();
        Collection<String> allowedUserGroups = conf.getStringCollection(ProxyUsers.getProxySuperuserGroupConfKey(superUser.getShortUserName()));
        if (!allowedUserGroups.isEmpty()) {
            for (String group : user.getGroupNames()) {
                if (!allowedUserGroups.contains(group)) continue;
                groupAuthorized = true;
                break;
            }
        }
        if (!groupAuthorized) {
            throw new AuthorizationException("User: " + superUser.getUserName() + " is not allowed to impersonate " + user.getUserName());
        }
        Collection<String> ipList = conf.getStringCollection(ProxyUsers.getProxySuperuserIpConfKey(superUser.getShortUserName()));
        if (!ipList.isEmpty()) {
            for (String allowedHost : ipList) {
                InetAddress hostAddr;
                try {
                    hostAddr = InetAddress.getByName(allowedHost);
                }
                catch (UnknownHostException e) {
                    continue;
                }
                if (!hostAddr.getHostAddress().equals(remoteAddress)) continue;
                return;
            }
        }
        throw new AuthorizationException("Unauthorized connection for super-user: " + superUser.getUserName() + " from IP " + remoteAddress);
    }
}

