/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.token.delegation;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.crypto.SecretKey;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenSecretManager;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Evolving
public class DelegationKey
implements Writable {
    private int keyId;
    private long expiryDate;
    private SecretKey key;

    public DelegationKey() {
        this(0, 0L, null);
    }

    public DelegationKey(int keyId, long expiryDate, SecretKey key) {
        this.keyId = keyId;
        this.expiryDate = expiryDate;
        this.key = key;
    }

    public int getKeyId() {
        return this.keyId;
    }

    public long getExpiryDate() {
        return this.expiryDate;
    }

    public SecretKey getKey() {
        return this.key;
    }

    public void setExpiryDate(long expiryDate) {
        this.expiryDate = expiryDate;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        WritableUtils.writeVInt(out, this.keyId);
        WritableUtils.writeVLong(out, this.expiryDate);
        byte[] keyBytes = this.key.getEncoded();
        WritableUtils.writeVInt(out, keyBytes.length);
        out.write(keyBytes);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.keyId = WritableUtils.readVInt(in);
        this.expiryDate = WritableUtils.readVLong(in);
        int len = WritableUtils.readVInt(in);
        byte[] keyBytes = new byte[len];
        in.readFully(keyBytes);
        this.key = AbstractDelegationTokenSecretManager.createSecretKey(keyBytes);
    }
}

