/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.avro.reflect.Stringable;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;

@Stringable
@InterfaceAudience.Public
@InterfaceStability.Stable
public class Path
implements Comparable {
    public static final String SEPARATOR = "/";
    public static final char SEPARATOR_CHAR = '/';
    public static final String CUR_DIR = ".";
    static final boolean WINDOWS = System.getProperty("os.name").startsWith("Windows");
    private URI uri;

    public Path(String parent, String child) {
        this(new Path(parent), new Path(child));
    }

    public Path(Path parent, String child) {
        this(parent, new Path(child));
    }

    public Path(String parent, Path child) {
        this(new Path(parent), child);
    }

    public Path(Path parent, Path child) {
        URI parentUri = parent.uri;
        String parentPath = parentUri.getPath();
        if (!parentPath.equals(SEPARATOR) && !parentPath.equals("")) {
            try {
                parentUri = new URI(parentUri.getScheme(), parentUri.getAuthority(), parentUri.getPath() + SEPARATOR, null, parentUri.getFragment());
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }
        URI resolved = parentUri.resolve(child.uri);
        this.initialize(resolved.getScheme(), resolved.getAuthority(), resolved.getPath(), resolved.getFragment());
    }

    private void checkPathArg(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Can not create a Path from a null string");
        }
        if (path.length() == 0) {
            throw new IllegalArgumentException("Can not create a Path from an empty string");
        }
    }

    public Path(String pathString) {
        this.checkPathArg(pathString);
        if (this.hasWindowsDrive(pathString, false)) {
            pathString = SEPARATOR + pathString;
        }
        String scheme = null;
        String authority = null;
        int start = 0;
        int colon = pathString.indexOf(58);
        int slash = pathString.indexOf(47);
        if (colon != -1 && (slash == -1 || colon < slash)) {
            scheme = pathString.substring(0, colon);
            start = colon + 1;
        }
        if (pathString.startsWith("//", start) && pathString.length() - start > 2) {
            int nextSlash = pathString.indexOf(47, start + 2);
            int authEnd = nextSlash > 0 ? nextSlash : pathString.length();
            authority = pathString.substring(start + 2, authEnd);
            start = authEnd;
        }
        String path = pathString.substring(start, pathString.length());
        this.initialize(scheme, authority, path, null);
    }

    public Path(URI aUri) {
        this.uri = aUri;
    }

    public Path(String scheme, String authority, String path) {
        this.checkPathArg(path);
        this.initialize(scheme, authority, path, null);
    }

    private void initialize(String scheme, String authority, String path, String fragment) {
        try {
            this.uri = new URI(scheme, authority, this.normalizePath(path), null, fragment).normalize();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private String normalizePath(String path) {
        int minLength;
        path = StringUtils.replace((String)path, (String)"//", (String)SEPARATOR);
        if (WINDOWS) {
            path = StringUtils.replace((String)path, (String)"\\", (String)SEPARATOR);
        }
        int n = minLength = this.hasWindowsDrive(path, true) ? 4 : 1;
        if (path.length() > minLength && path.endsWith(SEPARATOR)) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    private boolean hasWindowsDrive(String path, boolean slashed) {
        if (!WINDOWS) {
            return false;
        }
        int start = slashed ? 1 : 0;
        return path.length() >= start + 2 && (!slashed || path.charAt(0) == '/') && path.charAt(start + 1) == ':' && (path.charAt(start) >= 'A' && path.charAt(start) <= 'Z' || path.charAt(start) >= 'a' && path.charAt(start) <= 'z');
    }

    public URI toUri() {
        return this.uri;
    }

    public FileSystem getFileSystem(Configuration conf) throws IOException {
        return FileSystem.get(this.toUri(), conf);
    }

    public boolean isAbsoluteAndSchemeAuthorityNull() {
        return this.isUriPathAbsolute() && this.uri.getScheme() == null && this.uri.getAuthority() == null;
    }

    public boolean isUriPathAbsolute() {
        int start = this.hasWindowsDrive(this.uri.getPath(), true) ? 3 : 0;
        return this.uri.getPath().startsWith(SEPARATOR, start);
    }

    public boolean isAbsolute() {
        return this.isUriPathAbsolute();
    }

    public String getName() {
        String path = this.uri.getPath();
        int slash = path.lastIndexOf(SEPARATOR);
        return path.substring(slash + 1);
    }

    public Path getParent() {
        String parent;
        int start;
        String path = this.uri.getPath();
        int lastSlash = path.lastIndexOf(47);
        int n = start = this.hasWindowsDrive(path, true) ? 3 : 0;
        if (path.length() == start || lastSlash == start && path.length() == start + 1) {
            return null;
        }
        if (lastSlash == -1) {
            parent = CUR_DIR;
        } else {
            int end = this.hasWindowsDrive(path, true) ? 3 : 0;
            parent = path.substring(0, lastSlash == end ? end + 1 : lastSlash);
        }
        return new Path(this.uri.getScheme(), this.uri.getAuthority(), parent);
    }

    public Path suffix(String suffix) {
        return new Path(this.getParent(), this.getName() + suffix);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        if (this.uri.getScheme() != null) {
            buffer.append(this.uri.getScheme());
            buffer.append(":");
        }
        if (this.uri.getAuthority() != null) {
            buffer.append("//");
            buffer.append(this.uri.getAuthority());
        }
        if (this.uri.getPath() != null) {
            String path = this.uri.getPath();
            if (path.indexOf(47) == 0 && this.hasWindowsDrive(path, true) && this.uri.getScheme() == null && this.uri.getAuthority() == null) {
                path = path.substring(1);
            }
            buffer.append(path);
        }
        if (this.uri.getFragment() != null) {
            buffer.append("#");
            buffer.append(this.uri.getFragment());
        }
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Path)) {
            return false;
        }
        Path that = (Path)o;
        return this.uri.equals(that.uri);
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    public int compareTo(Object o) {
        Path that = (Path)o;
        return this.uri.compareTo(that.uri);
    }

    public int depth() {
        int slash;
        String path = this.uri.getPath();
        int depth = 0;
        int n = slash = path.length() == 1 && path.charAt(0) == '/' ? -1 : 0;
        while (slash != -1) {
            ++depth;
            slash = path.indexOf(SEPARATOR, slash + 1);
        }
        return depth;
    }

    @Deprecated
    public Path makeQualified(FileSystem fs) {
        return this.makeQualified(fs.getUri(), fs.getWorkingDirectory());
    }

    @InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
    public Path makeQualified(URI defaultUri, Path workingDir) {
        Path path = this;
        if (!this.isAbsolute()) {
            path = new Path(workingDir, this);
        }
        URI pathUri = path.toUri();
        String scheme = pathUri.getScheme();
        String authority = pathUri.getAuthority();
        String fragment = pathUri.getFragment();
        if (scheme != null && (authority != null || defaultUri.getAuthority() == null)) {
            return path;
        }
        if (scheme == null) {
            scheme = defaultUri.getScheme();
        }
        if (authority == null && (authority = defaultUri.getAuthority()) == null) {
            authority = "";
        }
        URI newUri = null;
        try {
            newUri = new URI(scheme, authority, this.normalizePath(pathUri.getPath()), null, fragment);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        return new Path(newUri);
    }
}

