/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ha;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.FailoverFailedException;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.ha.HAServiceProtocolHelper;
import org.apache.hadoop.ha.HAServiceStatus;
import org.apache.hadoop.ha.HAServiceTarget;
import org.apache.hadoop.ha.HealthCheckFailedException;
import org.apache.hadoop.ha.ServiceFailedException;
import org.apache.hadoop.ipc.RPC;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class FailoverController {
    private static final Log LOG = LogFactory.getLog(FailoverController.class);
    private static final int GRACEFUL_FENCE_TIMEOUT = 5000;

    private static void preFailoverChecks(HAServiceTarget target, boolean forceActive) throws FailoverFailedException {
        HAServiceStatus toSvcStatus;
        HAServiceProtocol toSvc;
        try {
            toSvc = target.getProxy();
            toSvcStatus = toSvc.getServiceStatus();
        }
        catch (IOException e) {
            String msg = "Unable to get service state for " + target;
            LOG.error((Object)msg, (Throwable)e);
            throw new FailoverFailedException(msg, e);
        }
        if (!toSvcStatus.getState().equals((Object)HAServiceProtocol.HAServiceState.STANDBY)) {
            throw new FailoverFailedException("Can't failover to an active service");
        }
        if (!toSvcStatus.isReadyToBecomeActive()) {
            String notReadyReason = toSvcStatus.getNotReadyReason();
            if (!forceActive) {
                throw new FailoverFailedException(target + " is not ready to become active: " + notReadyReason);
            }
            LOG.warn((Object)("Service is not ready to become active, but forcing: " + notReadyReason));
        }
        try {
            HAServiceProtocolHelper.monitorHealth(toSvc);
        }
        catch (HealthCheckFailedException hce) {
            throw new FailoverFailedException("Can't failover to an unhealthy service", hce);
        }
        catch (IOException e) {
            throw new FailoverFailedException("Got an IO exception", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean tryGracefulFence(Configuration conf, HAServiceTarget svc) {
        HAServiceProtocol proxy = null;
        try {
            proxy = svc.getProxy(conf, 5000);
            proxy.transitionToStandby();
            boolean bl = true;
            return bl;
        }
        catch (ServiceFailedException sfe) {
            LOG.warn((Object)("Unable to gracefully make " + svc + " standby (" + sfe.getMessage() + ")"));
        }
        catch (IOException ioe) {
            LOG.warn((Object)("Unable to gracefully make " + svc + " standby (unable to connect)"), (Throwable)ioe);
        }
        finally {
            if (proxy != null) {
                RPC.stopProxy(proxy);
            }
        }
        return false;
    }

    public static void failover(HAServiceTarget fromSvc, HAServiceTarget toSvc, boolean forceFence, boolean forceActive) throws FailoverFailedException {
        Preconditions.checkArgument((fromSvc.getFencer() != null ? 1 : 0) != 0, (Object)"failover requires a fencer");
        FailoverController.preFailoverChecks(toSvc, forceActive);
        boolean tryFence = true;
        if (FailoverController.tryGracefulFence(new Configuration(), fromSvc)) {
            tryFence = forceFence;
        }
        if (tryFence && !fromSvc.getFencer().fence(fromSvc)) {
            throw new FailoverFailedException("Unable to fence " + fromSvc + ". Fencing failed.");
        }
        boolean failed = false;
        IOException cause = null;
        try {
            HAServiceProtocolHelper.transitionToActive(toSvc.getProxy());
        }
        catch (ServiceFailedException sfe) {
            LOG.error((Object)("Unable to make " + toSvc + " active (" + sfe.getMessage() + "). Failing back."));
            failed = true;
            cause = sfe;
        }
        catch (IOException ioe) {
            LOG.error((Object)("Unable to make " + toSvc + " active (unable to connect). Failing back."), (Throwable)ioe);
            failed = true;
            cause = ioe;
        }
        if (failed) {
            String msg = "Unable to failover to " + toSvc;
            if (!tryFence) {
                try {
                    FailoverController.failover(toSvc, fromSvc, true, true);
                }
                catch (FailoverFailedException ffe) {
                    msg = msg + ". Failback to " + fromSvc + " failed (" + ffe.getMessage() + ")";
                    LOG.fatal((Object)msg);
                }
            }
            throw new FailoverFailedException(msg, cause);
        }
    }
}

