/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ha;

import java.io.IOException;
import java.net.InetSocketAddress;
import javax.net.SocketFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.BadFencingConfigurationException;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.ha.NodeFencer;
import org.apache.hadoop.ha.protocolPB.HAServiceProtocolClientSideTranslatorPB;
import org.apache.hadoop.net.NetUtils;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class HAServiceTarget {
    public abstract InetSocketAddress getAddress();

    public abstract NodeFencer getFencer();

    public abstract void checkFencingConfigured() throws BadFencingConfigurationException;

    public HAServiceProtocol getProxy(Configuration conf, int timeoutMs) throws IOException {
        Configuration confCopy = new Configuration(conf);
        confCopy.setInt("ipc.client.connect.max.retries", 1);
        SocketFactory factory = NetUtils.getDefaultSocketFactory(confCopy);
        return new HAServiceProtocolClientSideTranslatorPB(this.getAddress(), confCopy, factory, timeoutMs);
    }

    public final HAServiceProtocol getProxy() throws IOException {
        return this.getProxy(new Configuration(), 0);
    }
}

