/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;

public class RpcPayloadHeader
implements Writable {
    private RpcKind kind;
    private RpcPayloadOperation operation;
    private int callId;

    public RpcPayloadHeader() {
        this.kind = RpcKind.RPC_WRITABLE;
        this.operation = RpcPayloadOperation.RPC_CLOSE_CONNECTION;
    }

    public RpcPayloadHeader(RpcKind kind, RpcPayloadOperation op, int callId) {
        this.kind = kind;
        this.operation = op;
        this.callId = callId;
    }

    int getCallId() {
        return this.callId;
    }

    RpcKind getkind() {
        return this.kind;
    }

    RpcPayloadOperation getOperation() {
        return this.operation;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        this.kind.write(out);
        this.operation.write(out);
        out.writeInt(this.callId);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.kind = RpcKind.readFields(in);
        this.operation = RpcPayloadOperation.readFields(in);
        this.callId = in.readInt();
    }

    public static enum RpcKind {
        RPC_BUILTIN(1),
        RPC_WRITABLE(2),
        RPC_PROTOCOL_BUFFER(3);

        static final short MAX_INDEX;
        private static final short FIRST_INDEX;
        private final short value;

        private RpcKind(short val) {
            this.value = val;
        }

        public void write(DataOutput out) throws IOException {
            out.writeByte(this.value);
        }

        static RpcKind readFields(DataInput in) throws IOException {
            short inValue = in.readByte();
            return RpcKind.values()[inValue - FIRST_INDEX];
        }

        static {
            MAX_INDEX = RpcKind.RPC_PROTOCOL_BUFFER.value;
            FIRST_INDEX = RpcKind.RPC_BUILTIN.value;
        }
    }

    public static enum RpcPayloadOperation {
        RPC_FINAL_PAYLOAD(1),
        RPC_CONTINUATION_PAYLOAD(2),
        RPC_CLOSE_CONNECTION(3);

        private final short code;
        private static final short FIRST_INDEX;

        private RpcPayloadOperation(short val) {
            this.code = val;
        }

        public void write(DataOutput out) throws IOException {
            out.writeByte(this.code);
        }

        static RpcPayloadOperation readFields(DataInput in) throws IOException {
            short inValue = in.readByte();
            return RpcPayloadOperation.values()[inValue - FIRST_INDEX];
        }

        static {
            FIRST_INDEX = RpcPayloadOperation.RPC_FINAL_PAYLOAD.code;
        }
    }
}

