/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.Trash;
import org.apache.hadoop.fs.shell.Command;
import org.apache.hadoop.fs.shell.CommandFactory;
import org.apache.hadoop.fs.shell.FsCommand;
import org.apache.hadoop.fs.shell.PathExceptions;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

@InterfaceAudience.Private
public class FsShell
extends Configured
implements Tool {
    static final Log LOG = LogFactory.getLog(FsShell.class);
    private FileSystem fs = null;
    private Trash trash = null;
    protected CommandFactory commandFactory = new CommandFactory();
    private static Pattern[] fnfPatterns = new Pattern[]{Pattern.compile("File (.*) does not exist\\."), Pattern.compile("File does not exist: (.*)"), Pattern.compile("`(.*)': specified destination directory doest not exist")};

    public FsShell() {
        this(null);
    }

    public FsShell(Configuration conf) {
        super(conf);
    }

    protected FileSystem getFS() throws IOException {
        if (this.fs == null) {
            this.fs = FileSystem.get(this.getConf());
        }
        return this.fs;
    }

    protected Trash getTrash() throws IOException {
        if (this.trash == null) {
            this.trash = new Trash(this.getConf());
        }
        return this.trash;
    }

    protected void init() throws IOException {
        this.getConf().setQuietMode(true);
    }

    public Path getCurrentTrashDir() throws IOException {
        return this.getTrash().getCurrentTrashDir();
    }

    @Deprecated
    public static String byteDesc(long len) {
        return StringUtils.byteDesc(len);
    }

    @Deprecated
    public static synchronized String limitDecimalTo2(double d) {
        return StringUtils.limitDecimalTo2(d);
    }

    private void printHelp(String cmd) {
        String summary = "hadoop fs is the command to execute fs commands. The full syntax is: \n\nhadoop fs [-fs <local | file system URI>] [-conf <configuration file>]\n\t[-D <property=value>]\n\t[-report]";
        String conf = "-conf <configuration file>:  Specify an application configuration file.";
        String D = "-D <property=value>:  Use value for given property.";
        String fs = "-fs [local | <file system URI>]: \tSpecify the file system to use.\n\t\tIf not specified, the current configuration is used, \n\t\ttaken from the following, in increasing precedence: \n\t\t\tcore-default.xml inside the hadoop jar file \n\t\t\tcore-site.xml in $HADOOP_CONF_DIR \n\t\t'local' means use the local file system as your DFS. \n\t\t<file system URI> specifies a particular file system to \n\t\tcontact. This argument is optional but if used must appear\n\t\tappear first on the command line.  Exactly one additional\n\t\targument must be specified. \n";
        String help = "-help [cmd]: \tDisplays help for given command or all commands if none\n\t\tis specified.\n";
        Command instance = this.commandFactory.getInstance("-" + cmd);
        if (instance != null) {
            this.printHelp(instance);
        } else if ("fs".equals(cmd)) {
            System.out.println(fs);
        } else if ("conf".equals(cmd)) {
            System.out.println(conf);
        } else if ("D".equals(cmd)) {
            System.out.println(D);
        } else if ("help".equals(cmd)) {
            System.out.println(help);
        } else {
            System.out.println(summary);
            for (String thisCmdName : this.commandFactory.getNames()) {
                instance = this.commandFactory.getInstance(thisCmdName);
                if (instance.isDeprecated()) continue;
                System.out.println("\t[" + instance.getUsage() + "]");
            }
            System.out.println("\t[-help [cmd]]\n");
            System.out.println(fs);
            for (String thisCmdName : this.commandFactory.getNames()) {
                instance = this.commandFactory.getInstance(thisCmdName);
                if (instance.isDeprecated()) continue;
                this.printHelp(instance);
            }
            System.out.println(help);
        }
    }

    private void printHelp(Command instance) {
        boolean firstLine = true;
        for (String line : instance.getDescription().split("\n")) {
            String prefix;
            if (firstLine) {
                prefix = instance.getUsage() + ":\t";
                firstLine = false;
            } else {
                prefix = "\t\t";
            }
            System.out.println(prefix + line);
        }
    }

    private void printUsage(String cmd) {
        String prefix = "Usage: java " + FsShell.class.getSimpleName();
        Command instance = this.commandFactory.getInstance(cmd);
        if (instance != null) {
            System.err.println(prefix + " [" + instance.getUsage() + "]");
        } else if ("-fs".equals(cmd)) {
            System.err.println("Usage: java FsShell [-fs <local | file system URI>]");
        } else if ("-conf".equals(cmd)) {
            System.err.println("Usage: java FsShell [-conf <configuration file>]");
        } else if ("-D".equals(cmd)) {
            System.err.println("Usage: java FsShell [-D <[property=value>]");
        } else {
            System.err.println("Usage: java FsShell");
            for (String name : this.commandFactory.getNames()) {
                instance = this.commandFactory.getInstance(name);
                if (instance.isDeprecated()) continue;
                System.err.println("           [" + instance.getUsage() + "]");
            }
            System.err.println("           [-help [cmd]]");
            System.err.println();
            ToolRunner.printGenericCommandUsage(System.err);
        }
    }

    @Override
    public int run(String[] argv) throws Exception {
        int exitCode;
        block12: {
            this.commandFactory.setConf(this.getConf());
            this.commandFactory.registerCommands(FsCommand.class);
            if (argv.length < 1) {
                this.printUsage("");
                return -1;
            }
            exitCode = -1;
            int i = 0;
            String cmd = argv[i++];
            try {
                this.init();
            }
            catch (RPC.VersionMismatch v) {
                LOG.debug((Object)"Version mismatch", (Throwable)v);
                System.err.println("Version Mismatch between client and server... command aborted.");
                return exitCode;
            }
            catch (IOException e) {
                LOG.debug((Object)"Error", (Throwable)e);
                System.err.println("Bad connection to FS. Command aborted. Exception: " + e.getLocalizedMessage());
                return exitCode;
            }
            try {
                Command instance = this.commandFactory.getInstance(cmd);
                if (instance != null) {
                    exitCode = instance.run(Arrays.copyOfRange(argv, i, argv.length));
                } else if ("-help".equals(cmd)) {
                    if (i < argv.length) {
                        this.printHelp(argv[i]);
                    } else {
                        this.printHelp("");
                    }
                } else {
                    System.err.println(cmd + ": Unknown command");
                    this.printUsage("");
                }
            }
            catch (Exception e) {
                exitCode = 1;
                LOG.debug((Object)"Error", (Throwable)e);
                this.displayError(cmd, e);
                if (!(e instanceof IllegalArgumentException)) break block12;
                exitCode = -1;
                this.printUsage(cmd);
            }
        }
        return exitCode;
    }

    private void displayError(String cmd, Exception e) {
        String message = e.getLocalizedMessage().split("\n")[0];
        for (Pattern pattern : fnfPatterns) {
            Matcher matcher = pattern.matcher(message);
            if (!matcher.matches()) continue;
            message = new PathExceptions.PathNotFoundException(matcher.group(1)).getMessage();
            break;
        }
        System.err.println(cmd.substring(1) + ": " + message);
    }

    public void close() throws IOException {
        if (this.fs != null) {
            this.fs.close();
            this.fs = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) throws Exception {
        int res;
        FsShell shell = new FsShell();
        try {
            res = ToolRunner.run(shell, argv);
        }
        finally {
            shell.close();
        }
        System.exit(res);
    }
}

