/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class Trash
extends Configured {
    private static final Log LOG = LogFactory.getLog(Trash.class);
    private static final Path CURRENT = new Path("Current");
    private static final Path TRASH = new Path(".Trash/");
    private static final FsPermission PERMISSION = new FsPermission(FsAction.ALL, FsAction.NONE, FsAction.NONE);
    private static final DateFormat CHECKPOINT = new SimpleDateFormat("yyMMddHHmmss");
    private static final int MSECS_PER_MINUTE = 60000;
    private final FileSystem fs;
    private final Path trash;
    private final Path current;
    private final long deletionInterval;
    private final Path homesParent;

    public Trash(Configuration conf) throws IOException {
        this(FileSystem.get(conf), conf);
    }

    public Trash(FileSystem fs, Configuration conf) throws IOException {
        super(conf);
        this.fs = fs;
        this.trash = new Path(fs.getHomeDirectory(), TRASH);
        this.homesParent = fs.getHomeDirectory().getParent();
        this.current = new Path(this.trash, CURRENT);
        this.deletionInterval = (long)(conf.getFloat("fs.trash.interval", 0.0f) * 60000.0f);
    }

    public static boolean moveToAppropriateTrash(FileSystem fs, Path p, Configuration conf) throws IOException {
        Path fullyResolvedPath = fs.resolvePath(p);
        Trash trash = new Trash(FileSystem.get(fullyResolvedPath.toUri(), conf), conf);
        boolean success = trash.moveToTrash(fullyResolvedPath);
        if (success) {
            System.out.println("Moved: '" + p + "' to trash at: " + trash.getCurrentTrashDir());
        }
        return success;
    }

    private Trash(Path home, Configuration conf) throws IOException {
        super(conf);
        this.fs = home.getFileSystem(conf);
        this.trash = new Path(home, TRASH);
        this.homesParent = home.getParent();
        this.current = new Path(this.trash, CURRENT);
        this.deletionInterval = (long)(conf.getFloat("fs.trash.interval", 0.0f) * 60000.0f);
    }

    private Path makeTrashRelativePath(Path basePath, Path rmFilePath) {
        return new Path(basePath + rmFilePath.toUri().getPath());
    }

    public boolean isEnabled() {
        return this.deletionInterval != 0L;
    }

    public boolean moveToTrash(Path path) throws IOException {
        if (!this.isEnabled()) {
            return false;
        }
        if (!path.isAbsolute()) {
            path = new Path(this.fs.getWorkingDirectory(), path);
        }
        if (!this.fs.exists(path)) {
            throw new FileNotFoundException(path.toString());
        }
        String qpath = this.fs.makeQualified(path).toString();
        if (qpath.startsWith(this.trash.toString())) {
            return false;
        }
        if (this.trash.getParent().toString().startsWith(qpath)) {
            throw new IOException("Cannot move \"" + path + "\" to the trash, as it contains the trash");
        }
        Path trashPath = this.makeTrashRelativePath(this.current, path);
        Path baseTrashPath = this.makeTrashRelativePath(this.current, path.getParent());
        IOException cause = null;
        for (int i = 0; i < 2; ++i) {
            try {
                if (!this.fs.mkdirs(baseTrashPath, PERMISSION)) {
                    LOG.warn((Object)("Can't create(mkdir) trash directory: " + baseTrashPath));
                    return false;
                }
            }
            catch (IOException e) {
                LOG.warn((Object)("Can't create trash directory: " + baseTrashPath));
                cause = e;
                break;
            }
            try {
                String orig = trashPath.toString();
                while (this.fs.exists(trashPath)) {
                    trashPath = new Path(orig + System.currentTimeMillis());
                }
                if (!this.fs.rename(path, trashPath)) continue;
                return true;
            }
            catch (IOException e) {
                cause = e;
            }
        }
        throw (IOException)new IOException("Failed to move to trash: " + path).initCause(cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkpoint() throws IOException {
        Path checkpoint;
        if (!this.fs.exists(this.current)) {
            return;
        }
        DateFormat dateFormat = CHECKPOINT;
        synchronized (dateFormat) {
            checkpoint = new Path(this.trash, CHECKPOINT.format(new Date()));
        }
        if (!this.fs.rename(this.current, checkpoint)) {
            throw new IOException("Failed to checkpoint trash: " + checkpoint);
        }
        LOG.info((Object)("Created trash checkpoint: " + checkpoint.toUri().getPath()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expunge() throws IOException {
        FileStatus[] dirs = null;
        try {
            dirs = this.fs.listStatus(this.trash);
        }
        catch (FileNotFoundException fnfe) {
            return;
        }
        long now = System.currentTimeMillis();
        for (int i = 0; i < dirs.length; ++i) {
            long time;
            Path path = dirs[i].getPath();
            String dir = path.toUri().getPath();
            String name = path.getName();
            if (name.equals(CURRENT.getName())) continue;
            try {
                DateFormat dateFormat = CHECKPOINT;
                synchronized (dateFormat) {
                    time = CHECKPOINT.parse(name).getTime();
                }
            }
            catch (ParseException e) {
                LOG.warn((Object)("Unexpected item in trash: " + dir + ". Ignoring."));
                continue;
            }
            if (now - this.deletionInterval <= time) continue;
            if (this.fs.delete(path, true)) {
                LOG.info((Object)("Deleted trash checkpoint: " + dir));
                continue;
            }
            LOG.warn((Object)("Couldn't delete checkpoint: " + dir + " Ignoring."));
        }
    }

    Path getCurrentTrashDir() {
        return this.current;
    }

    public Runnable getEmptier() throws IOException {
        return new Emptier(this.getConf());
    }

    public static void main(String[] args) throws Exception {
        new Trash(new Configuration()).getEmptier().run();
    }

    private class Emptier
    implements Runnable {
        private Configuration conf;
        private long emptierInterval;

        Emptier(Configuration conf) throws IOException {
            this.conf = conf;
            this.emptierInterval = (long)(conf.getFloat("fs.trash.checkpoint.interval", 0.0f) * 60000.0f);
            if (this.emptierInterval > Trash.this.deletionInterval || this.emptierInterval == 0L) {
                LOG.warn((Object)("The configured interval for checkpoint is " + this.emptierInterval + " minutes." + " Using interval of " + Trash.this.deletionInterval + " minutes that is used for deletion instead"));
                this.emptierInterval = Trash.this.deletionInterval;
            }
        }

        @Override
        public void run() {
            if (this.emptierInterval == 0L) {
                return;
            }
            long now = System.currentTimeMillis();
            block10: while (true) {
                long end = this.ceiling(now, this.emptierInterval);
                try {
                    Thread.sleep(end - now);
                }
                catch (InterruptedException e) {
                    break;
                }
                try {
                    now = System.currentTimeMillis();
                    if (now < end) continue;
                    FileStatus[] homes = null;
                    try {
                        homes = Trash.this.fs.listStatus(Trash.this.homesParent);
                    }
                    catch (IOException e) {
                        LOG.warn((Object)("Trash can't list homes: " + e + " Sleeping."));
                        continue;
                    }
                    FileStatus[] arr$ = homes;
                    int len$ = arr$.length;
                    int i$ = 0;
                    while (true) {
                        if (i$ >= len$) continue block10;
                        FileStatus home = arr$[i$];
                        if (home.isDirectory()) {
                            try {
                                Trash trash = new Trash(home.getPath(), this.conf);
                                trash.expunge();
                                trash.checkpoint();
                            }
                            catch (IOException e) {
                                LOG.warn((Object)("Trash caught: " + e + ". Skipping " + home.getPath() + "."));
                            }
                        }
                        ++i$;
                    }
                }
                catch (Exception e) {
                    LOG.warn((Object)("RuntimeException during Trash.Emptier.run() " + StringUtils.stringifyException(e)));
                    continue;
                }
                break;
            }
            try {
                Trash.this.fs.close();
            }
            catch (IOException e) {
                LOG.warn((Object)("Trash cannot close FileSystem. " + StringUtils.stringifyException(e)));
            }
        }

        private long ceiling(long time, long interval) {
            return this.floor(time, interval) + interval;
        }

        private long floor(long time, long interval) {
            return time / interval * interval;
        }
    }
}

