/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.shell.PathData;
import org.apache.hadoop.fs.shell.PathExceptions;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public abstract class Command
extends Configured {
    protected String[] args;
    protected String name;
    protected int exitCode = 0;
    protected int numErrors = 0;
    protected boolean recursive = false;
    protected ArrayList<Exception> exceptions = new ArrayList();
    private static final Log LOG = LogFactory.getLog(Command.class);
    public PrintStream out = System.out;
    public PrintStream err = System.err;

    protected Command() {
        this.out = System.out;
        this.err = System.err;
    }

    protected Command(Configuration conf) {
        super(conf);
    }

    public abstract String getCommandName();

    public void setCommandName(String cmdName) {
        this.name = cmdName;
    }

    protected void setRecursive(boolean flag) {
        this.recursive = flag;
    }

    protected boolean isRecursive() {
        return this.recursive;
    }

    protected abstract void run(Path var1) throws IOException;

    public int runAll() {
        int exitCode = 0;
        for (String src : this.args) {
            try {
                PathData[] srcs;
                for (PathData s : srcs = PathData.expandAsGlob(src, this.getConf())) {
                    this.run(s.path);
                }
            }
            catch (IOException e) {
                exitCode = -1;
                this.displayError(e);
            }
        }
        return exitCode;
    }

    public int run(String ... argv) {
        LinkedList<String> args = new LinkedList<String>(Arrays.asList(argv));
        try {
            if (this.isDeprecated()) {
                this.displayWarning("DEPRECATED: Please use '" + this.getReplacementCommand() + "' instead.");
            }
            this.processOptions(args);
            this.processArguments(this.expandArguments(args));
        }
        catch (IOException e) {
            this.displayError(e);
        }
        return this.numErrors == 0 ? this.exitCode : this.exitCodeForError();
    }

    protected int exitCodeForError() {
        return 1;
    }

    protected void processOptions(LinkedList<String> args) throws IOException {
    }

    protected LinkedList<PathData> expandArguments(LinkedList<String> args) throws IOException {
        LinkedList<PathData> expandedArgs = new LinkedList<PathData>();
        for (String arg : args) {
            try {
                expandedArgs.addAll(this.expandArgument(arg));
            }
            catch (IOException e) {
                this.displayError(e);
            }
        }
        return expandedArgs;
    }

    protected List<PathData> expandArgument(String arg) throws IOException {
        PathData[] items = PathData.expandAsGlob(arg, this.getConf());
        if (items.length == 0) {
            throw new PathExceptions.PathNotFoundException(arg);
        }
        return Arrays.asList(items);
    }

    protected void processArguments(LinkedList<PathData> args) throws IOException {
        for (PathData arg : args) {
            try {
                this.processArgument(arg);
            }
            catch (IOException e) {
                this.displayError(e);
            }
        }
    }

    protected void processArgument(PathData item) throws IOException {
        if (item.exists) {
            this.processPathArgument(item);
        } else {
            this.processNonexistentPath(item);
        }
    }

    protected void processPathArgument(PathData item) throws IOException {
        this.processPaths(null, item);
    }

    protected void processNonexistentPath(PathData item) throws IOException {
        throw new PathExceptions.PathNotFoundException(item.toString());
    }

    protected void processPaths(PathData parent, PathData ... items) throws IOException {
        for (PathData item : items) {
            try {
                this.processPath(item);
                if (!this.recursive || !item.stat.isDirectory()) continue;
                this.recursePath(item);
            }
            catch (IOException e) {
                this.displayError(e);
            }
        }
    }

    protected void processPath(PathData item) throws IOException {
        throw new RuntimeException("processPath() is not implemented");
    }

    protected void recursePath(PathData item) throws IOException {
        this.processPaths(item, item.getDirectoryContents());
    }

    public void displayError(Exception e) {
        this.exceptions.add(e);
        String errorMessage = e.getLocalizedMessage();
        if (errorMessage == null) {
            errorMessage = StringUtils.stringifyException(e);
            LOG.debug((Object)errorMessage);
        } else {
            errorMessage = errorMessage.split("\n", 2)[0];
        }
        this.displayError(errorMessage);
    }

    public void displayError(String message) {
        ++this.numErrors;
        this.displayWarning(message);
    }

    public void displayWarning(String message) {
        this.err.println(this.getCommandName() + ": " + message);
    }

    public String getUsage() {
        String cmd = "-" + this.getCommandName();
        String usage = this.isDeprecated() ? "" : this.getCommandField("USAGE");
        return usage.isEmpty() ? cmd : cmd + " " + usage;
    }

    public String getDescription() {
        return this.isDeprecated() ? "(DEPRECATED) Same as '" + this.getReplacementCommand() + "'" : this.getCommandField("DESCRIPTION");
    }

    public final boolean isDeprecated() {
        return this.getReplacementCommand() != null;
    }

    public String getReplacementCommand() {
        return null;
    }

    private String getCommandField(String field) {
        String value;
        try {
            value = (String)this.getClass().getField(field).get(null);
        }
        catch (Exception e) {
            throw new RuntimeException(StringUtils.stringifyException(e));
        }
        return value;
    }
}

