/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.shell.PathExceptions;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class PathData {
    protected String string = null;
    public final Path path;
    public FileStatus stat;
    public final FileSystem fs;
    public boolean exists;

    public PathData(String pathString, Configuration conf) throws IOException {
        this.string = pathString;
        this.path = new Path(pathString);
        this.fs = this.path.getFileSystem(conf);
        this.setStat(PathData.getStat(this.fs, this.path));
    }

    public PathData(File localPath, Configuration conf) throws IOException {
        this.string = localPath.toString();
        this.path = new Path(this.string);
        this.fs = FileSystem.getLocal(conf);
        this.setStat(PathData.getStat(this.fs, this.path));
    }

    public PathData(FileSystem fs, Path path, FileStatus stat) {
        this.string = path.toString();
        this.path = path;
        this.fs = fs;
        this.setStat(stat);
    }

    public PathData(FileSystem fs, Path path) throws IOException {
        this(fs, path, PathData.getStat(fs, path));
    }

    public PathData(FileSystem fs, String pathString, FileStatus stat) {
        this.string = pathString;
        this.path = stat != null ? stat.getPath() : new Path(pathString);
        this.fs = fs;
        this.setStat(stat);
    }

    private static FileStatus getStat(FileSystem fs, Path path) throws IOException {
        FileStatus status = null;
        try {
            status = fs.getFileStatus(path);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return status;
    }

    private void setStat(FileStatus theStat) {
        this.stat = theStat;
        this.exists = this.stat != null;
    }

    public PathData(FileSystem fs, FileStatus stat) {
        this(fs, stat.getPath(), stat);
    }

    public FileStatus refreshStatus() throws IOException {
        this.setStat(this.fs.getFileStatus(this.path));
        return this.stat;
    }

    public PathData[] getDirectoryContents() throws IOException {
        if (!this.stat.isDirectory()) {
            throw new PathExceptions.PathIsNotDirectoryException(this.string);
        }
        FileStatus[] stats = this.fs.listStatus(this.path);
        PathData[] items = new PathData[stats.length];
        for (int i = 0; i < stats.length; ++i) {
            String basename = stats[i].getPath().getName();
            String parent = this.string;
            if (!parent.endsWith("/")) {
                parent = parent + "/";
            }
            items[i] = new PathData(this.fs, parent + basename, stats[i]);
        }
        return items;
    }

    public PathData getPathDataForChild(PathData child) throws IOException {
        if (!this.stat.isDirectory()) {
            throw new PathExceptions.PathIsNotDirectoryException(this.string);
        }
        return new PathData(this.fs, new Path(this.path, child.path.getName()));
    }

    public static PathData[] expandAsGlob(String pattern, Configuration conf) throws IOException {
        Path globPath = new Path(pattern);
        FileSystem fs = globPath.getFileSystem(conf);
        FileStatus[] stats = fs.globStatus(globPath);
        PathData[] items = null;
        if (stats == null) {
            items = new PathData[]{new PathData(fs, pattern, null)};
        } else if (stats.length == 1 && stats[0].getPath().equals(fs.makeQualified(globPath))) {
            items = new PathData[]{new PathData(fs, pattern, stats[0])};
        } else {
            items = new PathData[stats.length];
            int i = 0;
            for (FileStatus stat : stats) {
                items[i++] = new PathData(fs, stat);
            }
        }
        return items;
    }

    public String toString() {
        return this.string != null ? this.string : this.path.toString();
    }
}

