/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell;

import java.io.IOException;
import java.util.LinkedList;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.shell.CommandFactory;
import org.apache.hadoop.fs.shell.CommandFormat;
import org.apache.hadoop.fs.shell.FsCommand;
import org.apache.hadoop.fs.shell.PathData;
import org.apache.hadoop.fs.shell.PathExceptions;

@InterfaceAudience.Private
@InterfaceStability.Unstable
class Test
extends FsCommand {
    public static final String NAME = "test";
    public static final String USAGE = "-[ezd] <path>";
    public static final String DESCRIPTION = "If file exists, has zero length, is a directory\nthen return 0, else return 1.";
    private char flag;

    Test() {
    }

    public static void registerCommands(CommandFactory factory) {
        factory.addClass(Test.class, "-test");
    }

    @Override
    protected void processOptions(LinkedList<String> args) {
        CommandFormat cf = new CommandFormat(null, 1, 1, "e", "d", "z");
        cf.parse(args);
        String[] opts = cf.getOpts().toArray(new String[0]);
        switch (opts.length) {
            case 0: {
                throw new IllegalArgumentException("No test flag given");
            }
            case 1: {
                this.flag = opts[0].charAt(0);
                break;
            }
            default: {
                throw new IllegalArgumentException("Only one test flag is allowed");
            }
        }
    }

    @Override
    protected void processPath(PathData item) throws IOException {
        boolean test = false;
        switch (this.flag) {
            case 'e': {
                test = true;
                break;
            }
            case 'd': {
                test = item.stat.isDirectory();
                break;
            }
            case 'z': {
                boolean bl = test = item.stat.getLen() == 0L;
            }
        }
        if (!test) {
            this.exitCode = 1;
        }
    }

    @Override
    protected void processNonexistentPath(PathData item) throws IOException {
        if (this.flag != 'e') {
            this.displayError(new PathExceptions.PathNotFoundException(item.toString()));
        }
        this.exitCode = 1;
    }
}

