/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell;

import java.io.IOException;
import java.util.LinkedList;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.shell.CommandFactory;
import org.apache.hadoop.fs.shell.CommandFormat;
import org.apache.hadoop.fs.shell.FsCommand;
import org.apache.hadoop.fs.shell.PathData;
import org.apache.hadoop.fs.shell.PathExceptions;

@InterfaceAudience.Private
@InterfaceStability.Unstable
class Touch
extends FsCommand {
    Touch() {
    }

    public static void registerCommands(CommandFactory factory) {
        factory.addClass(Touchz.class, "-touchz");
    }

    public static class Touchz
    extends Touch {
        public static final String NAME = "touchz";
        public static final String USAGE = "<path> ...";
        public static final String DESCRIPTION = "Creates a file of zero length\nat <path> with current time as the timestamp of that <path>.\nAn error is returned if the file exists with non-zero length\n";

        @Override
        protected void processOptions(LinkedList<String> args) {
            CommandFormat cf = new CommandFormat(null, 1, Integer.MAX_VALUE, new String[0]);
            cf.parse(args);
        }

        @Override
        protected void processPath(PathData item) throws IOException {
            if (item.stat.isDirectory()) {
                throw new PathExceptions.PathIsDirectoryException(item.toString());
            }
            if (item.stat.getLen() != 0L) {
                throw new PathExceptions.PathIOException(item.toString(), "Not a zero-length file");
            }
            this.touchz(item);
        }

        @Override
        protected void processNonexistentPath(PathData item) throws IOException {
            this.touchz(item);
        }

        private void touchz(PathData item) throws IOException {
            item.fs.create(item.path).close();
        }
    }
}

