/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.FsStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.viewfs.ViewFsFileStatus;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.Progressable;

@InterfaceAudience.Private
@InterfaceStability.Evolving
class ChRootedFileSystem
extends FileSystem {
    private final FileSystem myFs;
    private final URI myUri;
    private final Path chRootPathPart;
    private final String chRootPathPartString;
    private Path workingDir;

    protected FileSystem getMyFs() {
        return this.myFs;
    }

    protected Path fullPath(Path path) {
        super.checkPath(path);
        return path.isAbsolute() ? new Path(this.chRootPathPartString + path.toUri().getPath()) : new Path(this.chRootPathPartString + this.workingDir.toUri().getPath(), path);
    }

    public ChRootedFileSystem(FileSystem fs, Path theRoot) throws URISyntaxException {
        this.myFs = fs;
        this.myFs.makeQualified(theRoot);
        this.chRootPathPart = new Path(theRoot.toUri().getPath());
        this.chRootPathPartString = this.chRootPathPart.toUri().getPath();
        try {
            this.initialize(fs.getUri(), fs.getConf());
        }
        catch (IOException e) {
            throw new RuntimeException("This should not occur");
        }
        this.myUri = new URI(this.myFs.getUri().toString() + (this.myFs.getUri().getAuthority() == null ? "" : "/") + this.chRootPathPart.toString().substring(1));
        this.workingDir = this.getHomeDirectory();
    }

    @Override
    public void initialize(URI name, Configuration conf) throws IOException {
        this.myFs.initialize(name, conf);
        super.initialize(name, conf);
        this.setConf(conf);
    }

    @Override
    public URI getUri() {
        return this.myUri;
    }

    @Override
    public Path makeQualified(Path path) {
        return this.myFs.makeQualified(path);
    }

    String stripOutRoot(Path p) throws IOException {
        try {
            this.checkPath(p);
        }
        catch (IllegalArgumentException e) {
            throw new IOException("Internal Error - path " + p + " should have been with URI: " + this.myUri);
        }
        String pathPart = p.toUri().getPath();
        return pathPart.length() == this.chRootPathPartString.length() ? "" : pathPart.substring(this.chRootPathPartString.length() + 1);
    }

    @Override
    protected Path getInitialWorkingDirectory() {
        return null;
    }

    public Path getResolvedQualifiedPath(Path f) throws FileNotFoundException {
        return this.myFs.makeQualified(new Path(this.chRootPathPartString + f.toUri().toString()));
    }

    @Override
    public Path getHomeDirectory() {
        return new Path("/user/" + System.getProperty("user.name")).makeQualified(this.getUri(), null);
    }

    @Override
    public Path getWorkingDirectory() {
        return this.workingDir;
    }

    @Override
    public void setWorkingDirectory(Path new_dir) {
        this.workingDir = new_dir.isAbsolute() ? new_dir : new Path(this.workingDir, new_dir);
    }

    @Override
    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return this.myFs.create(this.fullPath(f), permission, overwrite, bufferSize, replication, blockSize, progress);
    }

    @Override
    public boolean delete(Path f, boolean recursive) throws IOException {
        return this.myFs.delete(this.fullPath(f), recursive);
    }

    @Override
    public boolean delete(Path f) throws IOException {
        return this.delete(f, true);
    }

    @Override
    public BlockLocation[] getFileBlockLocations(FileStatus fs, long start, long len) throws IOException {
        return this.myFs.getFileBlockLocations(new ViewFsFileStatus(fs, this.fullPath(fs.getPath())), start, len);
    }

    @Override
    public FileChecksum getFileChecksum(Path f) throws IOException {
        return this.myFs.getFileChecksum(this.fullPath(f));
    }

    @Override
    public FileStatus getFileStatus(Path f) throws IOException {
        return this.myFs.getFileStatus(this.fullPath(f));
    }

    @Override
    public FsStatus getStatus(Path p) throws IOException {
        return this.myFs.getStatus(this.fullPath(p));
    }

    @Override
    public FsServerDefaults getServerDefaults() throws IOException {
        return this.myFs.getServerDefaults();
    }

    @Override
    public FileStatus[] listStatus(Path f) throws IOException {
        return this.myFs.listStatus(this.fullPath(f));
    }

    @Override
    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        return this.myFs.mkdirs(this.fullPath(f), permission);
    }

    @Override
    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        return this.myFs.open(this.fullPath(f), bufferSize);
    }

    @Override
    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        return this.myFs.append(this.fullPath(f), bufferSize, progress);
    }

    @Override
    public boolean rename(Path src, Path dst) throws IOException {
        return this.myFs.rename(this.fullPath(src), this.fullPath(dst));
    }

    @Override
    public void setOwner(Path f, String username, String groupname) throws IOException {
        this.myFs.setOwner(this.fullPath(f), username, groupname);
    }

    @Override
    public void setPermission(Path f, FsPermission permission) throws IOException {
        this.myFs.setPermission(this.fullPath(f), permission);
    }

    @Override
    public boolean setReplication(Path f, short replication) throws IOException {
        return this.myFs.setReplication(this.fullPath(f), replication);
    }

    @Override
    public void setTimes(Path f, long mtime, long atime) throws IOException {
        this.myFs.setTimes(this.fullPath(f), mtime, atime);
    }

    @Override
    public void setVerifyChecksum(boolean verifyChecksum) {
        this.myFs.setVerifyChecksum(verifyChecksum);
    }

    @Override
    public List<Token<?>> getDelegationTokens(String renewer) throws IOException {
        return this.myFs.getDelegationTokens(renewer);
    }
}

