/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.lib;

import javax.management.ObjectName;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.metrics2.MetricsException;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.impl.MetricsSystemImpl;
import org.apache.hadoop.metrics2.lib.UniqueNames;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public enum DefaultMetricsSystem {
    INSTANCE;

    private MetricsSystem impl = new MetricsSystemImpl();
    volatile boolean miniClusterMode = false;
    final UniqueNames mBeanNames = new UniqueNames();
    final UniqueNames sourceNames = new UniqueNames();

    public static MetricsSystem initialize(String prefix) {
        return INSTANCE.init(prefix);
    }

    synchronized MetricsSystem init(String prefix) {
        return this.impl.init(prefix);
    }

    public static MetricsSystem instance() {
        return INSTANCE.getImpl();
    }

    public static void shutdown() {
        INSTANCE.shutdownInstance();
    }

    synchronized void shutdownInstance() {
        if (this.impl.shutdown()) {
            this.mBeanNames.map.clear();
            this.sourceNames.map.clear();
        }
    }

    @InterfaceAudience.Private
    public static MetricsSystem setInstance(MetricsSystem ms) {
        return INSTANCE.setImpl(ms);
    }

    synchronized MetricsSystem setImpl(MetricsSystem ms) {
        MetricsSystem old = this.impl;
        this.impl = ms;
        return old;
    }

    synchronized MetricsSystem getImpl() {
        return this.impl;
    }

    @InterfaceAudience.Private
    public static void setMiniClusterMode(boolean choice) {
        DefaultMetricsSystem.INSTANCE.miniClusterMode = choice;
    }

    @InterfaceAudience.Private
    public static boolean inMiniClusterMode() {
        return DefaultMetricsSystem.INSTANCE.miniClusterMode;
    }

    @InterfaceAudience.Private
    public static ObjectName newMBeanName(String name) {
        return INSTANCE.newObjectName(name);
    }

    @InterfaceAudience.Private
    public static String sourceName(String name, boolean dupOK) {
        return INSTANCE.newSourceName(name, dupOK);
    }

    synchronized ObjectName newObjectName(String name) {
        try {
            if (this.mBeanNames.map.containsKey(name) && !this.miniClusterMode) {
                throw new MetricsException(name + " already exists!");
            }
            return new ObjectName(this.mBeanNames.uniqueName(name));
        }
        catch (Exception e) {
            throw new MetricsException(e);
        }
    }

    synchronized String newSourceName(String name, boolean dupOK) {
        if (this.sourceNames.map.containsKey(name)) {
            if (dupOK) {
                return name;
            }
            if (!this.miniClusterMode) {
                throw new MetricsException("Metrics source " + name + " already exists!");
            }
        }
        return this.sourceNames.uniqueName(name);
    }
}

