/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.lib;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.lib.MutableCounter;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class MutableCounterInt
extends MutableCounter {
    private volatile int value;

    MutableCounterInt(MetricsInfo info, int initValue) {
        super(info);
        this.value = initValue;
    }

    @Override
    public synchronized void incr() {
        ++this.value;
        this.setChanged();
    }

    public synchronized void incr(int delta) {
        this.value += delta;
        this.setChanged();
    }

    @Override
    public void snapshot(MetricsRecordBuilder builder, boolean all) {
        if (all || this.changed()) {
            builder.addCounter(this.info(), this.value);
            this.clearChanged();
        }
    }
}

