/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.util.concurrent.ThreadFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Unstable
public class Daemon
extends Thread {
    Runnable runnable;

    public Daemon() {
        this.setDaemon(true);
        this.runnable = null;
    }

    public Daemon(Runnable runnable) {
        super(runnable);
        this.setDaemon(true);
        this.runnable = null;
        this.runnable = runnable;
        this.setName(runnable.toString());
    }

    public Daemon(ThreadGroup group, Runnable runnable) {
        super(group, runnable);
        this.setDaemon(true);
        this.runnable = null;
        this.runnable = runnable;
        this.setName(runnable.toString());
    }

    public Runnable getRunnable() {
        return this.runnable;
    }

    public static class DaemonFactory
    extends Daemon
    implements ThreadFactory {
        @Override
        public Thread newThread(Runnable runnable) {
            return new Daemon(runnable);
        }
    }
}

