/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.util.Time;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Unstable
public abstract class Shell {
    public static final Log LOG = LogFactory.getLog(Shell.class);
    private static boolean IS_JAVA7_OR_ABOVE = System.getProperty("java.version").substring(0, 3).compareTo("1.7") >= 0;
    public static final String USER_NAME_COMMAND = "whoami";
    public static final Object WindowsProcessLaunchLock = new Object();
    public static final String SET_PERMISSION_COMMAND = "chmod";
    public static final String SET_OWNER_COMMAND = "chown";
    public static final String SET_GROUP_COMMAND = "chgrp";
    public static final String LINK_COMMAND = "ln";
    public static final String READ_LINK_COMMAND = "readlink";
    protected long timeOutInterval = 0L;
    private AtomicBoolean timedOut;
    private static String HADOOP_HOME_DIR = Shell.checkHadoopHome();
    public static final boolean WINDOWS = System.getProperty("os.name").startsWith("Windows");
    public static final boolean LINUX = System.getProperty("os.name").startsWith("Linux");
    public static final String WINUTILS = Shell.getWinUtilsPath();
    public static final boolean isSetsidAvailable = Shell.isSetsidSupported();
    public static final String TOKEN_SEPARATOR_REGEX = WINDOWS ? "[|\n\r]" : "[ \t\n\r\f]";
    private long interval;
    private long lastTime;
    private Map<String, String> environment;
    private File dir;
    private Process process;
    private int exitCode;
    private volatile AtomicBoolean completed;

    public static boolean isJava7OrAbove() {
        return IS_JAVA7_OR_ABOVE;
    }

    public static String[] getGroupsCommand() {
        String[] stringArray;
        if (WINDOWS) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = "cmd";
            stringArray2[1] = "/c";
            stringArray = stringArray2;
            stringArray2[2] = "groups";
        } else {
            String[] stringArray3 = new String[3];
            stringArray3[0] = "bash";
            stringArray3[1] = "-c";
            stringArray = stringArray3;
            stringArray3[2] = "groups";
        }
        return stringArray;
    }

    public static String[] getGroupsForUserCommand(String user) {
        String[] stringArray;
        if (WINDOWS) {
            String[] stringArray2 = new String[4];
            stringArray2[0] = WINUTILS;
            stringArray2[1] = "groups";
            stringArray2[2] = "-F";
            stringArray = stringArray2;
            stringArray2[3] = "\"" + user + "\"";
        } else {
            String[] stringArray3 = new String[3];
            stringArray3[0] = "bash";
            stringArray3[1] = "-c";
            stringArray = stringArray3;
            stringArray3[2] = "id -Gn " + user;
        }
        return stringArray;
    }

    public static String[] getUsersForNetgroupCommand(String netgroup) {
        String[] stringArray;
        if (WINDOWS) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = "cmd";
            stringArray2[1] = "/c";
            stringArray = stringArray2;
            stringArray2[2] = "getent netgroup " + netgroup;
        } else {
            String[] stringArray3 = new String[3];
            stringArray3[0] = "bash";
            stringArray3[1] = "-c";
            stringArray = stringArray3;
            stringArray3[2] = "getent netgroup " + netgroup;
        }
        return stringArray;
    }

    public static String[] getGetPermissionCommand() {
        String[] stringArray;
        if (WINDOWS) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = WINUTILS;
            stringArray2[1] = "ls";
            stringArray = stringArray2;
            stringArray2[2] = "-F";
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "/bin/ls";
            stringArray = stringArray3;
            stringArray3[1] = "-ld";
        }
        return stringArray;
    }

    public static String[] getSetPermissionCommand(String perm, boolean recursive) {
        String[] stringArray;
        if (recursive) {
            String[] stringArray2;
            if (WINDOWS) {
                String[] stringArray3 = new String[4];
                stringArray3[0] = WINUTILS;
                stringArray3[1] = SET_PERMISSION_COMMAND;
                stringArray3[2] = "-R";
                stringArray2 = stringArray3;
                stringArray3[3] = perm;
            } else {
                String[] stringArray4 = new String[3];
                stringArray4[0] = SET_PERMISSION_COMMAND;
                stringArray4[1] = "-R";
                stringArray2 = stringArray4;
                stringArray4[2] = perm;
            }
            return stringArray2;
        }
        if (WINDOWS) {
            String[] stringArray5 = new String[3];
            stringArray5[0] = WINUTILS;
            stringArray5[1] = SET_PERMISSION_COMMAND;
            stringArray = stringArray5;
            stringArray5[2] = perm;
        } else {
            String[] stringArray6 = new String[2];
            stringArray6[0] = SET_PERMISSION_COMMAND;
            stringArray = stringArray6;
            stringArray6[1] = perm;
        }
        return stringArray;
    }

    public static String[] getSetPermissionCommand(String perm, boolean recursive, String file) {
        String[] baseCmd = Shell.getSetPermissionCommand(perm, recursive);
        String[] cmdWithFile = Arrays.copyOf(baseCmd, baseCmd.length + 1);
        cmdWithFile[cmdWithFile.length - 1] = file;
        return cmdWithFile;
    }

    public static String[] getSetOwnerCommand(String owner) {
        String[] stringArray;
        if (WINDOWS) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = WINUTILS;
            stringArray2[1] = SET_OWNER_COMMAND;
            stringArray = stringArray2;
            stringArray2[2] = "\"" + owner + "\"";
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = SET_OWNER_COMMAND;
            stringArray = stringArray3;
            stringArray3[1] = owner;
        }
        return stringArray;
    }

    public static String[] getSymlinkCommand(String target, String link) {
        String[] stringArray;
        if (WINDOWS) {
            String[] stringArray2 = new String[4];
            stringArray2[0] = WINUTILS;
            stringArray2[1] = "symlink";
            stringArray2[2] = link;
            stringArray = stringArray2;
            stringArray2[3] = target;
        } else {
            String[] stringArray3 = new String[4];
            stringArray3[0] = LINK_COMMAND;
            stringArray3[1] = "-s";
            stringArray3[2] = target;
            stringArray = stringArray3;
            stringArray3[3] = link;
        }
        return stringArray;
    }

    public static String[] getCheckProcessIsAliveCommand(String pid) {
        String[] stringArray;
        if (WINDOWS) {
            String[] stringArray2 = new String[4];
            stringArray2[0] = WINUTILS;
            stringArray2[1] = "task";
            stringArray2[2] = "isAlive";
            stringArray = stringArray2;
            stringArray2[3] = pid;
        } else {
            String[] stringArray3 = new String[3];
            stringArray3[0] = "kill";
            stringArray3[1] = "-0";
            stringArray = stringArray3;
            stringArray3[2] = isSetsidAvailable ? "-" + pid : pid;
        }
        return stringArray;
    }

    public static String[] getSignalKillCommand(int code, String pid) {
        String[] stringArray;
        if (WINDOWS) {
            String[] stringArray2 = new String[4];
            stringArray2[0] = WINUTILS;
            stringArray2[1] = "task";
            stringArray2[2] = "kill";
            stringArray = stringArray2;
            stringArray2[3] = pid;
        } else {
            String[] stringArray3 = new String[3];
            stringArray3[0] = "kill";
            stringArray3[1] = "-" + code;
            stringArray = stringArray3;
            stringArray3[2] = isSetsidAvailable ? "-" + pid : pid;
        }
        return stringArray;
    }

    public static File appendScriptExtension(File parent, String basename) {
        return new File(parent, Shell.appendScriptExtension(basename));
    }

    public static String appendScriptExtension(String basename) {
        return basename + (WINDOWS ? ".cmd" : ".sh");
    }

    public static String[] getRunScriptCommand(File script) {
        String[] stringArray;
        String absolutePath = script.getAbsolutePath();
        if (WINDOWS) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = "cmd";
            stringArray2[1] = "/c";
            stringArray = stringArray2;
            stringArray2[2] = absolutePath;
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "/bin/bash";
            stringArray = stringArray3;
            stringArray3[1] = absolutePath;
        }
        return stringArray;
    }

    private static String checkHadoopHome() {
        String home = System.getProperty("hadoop.home.dir");
        if (home == null) {
            home = System.getenv("HADOOP_HOME");
        }
        try {
            File homedir;
            if (home == null) {
                throw new IOException("HADOOP_HOME or hadoop.home.dir are not set.");
            }
            if (home.startsWith("\"") && home.endsWith("\"")) {
                home = home.substring(1, home.length() - 1);
            }
            if (!((homedir = new File(home)).isAbsolute() && homedir.exists() && homedir.isDirectory())) {
                throw new IOException("Hadoop home directory " + homedir + " does not exist, is not a directory, or is not an absolute path.");
            }
            home = homedir.getCanonicalPath();
        }
        catch (IOException ioe) {
            LOG.error((Object)"Failed to detect a valid hadoop home directory", (Throwable)ioe);
            home = null;
        }
        return home;
    }

    public static final String getHadoopHome() throws IOException {
        if (HADOOP_HOME_DIR == null) {
            throw new IOException("Misconfigured HADOOP_HOME cannot be referenced.");
        }
        return HADOOP_HOME_DIR;
    }

    public static final String getQualifiedBinPath(String executable) throws IOException {
        String fullExeName = HADOOP_HOME_DIR + File.separator + "bin" + File.separator + executable;
        File exeFile = new File(fullExeName);
        if (!exeFile.exists()) {
            throw new IOException("Could not locate executable " + fullExeName + " in the Hadoop binaries.");
        }
        return exeFile.getCanonicalPath();
    }

    public static final String getWinUtilsPath() {
        String winUtilsPath = null;
        try {
            if (WINDOWS) {
                winUtilsPath = Shell.getQualifiedBinPath("winutils.exe");
            }
        }
        catch (IOException ioe) {
            LOG.error((Object)"Failed to locate the winutils binary in the hadoop binary path", (Throwable)ioe);
        }
        return winUtilsPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isSetsidSupported() {
        if (WINDOWS) {
            return false;
        }
        Shell shexec = null;
        boolean setsidSupported = true;
        try {
            String[] args = new String[]{"setsid", "bash", "-c", "echo $$"};
            shexec = new ShellCommandExecutor(args);
            ((ShellCommandExecutor)shexec).execute();
        }
        catch (IOException ioe) {
            LOG.warn((Object)"setsid is not available on this machine. So not using it.");
            setsidSupported = false;
        }
        finally {
            LOG.info((Object)("setsid exited with exit code " + shexec.getExitCode()));
        }
        return setsidSupported;
    }

    public Shell() {
        this(0L);
    }

    public Shell(long interval) {
        this.interval = interval;
        this.lastTime = interval < 0L ? 0L : -interval;
    }

    protected void setEnvironment(Map<String, String> env) {
        this.environment = env;
    }

    protected void setWorkingDirectory(File dir) {
        this.dir = dir;
    }

    protected void run() throws IOException {
        if (this.lastTime + this.interval > Time.now()) {
            return;
        }
        this.exitCode = 0;
        this.runCommand();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runCommand() throws IOException {
        ProcessBuilder builder = new ProcessBuilder(this.getExecString());
        Timer timeOutTimer = null;
        ShellTimeoutTimerTask timeoutTimerTask = null;
        this.timedOut = new AtomicBoolean(false);
        this.completed = new AtomicBoolean(false);
        if (this.environment != null) {
            builder.environment().putAll(this.environment);
        }
        if (this.dir != null) {
            builder.directory(this.dir);
        }
        if (WINDOWS) {
            Object object = WindowsProcessLaunchLock;
            synchronized (object) {
                this.process = builder.start();
            }
        } else {
            this.process = builder.start();
        }
        if (this.timeOutInterval > 0L) {
            timeOutTimer = new Timer("Shell command timeout");
            timeoutTimerTask = new ShellTimeoutTimerTask(this);
            timeOutTimer.schedule((TimerTask)timeoutTimerTask, this.timeOutInterval);
        }
        final BufferedReader errReader = new BufferedReader(new InputStreamReader(this.process.getErrorStream()));
        BufferedReader inReader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
        final StringBuffer errMsg = new StringBuffer();
        Thread errThread = new Thread(){

            @Override
            public void run() {
                try {
                    String line = errReader.readLine();
                    while (line != null && !this.isInterrupted()) {
                        errMsg.append(line);
                        errMsg.append(System.getProperty("line.separator"));
                        line = errReader.readLine();
                    }
                }
                catch (IOException ioe) {
                    LOG.warn((Object)"Error reading the error stream", (Throwable)ioe);
                }
            }
        };
        try {
            errThread.start();
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        try {
            this.parseExecResult(inReader);
            String line = inReader.readLine();
            while (line != null) {
                line = inReader.readLine();
            }
            this.exitCode = this.process.waitFor();
            try {
                errThread.join();
            }
            catch (InterruptedException ie) {
                LOG.warn((Object)"Interrupted while reading the error stream", (Throwable)ie);
            }
            this.completed.set(true);
            if (this.exitCode != 0) {
                throw new ExitCodeException(this.exitCode, errMsg.toString());
            }
        }
        catch (InterruptedException ie) {
            throw new IOException(ie.toString());
        }
        finally {
            if (timeOutTimer != null) {
                timeOutTimer.cancel();
            }
            try {
                inReader.close();
            }
            catch (IOException ioe) {
                LOG.warn((Object)"Error while closing the input stream", (Throwable)ioe);
            }
            if (!this.completed.get()) {
                errThread.interrupt();
            }
            try {
                errReader.close();
            }
            catch (IOException ioe) {
                LOG.warn((Object)"Error while closing the error stream", (Throwable)ioe);
            }
            this.process.destroy();
            this.lastTime = Time.now();
        }
    }

    protected abstract String[] getExecString();

    protected abstract void parseExecResult(BufferedReader var1) throws IOException;

    public Process getProcess() {
        return this.process;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public boolean isTimedOut() {
        return this.timedOut.get();
    }

    private void setTimedOut() {
        this.timedOut.set(true);
    }

    public static String execCommand(String ... cmd) throws IOException {
        return Shell.execCommand(null, cmd, 0L);
    }

    public static String execCommand(Map<String, String> env, String[] cmd, long timeout) throws IOException {
        ShellCommandExecutor exec = new ShellCommandExecutor(cmd, null, env, timeout);
        exec.execute();
        return exec.getOutput();
    }

    public static String execCommand(Map<String, String> env, String ... cmd) throws IOException {
        return Shell.execCommand(env, cmd, 0L);
    }

    private static class ShellTimeoutTimerTask
    extends TimerTask {
        private Shell shell;

        public ShellTimeoutTimerTask(Shell shell) {
            this.shell = shell;
        }

        @Override
        public void run() {
            block2: {
                Process p = this.shell.getProcess();
                try {
                    p.exitValue();
                }
                catch (Exception e) {
                    if (p == null || this.shell.completed.get()) break block2;
                    this.shell.setTimedOut();
                    p.destroy();
                }
            }
        }
    }

    public static class ShellCommandExecutor
    extends Shell {
        private String[] command;
        private StringBuffer output;

        public ShellCommandExecutor(String[] execString) {
            this(execString, null);
        }

        public ShellCommandExecutor(String[] execString, File dir) {
            this(execString, dir, null);
        }

        public ShellCommandExecutor(String[] execString, File dir, Map<String, String> env) {
            this(execString, dir, env, 0L);
        }

        public ShellCommandExecutor(String[] execString, File dir, Map<String, String> env, long timeout) {
            this.command = (String[])execString.clone();
            if (dir != null) {
                this.setWorkingDirectory(dir);
            }
            if (env != null) {
                this.setEnvironment(env);
            }
            this.timeOutInterval = timeout;
        }

        public void execute() throws IOException {
            this.run();
        }

        @Override
        public String[] getExecString() {
            return this.command;
        }

        @Override
        protected void parseExecResult(BufferedReader lines) throws IOException {
            int nRead;
            this.output = new StringBuffer();
            char[] buf = new char[512];
            while ((nRead = lines.read(buf, 0, buf.length)) > 0) {
                this.output.append(buf, 0, nRead);
            }
        }

        public String getOutput() {
            return this.output == null ? "" : this.output.toString();
        }

        public String toString() {
            String[] args;
            StringBuilder builder = new StringBuilder();
            for (String s : args = this.getExecString()) {
                if (s.indexOf(32) >= 0) {
                    builder.append('\"').append(s).append('\"');
                } else {
                    builder.append(s);
                }
                builder.append(' ');
            }
            return builder.toString();
        }
    }

    public static class ExitCodeException
    extends IOException {
        int exitCode;

        public ExitCodeException(int exitCode, String message) {
            super(message);
            this.exitCode = exitCode;
        }

        public int getExitCode() {
            return this.exitCode;
        }
    }
}

