/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.compress;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.BlockCompressorStream;
import org.apache.hadoop.io.compress.BlockDecompressorStream;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.io.compress.lz4.Lz4Compressor;
import org.apache.hadoop.io.compress.lz4.Lz4Decompressor;
import org.apache.hadoop.util.NativeCodeLoader;

public class Lz4Codec
implements Configurable,
CompressionCodec {
    Configuration conf;

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    public static boolean isNativeCodeLoaded() {
        return NativeCodeLoader.isNativeCodeLoaded();
    }

    public static String getLibraryName() {
        return Lz4Compressor.getLibraryName();
    }

    @Override
    public CompressionOutputStream createOutputStream(OutputStream out) throws IOException {
        return this.createOutputStream(out, this.createCompressor());
    }

    @Override
    public CompressionOutputStream createOutputStream(OutputStream out, Compressor compressor) throws IOException {
        if (!Lz4Codec.isNativeCodeLoaded()) {
            throw new RuntimeException("native lz4 library not available");
        }
        int bufferSize = this.conf.getInt("io.compression.codec.lz4.buffersize", 262144);
        int compressionOverhead = Math.max((int)((double)bufferSize * 0.01), 10);
        return new BlockCompressorStream(out, compressor, bufferSize, compressionOverhead);
    }

    @Override
    public Class<? extends Compressor> getCompressorType() {
        if (!Lz4Codec.isNativeCodeLoaded()) {
            throw new RuntimeException("native lz4 library not available");
        }
        return Lz4Compressor.class;
    }

    @Override
    public Compressor createCompressor() {
        if (!Lz4Codec.isNativeCodeLoaded()) {
            throw new RuntimeException("native lz4 library not available");
        }
        int bufferSize = this.conf.getInt("io.compression.codec.lz4.buffersize", 262144);
        return new Lz4Compressor(bufferSize);
    }

    @Override
    public CompressionInputStream createInputStream(InputStream in) throws IOException {
        return this.createInputStream(in, this.createDecompressor());
    }

    @Override
    public CompressionInputStream createInputStream(InputStream in, Decompressor decompressor) throws IOException {
        if (!Lz4Codec.isNativeCodeLoaded()) {
            throw new RuntimeException("native lz4 library not available");
        }
        return new BlockDecompressorStream(in, decompressor, this.conf.getInt("io.compression.codec.lz4.buffersize", 262144));
    }

    @Override
    public Class<? extends Decompressor> getDecompressorType() {
        if (!Lz4Codec.isNativeCodeLoaded()) {
            throw new RuntimeException("native lz4 library not available");
        }
        return Lz4Decompressor.class;
    }

    @Override
    public Decompressor createDecompressor() {
        if (!Lz4Codec.isNativeCodeLoaded()) {
            throw new RuntimeException("native lz4 library not available");
        }
        int bufferSize = this.conf.getInt("io.compression.codec.lz4.buffersize", 262144);
        return new Lz4Decompressor(bufferSize);
    }

    @Override
    public String getDefaultExtension() {
        return ".lz4";
    }

    static {
        NativeCodeLoader.isNativeCodeLoaded();
    }
}

