/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.FsConstants;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.viewfs.ConfigUtil;
import org.apache.hadoop.fs.viewfs.InodeTree;
import org.apache.hadoop.fs.viewfs.ViewFileSystem;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestViewfsFileStatus {
    private static final File TEST_DIR = GenericTestUtils.getTestDir(TestViewfsFileStatus.class.getSimpleName());

    @Before
    public void setUp() {
        FileUtil.fullyDelete((File)TEST_DIR);
        Assert.assertTrue((boolean)TEST_DIR.mkdirs());
    }

    @After
    public void tearDown() throws IOException {
        FileUtil.fullyDelete((File)TEST_DIR);
    }

    @Test
    public void testFileStatusSerialziation() throws IOException, URISyntaxException {
        String testfilename = "testFileStatusSerialziation";
        TEST_DIR.mkdirs();
        File infile = new File(TEST_DIR, testfilename);
        byte[] content = "dingos".getBytes();
        try (FileOutputStream fos = new FileOutputStream(infile);){
            fos.write(content);
        }
        Assert.assertEquals((long)content.length, (long)infile.length());
        Configuration conf = new Configuration();
        ConfigUtil.addLink((Configuration)conf, (String)"/foo/bar/baz", (URI)TEST_DIR.toURI());
        try (FileSystem vfs = FileSystem.get((URI)FsConstants.VIEWFS_URI, (Configuration)conf);){
            Assert.assertEquals(ViewFileSystem.class, vfs.getClass());
            Path path = new Path("/foo/bar/baz", testfilename);
            FileStatus stat = vfs.getFileStatus(path);
            Assert.assertEquals((long)content.length, (long)stat.getLen());
            ContractTestUtils.assertNotErasureCoded(vfs, path);
            Assert.assertTrue((String)(path + " should have erasure coding unset in FileStatus#toString(): " + stat), (boolean)stat.toString().contains("isErasureCoded=false"));
            DataOutputBuffer dob = new DataOutputBuffer();
            stat.write((DataOutput)dob);
            DataInputBuffer dib = new DataInputBuffer();
            dib.reset(dob.getData(), 0, dob.getLength());
            FileStatus deSer = new FileStatus();
            deSer.readFields((DataInput)dib);
            Assert.assertEquals((long)content.length, (long)deSer.getLen());
            Assert.assertFalse((boolean)deSer.isErasureCoded());
        }
    }

    @Test
    public void testListStatusACL() throws IOException {
        String testfilename = "testFileACL";
        String childDirectoryName = "testDirectoryACL";
        TEST_DIR.mkdirs();
        File infile = new File(TEST_DIR, testfilename);
        byte[] content = "dingos".getBytes();
        try (FileOutputStream fos = new FileOutputStream(infile);){
            fos.write(content);
        }
        Assert.assertEquals((long)content.length, (long)infile.length());
        File childDir = new File(TEST_DIR, childDirectoryName);
        childDir.mkdirs();
        Configuration conf = new Configuration();
        ConfigUtil.addLink((Configuration)conf, (String)"/file", (URI)infile.toURI());
        ConfigUtil.addLink((Configuration)conf, (String)"/dir", (URI)childDir.toURI());
        conf.setBoolean("fs.viewfs.mount.links.as.symlinks", false);
        try (FileSystem vfs = FileSystem.get((URI)FsConstants.VIEWFS_URI, (Configuration)conf);){
            Assert.assertEquals(ViewFileSystem.class, vfs.getClass());
            FileStatus[] statuses = vfs.listStatus(new Path("/"));
            LocalFileSystem localFs = FileSystem.getLocal((Configuration)conf);
            FileStatus fileStat = localFs.getFileStatus(new Path(infile.getPath()));
            FileStatus dirStat = localFs.getFileStatus(new Path(childDir.getPath()));
            for (FileStatus status : statuses) {
                if (status.getPath().getName().equals("file")) {
                    Assert.assertEquals((Object)fileStat.getPermission(), (Object)status.getPermission());
                    continue;
                }
                Assert.assertEquals((Object)dirStat.getPermission(), (Object)status.getPermission());
            }
            localFs.setPermission(new Path(infile.getPath()), FsPermission.valueOf((String)"-rwxr--r--"));
            localFs.setPermission(new Path(childDir.getPath()), FsPermission.valueOf((String)"-r--rwxr--"));
            for (FileStatus status : statuses = vfs.listStatus(new Path("/"))) {
                if (status.getPath().getName().equals("file")) {
                    Assert.assertEquals((Object)FsPermission.valueOf((String)"-rwxr--r--"), (Object)status.getPermission());
                    Assert.assertFalse((boolean)status.isDirectory());
                    continue;
                }
                Assert.assertEquals((Object)FsPermission.valueOf((String)"-r--rwxr--"), (Object)status.getPermission());
                Assert.assertTrue((boolean)status.isDirectory());
            }
        }
    }

    @Test
    public void testGetFileChecksum() throws IOException {
        Path path = new Path("/tmp/someFile");
        FileSystem mockFS = (FileSystem)Mockito.mock(FileSystem.class);
        InodeTree.ResolveResult res = new InodeTree.ResolveResult(null, (Object)mockFS, null, new Path("someFile"));
        InodeTree fsState = (InodeTree)Mockito.mock(InodeTree.class);
        Mockito.when((Object)fsState.resolve(path.toString(), true)).thenReturn((Object)res);
        ViewFileSystem vfs = (ViewFileSystem)Mockito.mock(ViewFileSystem.class);
        vfs.fsState = fsState;
        Mockito.when((Object)vfs.getFileChecksum(path)).thenCallRealMethod();
        Mockito.when((Object)vfs.getUriPath(path)).thenCallRealMethod();
        vfs.getFileChecksum(path);
        ((FileSystem)Mockito.verify((Object)mockFS)).getFileChecksum(new Path("someFile"));
    }

    @AfterClass
    public static void cleanup() throws IOException {
        FileUtil.fullyDelete((File)TEST_DIR);
    }
}

