/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.FsStatus;
import org.apache.hadoop.fs.MD5MD5CRC32FileChecksum;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSInputStream;
import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.hadoop.hdfs.protocol.AlreadyBeingCreatedException;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.ClientDatanodeProtocol;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.DSQuotaExceededException;
import org.apache.hadoop.hdfs.protocol.DataTransferProtocol;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.FSConstants;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.NSQuotaExceededException;
import org.apache.hadoop.hdfs.protocol.UnresolvedPathException;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.common.UpgradeStatusReport;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.MD5Hash;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.io.retry.RetryProxy;
import org.apache.hadoop.ipc.Client;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.net.NodeBase;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.Daemon;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
public class DFSClient
implements FSConstants,
Closeable {
    public static final Log LOG = LogFactory.getLog(DFSClient.class);
    public static final long SERVER_DEFAULTS_VALIDITY_PERIOD = 3600000L;
    public static final int MAX_BLOCK_ACQUIRE_FAILURES = 3;
    static final int TCP_WINDOW_SIZE = 131072;
    final ClientProtocol namenode;
    private final ClientProtocol rpcNamenode;
    final UserGroupInformation ugi;
    volatile boolean clientRunning = true;
    private volatile FsServerDefaults serverDefaults;
    private volatile long serverDefaultsLastUpdate;
    Random r = new Random();
    final String clientName;
    final LeaseChecker leasechecker = new LeaseChecker();
    Configuration conf;
    long defaultBlockSize;
    private short defaultReplication;
    SocketFactory socketFactory;
    int socketTimeout;
    final int writePacketSize;
    final FileSystem.Statistics stats;
    final int hdfsTimeout;

    public static ClientProtocol createNamenode(Configuration conf) throws IOException {
        return DFSClient.createNamenode(NameNode.getAddress(conf), conf);
    }

    public static ClientProtocol createNamenode(InetSocketAddress nameNodeAddr, Configuration conf) throws IOException {
        return DFSClient.createNamenode(DFSClient.createRPCNamenode(nameNodeAddr, conf, UserGroupInformation.getCurrentUser()));
    }

    private static ClientProtocol createRPCNamenode(InetSocketAddress nameNodeAddr, Configuration conf, UserGroupInformation ugi) throws IOException {
        return (ClientProtocol)RPC.getProxy(ClientProtocol.class, (long)60L, (InetSocketAddress)nameNodeAddr, (UserGroupInformation)ugi, (Configuration)conf, (SocketFactory)NetUtils.getSocketFactory((Configuration)conf, ClientProtocol.class));
    }

    private static ClientProtocol createNamenode(ClientProtocol rpcNamenode) throws IOException {
        RetryPolicy createPolicy = RetryPolicies.retryUpToMaximumCountWithFixedSleep((int)5, (long)60000L, (TimeUnit)TimeUnit.MILLISECONDS);
        HashMap<Class<AlreadyBeingCreatedException>, RetryPolicy> remoteExceptionToPolicyMap = new HashMap<Class<AlreadyBeingCreatedException>, RetryPolicy>();
        remoteExceptionToPolicyMap.put(AlreadyBeingCreatedException.class, createPolicy);
        HashMap<Class<RemoteException>, RetryPolicy> exceptionToPolicyMap = new HashMap<Class<RemoteException>, RetryPolicy>();
        exceptionToPolicyMap.put(RemoteException.class, RetryPolicies.retryByRemoteException((RetryPolicy)RetryPolicies.TRY_ONCE_THEN_FAIL, remoteExceptionToPolicyMap));
        RetryPolicy methodPolicy = RetryPolicies.retryByException((RetryPolicy)RetryPolicies.TRY_ONCE_THEN_FAIL, exceptionToPolicyMap);
        HashMap<String, RetryPolicy> methodNameToPolicyMap = new HashMap<String, RetryPolicy>();
        methodNameToPolicyMap.put("create", methodPolicy);
        return (ClientProtocol)RetryProxy.create(ClientProtocol.class, (Object)rpcNamenode, methodNameToPolicyMap);
    }

    static ClientDatanodeProtocol createClientDatanodeProtocolProxy(DatanodeID datanodeid, Configuration conf) throws IOException {
        InetSocketAddress addr = NetUtils.createSocketAddr((String)(datanodeid.getHost() + ":" + datanodeid.getIpcPort()));
        if (ClientDatanodeProtocol.LOG.isDebugEnabled()) {
            ClientDatanodeProtocol.LOG.info((Object)("ClientDatanodeProtocol addr=" + addr));
        }
        return (ClientDatanodeProtocol)RPC.getProxy(ClientDatanodeProtocol.class, (long)6L, (InetSocketAddress)addr, (Configuration)conf);
    }

    @Deprecated
    public DFSClient(Configuration conf) throws IOException {
        this(NameNode.getAddress(conf), conf);
    }

    public DFSClient(InetSocketAddress nameNodeAddr, Configuration conf) throws IOException {
        this(nameNodeAddr, conf, null);
    }

    public DFSClient(InetSocketAddress nameNodeAddr, Configuration conf, FileSystem.Statistics stats) throws IOException {
        this(nameNodeAddr, null, conf, stats);
    }

    DFSClient(InetSocketAddress nameNodeAddr, ClientProtocol rpcNamenode, Configuration conf, FileSystem.Statistics stats) throws IOException {
        this.conf = conf;
        this.stats = stats;
        this.socketTimeout = conf.getInt("dfs.client.socket-timeout", 60000);
        this.socketFactory = NetUtils.getSocketFactory((Configuration)conf, ClientProtocol.class);
        this.writePacketSize = conf.getInt("dfs.client-write-packet-size", 65536);
        this.hdfsTimeout = Client.getTimeout((Configuration)conf);
        this.ugi = UserGroupInformation.getCurrentUser();
        String taskId = conf.get("mapred.task.id");
        this.clientName = taskId != null ? "DFSClient_" + taskId : "DFSClient_" + this.r.nextInt();
        this.defaultBlockSize = conf.getLong("dfs.blocksize", 0x4000000L);
        this.defaultReplication = (short)conf.getInt("dfs.replication", 3);
        if (nameNodeAddr != null && rpcNamenode == null) {
            this.rpcNamenode = DFSClient.createRPCNamenode(nameNodeAddr, conf, this.ugi);
            this.namenode = DFSClient.createNamenode(this.rpcNamenode);
        } else if (nameNodeAddr == null && rpcNamenode != null) {
            this.namenode = this.rpcNamenode = rpcNamenode;
        } else {
            throw new IllegalArgumentException("Expecting exactly one of nameNodeAddr and rpcNamenode being null: nameNodeAddr=" + nameNodeAddr + ", rpcNamenode=" + rpcNamenode);
        }
    }

    int getMaxBlockAcquireFailures() {
        return this.conf.getInt("dfs.client.max.block.acquire.failures", 3);
    }

    int getDatanodeWriteTimeout(int numNodes) {
        int confTime = this.conf.getInt("dfs.datanode.socket.write.timeout", 480000);
        return confTime > 0 ? confTime + 5000 * numNodes : 0;
    }

    int getDatanodeReadTimeout(int numNodes) {
        return this.socketTimeout > 0 ? 5000 * numNodes + this.socketTimeout : 0;
    }

    void checkOpen() throws IOException {
        if (!this.clientRunning) {
            IOException result = new IOException("Filesystem closed");
            throw result;
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.clientRunning) {
            this.leasechecker.close();
            this.clientRunning = false;
            try {
                this.leasechecker.interruptAndJoin();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            RPC.stopProxy((Object)this.rpcNamenode);
        }
    }

    public long getDefaultBlockSize() {
        return this.defaultBlockSize;
    }

    public long getBlockSize(String f) throws IOException {
        try {
            return this.namenode.getPreferredBlockSize(f);
        }
        catch (IOException ie) {
            LOG.warn((Object)("Problem getting block size: " + StringUtils.stringifyException((Throwable)ie)));
            throw ie;
        }
    }

    public FsServerDefaults getServerDefaults() throws IOException {
        long now = System.currentTimeMillis();
        if (now - this.serverDefaultsLastUpdate > 3600000L) {
            this.serverDefaults = this.namenode.getServerDefaults();
            this.serverDefaultsLastUpdate = now;
        }
        return this.serverDefaults;
    }

    public Token<DelegationTokenIdentifier> getDelegationToken(Text renewer) throws IOException {
        return this.namenode.getDelegationToken(renewer);
    }

    public long renewDelegationToken(Token<DelegationTokenIdentifier> token) throws SecretManager.InvalidToken, IOException {
        try {
            return this.namenode.renewDelegationToken(token);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{SecretManager.InvalidToken.class, AccessControlException.class});
        }
    }

    public void cancelDelegationToken(Token<DelegationTokenIdentifier> token) throws SecretManager.InvalidToken, IOException {
        try {
            this.namenode.cancelDelegationToken(token);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{SecretManager.InvalidToken.class, AccessControlException.class});
        }
    }

    public void reportBadBlocks(LocatedBlock[] blocks) throws IOException {
        this.namenode.reportBadBlocks(blocks);
    }

    public short getDefaultReplication() {
        return this.defaultReplication;
    }

    static LocatedBlocks callGetBlockLocations(ClientProtocol namenode, String src, long start, long length) throws IOException, UnresolvedLinkException {
        try {
            return namenode.getBlockLocations(src, start, length);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, FileNotFoundException.class, UnresolvedPathException.class});
        }
    }

    public BlockLocation[] getBlockLocations(String src, long start, long length) throws IOException, UnresolvedLinkException {
        LocatedBlocks blocks = DFSClient.callGetBlockLocations(this.namenode, src, start, length);
        if (blocks == null) {
            return new BlockLocation[0];
        }
        int nrBlocks = blocks.locatedBlockCount();
        BlockLocation[] blkLocations = new BlockLocation[nrBlocks];
        int idx = 0;
        for (LocatedBlock blk : blocks.getLocatedBlocks()) {
            assert (idx < nrBlocks) : "Incorrect index";
            DatanodeInfo[] locations = blk.getLocations();
            String[] hosts = new String[locations.length];
            String[] names = new String[locations.length];
            String[] racks = new String[locations.length];
            for (int hCnt = 0; hCnt < locations.length; ++hCnt) {
                hosts[hCnt] = locations[hCnt].getHostName();
                names[hCnt] = locations[hCnt].getName();
                NodeBase node = new NodeBase(names[hCnt], locations[hCnt].getNetworkLocation());
                racks[hCnt] = node.toString();
            }
            blkLocations[idx] = new BlockLocation(names, hosts, racks, blk.getStartOffset(), blk.getBlockSize());
            ++idx;
        }
        return blkLocations;
    }

    public DFSInputStream open(String src) throws IOException, UnresolvedLinkException {
        return this.open(src, this.conf.getInt("io.file.buffer.size", 4096), true, null);
    }

    @Deprecated
    public DFSInputStream open(String src, int buffersize, boolean verifyChecksum, FileSystem.Statistics stats) throws IOException, UnresolvedLinkException {
        return this.open(src, buffersize, verifyChecksum);
    }

    public DFSInputStream open(String src, int buffersize, boolean verifyChecksum) throws IOException, UnresolvedLinkException {
        this.checkOpen();
        return new DFSInputStream(this, src, buffersize, verifyChecksum);
    }

    public OutputStream create(String src, boolean overwrite) throws IOException, UnresolvedLinkException {
        return this.create(src, overwrite, this.defaultReplication, this.defaultBlockSize, null);
    }

    public OutputStream create(String src, boolean overwrite, Progressable progress) throws IOException, UnresolvedLinkException {
        return this.create(src, overwrite, this.defaultReplication, this.defaultBlockSize, null);
    }

    public OutputStream create(String src, boolean overwrite, short replication, long blockSize) throws IOException, UnresolvedLinkException {
        return this.create(src, overwrite, replication, blockSize, null);
    }

    public ClientProtocol getNamenode() {
        return this.namenode;
    }

    public OutputStream create(String src, boolean overwrite, short replication, long blockSize, Progressable progress) throws IOException, UnresolvedLinkException {
        return this.create(src, overwrite, replication, blockSize, progress, this.conf.getInt("io.file.buffer.size", 4096));
    }

    public OutputStream create(String src, boolean overwrite, short replication, long blockSize, Progressable progress, int buffersize) throws IOException, UnresolvedLinkException {
        return this.create(src, FsPermission.getDefault(), overwrite ? EnumSet.of(CreateFlag.OVERWRITE) : EnumSet.of(CreateFlag.CREATE), replication, blockSize, progress, buffersize);
    }

    public OutputStream create(String src, FsPermission permission, EnumSet<CreateFlag> flag, short replication, long blockSize, Progressable progress, int buffersize) throws IOException, UnresolvedLinkException {
        return this.create(src, permission, flag, true, replication, blockSize, progress, buffersize);
    }

    public OutputStream create(String src, FsPermission permission, EnumSet<CreateFlag> flag, boolean createParent, short replication, long blockSize, Progressable progress, int buffersize) throws IOException, UnresolvedLinkException {
        this.checkOpen();
        if (permission == null) {
            permission = FsPermission.getDefault();
        }
        FsPermission masked = permission.applyUMask(FsPermission.getUMask((Configuration)this.conf));
        LOG.debug((Object)(src + ": masked=" + masked));
        DFSOutputStream result = new DFSOutputStream(this, src, masked, flag, createParent, replication, blockSize, progress, buffersize, this.conf.getInt("dfs.bytes-per-checksum", 512));
        this.leasechecker.put(src, (OutputStream)((Object)result));
        return result;
    }

    public OutputStream primitiveCreate(String src, FsPermission absPermission, EnumSet<CreateFlag> flag, boolean createParent, short replication, long blockSize, Progressable progress, int buffersize, int bytesPerChecksum) throws IOException, UnresolvedLinkException {
        this.checkOpen();
        DFSOutputStream result = new DFSOutputStream(this, src, absPermission, flag, createParent, replication, blockSize, progress, buffersize, bytesPerChecksum);
        this.leasechecker.put(src, (OutputStream)((Object)result));
        return result;
    }

    public void createSymlink(String target, String link, boolean createParent) throws IOException, UnresolvedLinkException {
        try {
            FsPermission dirPerm = FsPermission.getDefault().applyUMask(FsPermission.getUMask((Configuration)this.conf));
            this.namenode.createSymlink(target, link, dirPerm, createParent);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, NSQuotaExceededException.class, DSQuotaExceededException.class, FileAlreadyExistsException.class, UnresolvedPathException.class});
        }
    }

    public String getLinkTarget(String path) throws IOException {
        this.checkOpen();
        try {
            return this.namenode.getLinkTarget(path);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, FileNotFoundException.class});
        }
    }

    OutputStream append(String src, int buffersize, Progressable progress) throws IOException, UnresolvedLinkException {
        this.checkOpen();
        HdfsFileStatus stat = null;
        LocatedBlock lastBlock = null;
        try {
            stat = this.getFileInfo(src);
            lastBlock = this.namenode.append(src, this.clientName);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{FileNotFoundException.class, AccessControlException.class, NSQuotaExceededException.class, DSQuotaExceededException.class, UnresolvedPathException.class});
        }
        DFSOutputStream result = new DFSOutputStream(this, src, buffersize, progress, lastBlock, stat, this.conf.getInt("dfs.bytes-per-checksum", 512));
        this.leasechecker.put(src, (OutputStream)((Object)result));
        return result;
    }

    public boolean setReplication(String src, short replication) throws IOException, UnresolvedLinkException {
        try {
            return this.namenode.setReplication(src, replication);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, NSQuotaExceededException.class, DSQuotaExceededException.class, UnresolvedPathException.class});
        }
    }

    @Deprecated
    public boolean rename(String src, String dst) throws IOException, UnresolvedLinkException {
        this.checkOpen();
        try {
            return this.namenode.rename(src, dst);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, NSQuotaExceededException.class, DSQuotaExceededException.class, UnresolvedPathException.class});
        }
    }

    public void concat(String trg, String[] srcs) throws IOException, UnresolvedLinkException {
        this.checkOpen();
        try {
            this.namenode.concat(trg, srcs);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, NSQuotaExceededException.class, DSQuotaExceededException.class, UnresolvedPathException.class});
        }
    }

    public void rename(String src, String dst, Options.Rename ... options) throws IOException, UnresolvedLinkException {
        this.checkOpen();
        try {
            this.namenode.rename(src, dst, options);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, NSQuotaExceededException.class, DSQuotaExceededException.class, UnresolvedPathException.class});
        }
    }

    @Deprecated
    public boolean delete(String src) throws IOException, UnresolvedLinkException {
        this.checkOpen();
        return this.namenode.delete(src, true);
    }

    public boolean delete(String src, boolean recursive) throws IOException, UnresolvedLinkException {
        this.checkOpen();
        try {
            return this.namenode.delete(src, recursive);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, UnresolvedPathException.class});
        }
    }

    public boolean exists(String src) throws IOException {
        this.checkOpen();
        return this.getFileInfo(src) != null;
    }

    public DirectoryListing listPaths(String src, byte[] startAfter) throws IOException, UnresolvedLinkException {
        this.checkOpen();
        try {
            return this.namenode.getListing(src, startAfter);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, UnresolvedPathException.class});
        }
    }

    public HdfsFileStatus getFileInfo(String src) throws IOException, UnresolvedLinkException {
        this.checkOpen();
        try {
            return this.namenode.getFileInfo(src);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, UnresolvedPathException.class});
        }
    }

    public HdfsFileStatus getFileLinkInfo(String src) throws IOException, UnresolvedLinkException {
        this.checkOpen();
        try {
            return this.namenode.getFileLinkInfo(src);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, UnresolvedPathException.class});
        }
    }

    public MD5MD5CRC32FileChecksum getFileChecksum(String src) throws IOException {
        this.checkOpen();
        return DFSClient.getFileChecksum(src, this.namenode, this.socketFactory, this.socketTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static MD5MD5CRC32FileChecksum getFileChecksum(String src, ClientProtocol namenode, SocketFactory socketFactory, int socketTimeout) throws IOException {
        locatedblocks = DFSClient.callGetBlockLocations(namenode, src, 0L, 0x7FFFFFFFFFFFFFFFL).getLocatedBlocks();
        md5out = new DataOutputBuffer();
        bytesPerCRC = 0;
        crcPerBlock = 0L;
        refetchBlocks = false;
        lastRetriedIndex = -1;
        for (i = 0; i < locatedblocks.size(); ++i) {
            if (refetchBlocks) {
                locatedblocks = DFSClient.callGetBlockLocations(namenode, src, 0L, 0x7FFFFFFFFFFFFFFFL).getLocatedBlocks();
                refetchBlocks = false;
            }
            lb = locatedblocks.get(i);
            block = lb.getBlock();
            datanodes = lb.getLocations();
            timeout = 3000 * datanodes.length + socketTimeout;
            done = false;
            for (j = 0; !done && j < datanodes.length; ++j) {
                block16: {
                    block15: {
                        sock = null;
                        out = null;
                        in = null;
                        sock = socketFactory.createSocket();
                        NetUtils.connect((Socket)sock, (SocketAddress)NetUtils.createSocketAddr((String)datanodes[j].getName()), (int)timeout);
                        sock.setSoTimeout(timeout);
                        out = new DataOutputStream(new BufferedOutputStream(NetUtils.getOutputStream((Socket)sock), DataNode.SMALL_BUFFER_SIZE));
                        in = new DataInputStream(NetUtils.getInputStream((Socket)sock));
                        if (DFSClient.LOG.isDebugEnabled()) {
                            DFSClient.LOG.debug((Object)("write to " + datanodes[j].getName() + ": " + (Object)DataTransferProtocol.Op.BLOCK_CHECKSUM + ", block=" + block));
                        }
                        DataTransferProtocol.Sender.opBlockChecksum(out, block.getBlockId(), block.getGenerationStamp(), lb.getAccessToken());
                        reply = DataTransferProtocol.Status.read(in);
                        if (reply == DataTransferProtocol.Status.SUCCESS) ** GOTO lbl44
                        if (reply != DataTransferProtocol.Status.ERROR_ACCESS_TOKEN || i <= lastRetriedIndex) break block15;
                        if (DFSClient.LOG.isDebugEnabled()) {
                            DFSClient.LOG.debug((Object)("Got access token error in response to OP_BLOCK_CHECKSUM for file " + src + " for block " + block + " from datanode " + datanodes[j].getName() + ". Will retry the block once."));
                        }
                        lastRetriedIndex = i--;
                        done = true;
                        refetchBlocks = true;
                        IOUtils.closeStream((Closeable)in);
                        IOUtils.closeStream((Closeable)out);
                        IOUtils.closeSocket((Socket)sock);
                        break;
                    }
                    try {
                        throw new IOException("Bad response " + (Object)reply + " for block " + block + " from datanode " + datanodes[j].getName());
lbl44:
                        // 1 sources

                        bpc = in.readInt();
                        if (i == 0) {
                            bytesPerCRC = bpc;
                        } else if (bpc != bytesPerCRC) {
                            throw new IOException("Byte-per-checksum not matched: bpc=" + bpc + " but bytesPerCRC=" + bytesPerCRC);
                        }
                        cpb = in.readLong();
                        if (locatedblocks.size() > 1 && i == 0) {
                            crcPerBlock = cpb;
                        }
                        md5 = MD5Hash.read((DataInput)in);
                        md5.write((DataOutput)md5out);
                        done = true;
                        if (!DFSClient.LOG.isDebugEnabled()) break block16;
                        if (i == 0) {
                            DFSClient.LOG.debug((Object)("set bytesPerCRC=" + bytesPerCRC + ", crcPerBlock=" + crcPerBlock));
                        }
                        DFSClient.LOG.debug((Object)("got reply from " + datanodes[j].getName() + ": md5=" + md5));
                    }
                    catch (IOException ie) {
                        try {
                            DFSClient.LOG.warn((Object)("src=" + src + ", datanodes[" + j + "].getName()=" + datanodes[j].getName()), (Throwable)ie);
                        }
                        catch (Throwable var26_26) {
                            IOUtils.closeStream(in);
                            IOUtils.closeStream(out);
                            IOUtils.closeSocket((Socket)sock);
                            throw var26_26;
                        }
                        IOUtils.closeStream(in);
                        IOUtils.closeStream((Closeable)out);
                        IOUtils.closeSocket((Socket)sock);
                        continue;
                    }
                }
                IOUtils.closeStream((Closeable)in);
                IOUtils.closeStream((Closeable)out);
                IOUtils.closeSocket((Socket)sock);
                continue;
            }
            if (done) continue;
            throw new IOException("Fail to get block MD5 for " + block);
        }
        fileMD5 = MD5Hash.digest((byte[])md5out.getData());
        return new MD5MD5CRC32FileChecksum(bytesPerCRC, crcPerBlock, fileMD5);
    }

    public void setPermission(String src, FsPermission permission) throws IOException, UnresolvedLinkException {
        this.checkOpen();
        try {
            this.namenode.setPermission(src, permission);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, FileNotFoundException.class, UnresolvedPathException.class});
        }
    }

    public void setOwner(String src, String username, String groupname) throws IOException, UnresolvedLinkException {
        this.checkOpen();
        try {
            this.namenode.setOwner(src, username, groupname);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, FileNotFoundException.class, UnresolvedPathException.class});
        }
    }

    public FsStatus getDiskStatus() throws IOException {
        long[] rawNums = this.namenode.getStats();
        return new FsStatus(rawNums[0], rawNums[1], rawNums[2]);
    }

    public long getMissingBlocksCount() throws IOException {
        return this.namenode.getStats()[5];
    }

    public long getUnderReplicatedBlocksCount() throws IOException {
        return this.namenode.getStats()[3];
    }

    public long getCorruptBlocksCount() throws IOException {
        return this.namenode.getStats()[4];
    }

    public DatanodeInfo[] datanodeReport(FSConstants.DatanodeReportType type) throws IOException {
        return this.namenode.getDatanodeReport(type);
    }

    public boolean setSafeMode(FSConstants.SafeModeAction action) throws IOException {
        return this.namenode.setSafeMode(action);
    }

    void saveNamespace() throws AccessControlException, IOException {
        try {
            this.namenode.saveNamespace();
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class});
        }
    }

    boolean restoreFailedStorage(String arg) throws AccessControlException {
        return this.namenode.restoreFailedStorage(arg);
    }

    public void refreshNodes() throws IOException {
        this.namenode.refreshNodes();
    }

    public void metaSave(String pathname) throws IOException {
        this.namenode.metaSave(pathname);
    }

    public void finalizeUpgrade() throws IOException {
        this.namenode.finalizeUpgrade();
    }

    public UpgradeStatusReport distributedUpgradeProgress(FSConstants.UpgradeAction action) throws IOException {
        return this.namenode.distributedUpgradeProgress(action);
    }

    @Deprecated
    public boolean mkdirs(String src) throws IOException {
        return this.mkdirs(src, null, true);
    }

    public boolean mkdirs(String src, FsPermission permission, boolean createParent) throws IOException, UnresolvedLinkException {
        this.checkOpen();
        if (permission == null) {
            permission = FsPermission.getDefault();
        }
        FsPermission masked = permission.applyUMask(FsPermission.getUMask((Configuration)this.conf));
        LOG.debug((Object)(src + ": masked=" + masked));
        try {
            return this.namenode.mkdirs(src, masked, createParent);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, NSQuotaExceededException.class, DSQuotaExceededException.class, FileNotFoundException.class, FileAlreadyExistsException.class, UnresolvedPathException.class});
        }
    }

    public boolean primitiveMkdir(String src, FsPermission absPermission) throws IOException, UnresolvedLinkException {
        this.checkOpen();
        if (absPermission == null) {
            absPermission = FsPermission.getDefault().applyUMask(FsPermission.getUMask((Configuration)this.conf));
        }
        LOG.debug((Object)(src + ": masked=" + absPermission));
        try {
            return this.namenode.mkdirs(src, absPermission, true);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, NSQuotaExceededException.class, DSQuotaExceededException.class, UnresolvedPathException.class});
        }
    }

    ContentSummary getContentSummary(String src) throws IOException {
        try {
            return this.namenode.getContentSummary(src);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, FileNotFoundException.class, UnresolvedPathException.class});
        }
    }

    void setQuota(String src, long namespaceQuota, long diskspaceQuota) throws IOException, UnresolvedLinkException {
        if (namespaceQuota <= 0L && namespaceQuota != Long.MAX_VALUE && namespaceQuota != -1L || diskspaceQuota <= 0L && diskspaceQuota != Long.MAX_VALUE && diskspaceQuota != -1L) {
            throw new IllegalArgumentException("Invalid values for quota : " + namespaceQuota + " and " + diskspaceQuota);
        }
        try {
            this.namenode.setQuota(src, namespaceQuota, diskspaceQuota);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, FileNotFoundException.class, NSQuotaExceededException.class, DSQuotaExceededException.class, UnresolvedPathException.class});
        }
    }

    public void setTimes(String src, long mtime, long atime) throws IOException, UnresolvedLinkException {
        this.checkOpen();
        try {
            this.namenode.setTimes(src, mtime, atime);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, FileNotFoundException.class, UnresolvedPathException.class});
        }
    }

    boolean isLeaseCheckerStarted() {
        return this.leasechecker.daemon != null;
    }

    void reportChecksumFailure(String file, Block blk, DatanodeInfo dn) {
        DatanodeInfo[] dnArr = new DatanodeInfo[]{dn};
        LocatedBlock[] lblocks = new LocatedBlock[]{new LocatedBlock(blk, dnArr)};
        this.reportChecksumFailure(file, lblocks);
    }

    void reportChecksumFailure(String file, LocatedBlock[] lblocks) {
        try {
            this.reportBadBlocks(lblocks);
        }
        catch (IOException ie) {
            LOG.info((Object)("Found corruption while reading " + file + ".  Error repairing corrupt blocks.  Bad blocks remain. " + StringUtils.stringifyException((Throwable)ie)));
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[clientName=" + this.clientName + ", ugi=" + this.ugi + "]";
    }

    @InterfaceAudience.Private
    public static class DFSDataInputStream
    extends FSDataInputStream {
        public DFSDataInputStream(DFSInputStream in) throws IOException {
            super((InputStream)((Object)in));
        }

        public DatanodeInfo getCurrentDatanode() {
            return ((DFSInputStream)((Object)this.in)).getCurrentDatanode();
        }

        public Block getCurrentBlock() {
            return ((DFSInputStream)((Object)this.in)).getCurrentBlock();
        }

        synchronized List<LocatedBlock> getAllBlocks() throws IOException {
            return ((DFSInputStream)((Object)this.in)).getAllBlocks();
        }

        public long getVisibleLength() throws IOException {
            return ((DFSInputStream)((Object)this.in)).getFileLength();
        }
    }

    class LeaseChecker
    implements Runnable {
        private final SortedMap<String, OutputStream> pendingCreates = new TreeMap<String, OutputStream>();
        private Daemon daemon = null;

        LeaseChecker() {
        }

        synchronized void put(String src, OutputStream out) {
            if (DFSClient.this.clientRunning) {
                if (this.daemon == null) {
                    this.daemon = new Daemon((Runnable)this);
                    this.daemon.start();
                }
                this.pendingCreates.put(src, out);
            }
        }

        synchronized void remove(String src) {
            this.pendingCreates.remove(src);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void interruptAndJoin() throws InterruptedException {
            Daemon daemonCopy = null;
            LeaseChecker leaseChecker = this;
            synchronized (leaseChecker) {
                if (this.daemon != null) {
                    this.daemon.interrupt();
                    daemonCopy = this.daemon;
                }
            }
            if (daemonCopy != null) {
                LOG.debug((Object)"Wait for lease checker to terminate");
                daemonCopy.join();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close() {
            while (true) {
                OutputStream out;
                String src;
                LeaseChecker leaseChecker = this;
                synchronized (leaseChecker) {
                    if (this.pendingCreates.isEmpty()) {
                        return;
                    }
                    src = this.pendingCreates.firstKey();
                    out = (OutputStream)this.pendingCreates.remove(src);
                }
                if (out == null) continue;
                try {
                    out.close();
                    continue;
                }
                catch (IOException ie) {
                    LOG.error((Object)("Exception closing file " + src + " : " + ie), (Throwable)ie);
                    continue;
                }
                break;
            }
        }

        synchronized void abort() {
            DFSClient.this.clientRunning = false;
            while (!this.pendingCreates.isEmpty()) {
                String src = this.pendingCreates.firstKey();
                DFSOutputStream out = (DFSOutputStream)((Object)this.pendingCreates.remove(src));
                if (out == null) continue;
                try {
                    out.abort();
                }
                catch (IOException ie) {
                    LOG.error((Object)("Exception aborting file " + src + ": "), (Throwable)ie);
                }
            }
            RPC.stopProxy((Object)DFSClient.this.rpcNamenode);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void renew() throws IOException {
            LeaseChecker leaseChecker = this;
            synchronized (leaseChecker) {
                if (this.pendingCreates.isEmpty()) {
                    return;
                }
            }
            DFSClient.this.namenode.renewLease(DFSClient.this.clientName);
        }

        @Override
        public void run() {
            long lastRenewed = 0L;
            int renewal = 30000;
            if (DFSClient.this.hdfsTimeout > 0) {
                renewal = Math.min(renewal, DFSClient.this.hdfsTimeout / 2);
            }
            while (DFSClient.this.clientRunning && !Thread.interrupted()) {
                if (System.currentTimeMillis() - lastRenewed > (long)renewal) {
                    try {
                        this.renew();
                        lastRenewed = System.currentTimeMillis();
                    }
                    catch (SocketTimeoutException ie) {
                        LOG.warn((Object)("Problem renewing lease for " + DFSClient.this.clientName + " for a period of " + DFSClient.this.hdfsTimeout / 1000 + " seconds. Shutting down HDFS client..."), (Throwable)ie);
                        this.abort();
                        break;
                    }
                    catch (IOException ie) {
                        LOG.warn((Object)("Problem renewing lease for " + DFSClient.this.clientName + " for a period of " + DFSClient.this.hdfsTimeout / 1000 + " seconds. Will retry shortly..."), (Throwable)ie);
                    }
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(this + " is interrupted."), (Throwable)ie);
                    }
                    return;
                }
            }
        }

        public String toString() {
            String s = this.getClass().getSimpleName();
            if (LOG.isTraceEnabled()) {
                return s + "@" + DFSClient.this + ": " + StringUtils.stringifyException((Throwable)new Throwable("for testing"));
            }
            return s;
        }
    }
}

