/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.EnumSet;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.FsStatus;
import org.apache.hadoop.fs.MD5MD5CRC32FileChecksum;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.FSConstants;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.common.UpgradeStatusReport;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.Progressable;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class DistributedFileSystem
extends FileSystem {
    private Path workingDir;
    private URI uri;
    DFSClient dfs;
    private boolean verifyChecksum = true;

    public DistributedFileSystem() {
    }

    @Deprecated
    public DistributedFileSystem(InetSocketAddress namenode, Configuration conf) throws IOException {
        this.initialize(NameNode.getUri(namenode), conf);
    }

    public URI getUri() {
        return this.uri;
    }

    public void initialize(URI uri, Configuration conf) throws IOException {
        super.initialize(uri, conf);
        this.setConf(conf);
        String host = uri.getHost();
        if (host == null) {
            throw new IOException("Incomplete HDFS URI, no host: " + uri);
        }
        InetSocketAddress namenode = NameNode.getAddress(uri.getAuthority());
        this.dfs = new DFSClient(namenode, conf, this.statistics);
        this.uri = URI.create("hdfs://" + uri.getAuthority());
        this.workingDir = this.getHomeDirectory();
    }

    protected void checkPath(Path path) {
        URI thisUri = this.getUri();
        URI thatUri = path.toUri();
        String thatAuthority = thatUri.getAuthority();
        if (thatUri.getScheme() != null && thatUri.getScheme().equalsIgnoreCase(thisUri.getScheme()) && thatUri.getPort() == 8020 && (thisUri.getPort() == -1 || thisUri.getPort() == 8020) && thatAuthority.substring(0, thatAuthority.indexOf(":")).equalsIgnoreCase(thisUri.getAuthority())) {
            return;
        }
        super.checkPath(path);
    }

    public Path makeQualified(Path path) {
        URI thisUri = this.getUri();
        URI thatUri = path.toUri();
        String thatAuthority = thatUri.getAuthority();
        if (thatUri.getScheme() != null && thatUri.getScheme().equalsIgnoreCase(thisUri.getScheme()) && thatUri.getPort() == 8020 && thisUri.getPort() == -1 && thatAuthority.substring(0, thatAuthority.indexOf(":")).equalsIgnoreCase(thisUri.getAuthority())) {
            path = new Path(thisUri.getScheme(), thisUri.getAuthority(), thatUri.getPath());
        }
        return super.makeQualified(path);
    }

    public Path getWorkingDirectory() {
        return this.workingDir;
    }

    public long getDefaultBlockSize() {
        return this.dfs.getDefaultBlockSize();
    }

    public short getDefaultReplication() {
        return this.dfs.getDefaultReplication();
    }

    private Path makeAbsolute(Path f) {
        if (f.isAbsolute()) {
            return f;
        }
        return new Path(this.workingDir, f);
    }

    public void setWorkingDirectory(Path dir) {
        String result = this.makeAbsolute(dir).toUri().getPath();
        if (!DFSUtil.isValidName(result)) {
            throw new IllegalArgumentException("Invalid DFS directory name " + result);
        }
        this.workingDir = this.makeAbsolute(dir);
    }

    public Path getHomeDirectory() {
        return new Path("/user/" + this.dfs.ugi.getShortUserName()).makeQualified((FileSystem)this);
    }

    private String getPathName(Path file) {
        this.checkPath(file);
        String result = this.makeAbsolute(file).toUri().getPath();
        if (!DFSUtil.isValidName(result)) {
            throw new IllegalArgumentException("Pathname " + result + " from " + file + " is not a valid DFS filename.");
        }
        return result;
    }

    public BlockLocation[] getFileBlockLocations(FileStatus file, long start, long len) throws IOException {
        if (file == null) {
            return null;
        }
        return this.dfs.getBlockLocations(this.getPathName(file.getPath()), start, len);
    }

    public BlockLocation[] getFileBlockLocations(Path p, long start, long len) throws IOException {
        return this.dfs.getBlockLocations(this.getPathName(p), start, len);
    }

    public void setVerifyChecksum(boolean verifyChecksum) {
        this.verifyChecksum = verifyChecksum;
    }

    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        return new DFSClient.DFSDataInputStream(this.dfs.open(this.getPathName(f), bufferSize, this.verifyChecksum, this.statistics));
    }

    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        DFSOutputStream op = (DFSOutputStream)((Object)this.dfs.append(this.getPathName(f), bufferSize, progress));
        return new FSDataOutputStream((OutputStream)((Object)op), this.statistics, op.getInitialLen());
    }

    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return new FSDataOutputStream(this.dfs.create(this.getPathName(f), permission, overwrite ? EnumSet.of(CreateFlag.OVERWRITE) : EnumSet.of(CreateFlag.CREATE), replication, blockSize, progress, bufferSize), this.statistics);
    }

    protected FSDataOutputStream primitiveCreate(Path f, FsPermission absolutePermission, EnumSet<CreateFlag> flag, int bufferSize, short replication, long blockSize, Progressable progress, int bytesPerChecksum) throws IOException {
        return new FSDataOutputStream(this.dfs.primitiveCreate(this.getPathName(f), absolutePermission, flag, true, replication, blockSize, progress, bufferSize, bytesPerChecksum), this.statistics);
    }

    public FSDataOutputStream createNonRecursive(Path f, FsPermission permission, EnumSet<CreateFlag> flag, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return new FSDataOutputStream(this.dfs.create(this.getPathName(f), permission, flag, false, replication, blockSize, progress, bufferSize), this.statistics);
    }

    public boolean setReplication(Path src, short replication) throws IOException {
        return this.dfs.setReplication(this.getPathName(src), replication);
    }

    public void concat(Path trg, Path[] psrcs) throws IOException {
        String[] srcs = new String[psrcs.length];
        for (int i = 0; i < psrcs.length; ++i) {
            srcs[i] = this.getPathName(psrcs[i]);
        }
        this.dfs.concat(this.getPathName(trg), srcs);
    }

    public boolean rename(Path src, Path dst) throws IOException {
        return this.dfs.rename(this.getPathName(src), this.getPathName(dst));
    }

    public void rename(Path src, Path dst, Options.Rename ... options) throws IOException {
        this.dfs.rename(this.getPathName(src), this.getPathName(dst), options);
    }

    public boolean delete(Path f, boolean recursive) throws IOException {
        return this.dfs.delete(this.getPathName(f), recursive);
    }

    public ContentSummary getContentSummary(Path f) throws IOException {
        return this.dfs.getContentSummary(this.getPathName(f));
    }

    public void setQuota(Path src, long namespaceQuota, long diskspaceQuota) throws IOException {
        this.dfs.setQuota(this.getPathName(src), namespaceQuota, diskspaceQuota);
    }

    private FileStatus makeQualified(HdfsFileStatus f, Path parent) {
        return new FileStatus(f.getLen(), f.isDir(), (int)f.getReplication(), f.getBlockSize(), f.getModificationTime(), f.getAccessTime(), f.getPermission(), f.getOwner(), f.getGroup(), f.getFullPath(parent).makeQualified(this.getUri(), this.getWorkingDirectory()));
    }

    public FileStatus[] listStatus(Path p) throws IOException {
        String src = this.getPathName(p);
        DirectoryListing thisListing = this.dfs.listPaths(src, HdfsFileStatus.EMPTY_NAME);
        if (thisListing == null) {
            throw new FileNotFoundException("File " + p + " does not exist.");
        }
        HdfsFileStatus[] partialListing = thisListing.getPartialListing();
        if (!thisListing.hasMore()) {
            FileStatus[] stats = new FileStatus[partialListing.length];
            for (int i = 0; i < partialListing.length; ++i) {
                stats[i] = this.makeQualified(partialListing[i], p);
            }
            return stats;
        }
        int totalNumEntries = partialListing.length + thisListing.getRemainingEntries();
        ArrayList<FileStatus> listing = new ArrayList<FileStatus>(totalNumEntries);
        for (HdfsFileStatus fileStatus : partialListing) {
            listing.add(this.makeQualified(fileStatus, p));
        }
        do {
            if ((thisListing = this.dfs.listPaths(src, thisListing.getLastName())) == null) {
                throw new FileNotFoundException("File " + p + " does not exist.");
            }
            for (HdfsFileStatus fileStatus : partialListing = thisListing.getPartialListing()) {
                listing.add(this.makeQualified(fileStatus, p));
            }
        } while (thisListing.hasMore());
        return listing.toArray(new FileStatus[listing.size()]);
    }

    public boolean mkdir(Path f, FsPermission permission) throws IOException {
        return this.dfs.mkdirs(this.getPathName(f), permission, false);
    }

    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        return this.dfs.mkdirs(this.getPathName(f), permission, true);
    }

    protected boolean primitiveMkdir(Path f, FsPermission absolutePermission) throws IOException {
        return this.dfs.primitiveMkdir(this.getPathName(f), absolutePermission);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            super.processDeleteOnExit();
            this.dfs.close();
        }
        finally {
            super.close();
        }
    }

    public String toString() {
        return "DFS[" + this.dfs + "]";
    }

    public DFSClient getClient() {
        return this.dfs;
    }

    public FsStatus getStatus(Path p) throws IOException {
        return this.dfs.getDiskStatus();
    }

    @Deprecated
    public DiskStatus getDiskStatus() throws IOException {
        return new DiskStatus(this.dfs.getDiskStatus());
    }

    @Deprecated
    public long getRawCapacity() throws IOException {
        return this.dfs.getDiskStatus().getCapacity();
    }

    @Deprecated
    public long getRawUsed() throws IOException {
        return this.dfs.getDiskStatus().getUsed();
    }

    public long getMissingBlocksCount() throws IOException {
        return this.dfs.getMissingBlocksCount();
    }

    public long getUnderReplicatedBlocksCount() throws IOException {
        return this.dfs.getUnderReplicatedBlocksCount();
    }

    public long getCorruptBlocksCount() throws IOException {
        return this.dfs.getCorruptBlocksCount();
    }

    public DatanodeInfo[] getDataNodeStats() throws IOException {
        return this.dfs.datanodeReport(FSConstants.DatanodeReportType.ALL);
    }

    public boolean setSafeMode(FSConstants.SafeModeAction action) throws IOException {
        return this.dfs.setSafeMode(action);
    }

    public void saveNamespace() throws AccessControlException, IOException {
        this.dfs.saveNamespace();
    }

    public boolean restoreFailedStorage(String arg) throws AccessControlException {
        return this.dfs.restoreFailedStorage(arg);
    }

    public void refreshNodes() throws IOException {
        this.dfs.refreshNodes();
    }

    public void finalizeUpgrade() throws IOException {
        this.dfs.finalizeUpgrade();
    }

    public UpgradeStatusReport distributedUpgradeProgress(FSConstants.UpgradeAction action) throws IOException {
        return this.dfs.distributedUpgradeProgress(action);
    }

    public void metaSave(String pathname) throws IOException {
        this.dfs.metaSave(pathname);
    }

    public FsServerDefaults getServerDefaults() throws IOException {
        return this.dfs.getServerDefaults();
    }

    public boolean reportChecksumFailure(Path f, FSDataInputStream in, long inPos, FSDataInputStream sums, long sumsPos) {
        if (!(in instanceof DFSClient.DFSDataInputStream) || !(sums instanceof DFSClient.DFSDataInputStream)) {
            throw new IllegalArgumentException("Input streams must be types of DFSDataInputStream");
        }
        LocatedBlock[] lblocks = new LocatedBlock[2];
        DFSClient.DFSDataInputStream dfsIn = (DFSClient.DFSDataInputStream)in;
        Block dataBlock = dfsIn.getCurrentBlock();
        if (dataBlock == null) {
            LOG.error((Object)"Error: Current block in data stream is null! ");
            return false;
        }
        DatanodeInfo[] dataNode = new DatanodeInfo[]{dfsIn.getCurrentDatanode()};
        lblocks[0] = new LocatedBlock(dataBlock, dataNode);
        LOG.info((Object)("Found checksum error in data stream at block=" + dataBlock + " on datanode=" + dataNode[0].getName()));
        DFSClient.DFSDataInputStream dfsSums = (DFSClient.DFSDataInputStream)sums;
        Block sumsBlock = dfsSums.getCurrentBlock();
        if (sumsBlock == null) {
            LOG.error((Object)"Error: Current block in checksum stream is null! ");
            return false;
        }
        DatanodeInfo[] sumsNode = new DatanodeInfo[]{dfsSums.getCurrentDatanode()};
        lblocks[1] = new LocatedBlock(sumsBlock, sumsNode);
        LOG.info((Object)("Found checksum error in checksum stream at block=" + sumsBlock + " on datanode=" + sumsNode[0].getName()));
        this.dfs.reportChecksumFailure(f.toString(), lblocks);
        return true;
    }

    public FileStatus getFileStatus(Path f) throws IOException {
        HdfsFileStatus fi = this.dfs.getFileInfo(this.getPathName(f));
        if (fi != null) {
            return this.makeQualified(fi, f);
        }
        throw new FileNotFoundException("File does not exist: " + f);
    }

    public MD5MD5CRC32FileChecksum getFileChecksum(Path f) throws IOException {
        return this.dfs.getFileChecksum(this.getPathName(f));
    }

    public void setPermission(Path p, FsPermission permission) throws IOException {
        this.dfs.setPermission(this.getPathName(p), permission);
    }

    public void setOwner(Path p, String username, String groupname) throws IOException {
        if (username == null && groupname == null) {
            throw new IOException("username == null && groupname == null");
        }
        this.dfs.setOwner(this.getPathName(p), username, groupname);
    }

    public void setTimes(Path p, long mtime, long atime) throws IOException {
        this.dfs.setTimes(this.getPathName(p), mtime, atime);
    }

    public Token<DelegationTokenIdentifier> getDelegationToken(Text renewer) throws IOException {
        return this.dfs.getDelegationToken(renewer);
    }

    public long renewDelegationToken(Token<DelegationTokenIdentifier> token) throws SecretManager.InvalidToken, IOException {
        return this.dfs.renewDelegationToken(token);
    }

    public void cancelDelegationToken(Token<DelegationTokenIdentifier> token) throws IOException {
        this.dfs.cancelDelegationToken(token);
    }

    static {
        Configuration.addDefaultResource((String)"hdfs-default.xml");
        Configuration.addDefaultResource((String)"hdfs-site.xml");
    }

    @Deprecated
    @InterfaceAudience.Private
    public static class DiskStatus
    extends FsStatus {
        public DiskStatus(FsStatus stats) {
            super(stats.getCapacity(), stats.getUsed(), stats.getRemaining());
        }

        public DiskStatus(long capacity, long dfsUsed, long remaining) {
            super(capacity, dfsUsed, remaining);
        }

        public long getDfsUsed() {
            return super.getUsed();
        }
    }
}

