/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URLEncoder;
import java.security.PrivilegedExceptionAction;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspWriter;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.security.BlockAccessToken;
import org.apache.hadoop.hdfs.server.common.JspHelper;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
public class DatanodeJspHelper {
    private static final DataNode datanode = DataNode.getDataNode();

    private static DFSClient getDFSClient(UserGroupInformation user, final InetSocketAddress addr, final Configuration conf) throws IOException, InterruptedException {
        return (DFSClient)user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<DFSClient>(){

            @Override
            public DFSClient run() throws IOException {
                return new DFSClient(addr, conf);
            }
        });
    }

    private static int getDefaultChunkSize(Configuration conf) {
        return conf.getInt("dfs.default.chunk.view.size", 32768);
    }

    static void generateDirectoryStructure(JspWriter out, HttpServletRequest req, HttpServletResponse resp, Configuration conf) throws IOException, InterruptedException {
        String target;
        DFSClient dfs;
        HdfsFileStatus targetStatus;
        String dir = JspHelper.validatePath(req.getParameter("dir"));
        if (dir == null) {
            out.print("Invalid input");
            return;
        }
        String tokenString = req.getParameter("delegation");
        UserGroupInformation ugi = JspHelper.getUGI(req, conf);
        String namenodeInfoPortStr = req.getParameter("namenodeInfoPort");
        int namenodeInfoPort = -1;
        if (namenodeInfoPortStr != null) {
            namenodeInfoPort = Integer.parseInt(namenodeInfoPortStr);
        }
        if ((targetStatus = (dfs = DatanodeJspHelper.getDFSClient(ugi, datanode.getNameNodeAddr(), conf)).getFileInfo(target = dir)) == null) {
            out.print("<h3>File or directory : " + target + " does not exist</h3>");
            JspHelper.printGotoForm(out, namenodeInfoPort, tokenString, target);
        } else {
            DirectoryListing thisListing;
            if (!targetStatus.isDir()) {
                List<LocatedBlock> blocks = dfs.getNamenode().getBlockLocations(dir, 0L, 1L).getLocatedBlocks();
                LocatedBlock firstBlock = null;
                DatanodeInfo[] locations = null;
                if (blocks.size() > 0) {
                    firstBlock = blocks.get(0);
                    locations = firstBlock.getLocations();
                }
                if (locations == null || locations.length == 0) {
                    out.print("Empty file");
                } else {
                    DatanodeInfo chosenNode = JspHelper.bestNode(firstBlock);
                    String fqdn = InetAddress.getByName(chosenNode.getHost()).getCanonicalHostName();
                    String datanodeAddr = chosenNode.getName();
                    int datanodePort = Integer.parseInt(datanodeAddr.substring(datanodeAddr.indexOf(58) + 1, datanodeAddr.length()));
                    String redirectLocation = "http://" + fqdn + ":" + chosenNode.getInfoPort() + "/browseBlock.jsp?blockId=" + firstBlock.getBlock().getBlockId() + "&blockSize=" + firstBlock.getBlock().getNumBytes() + "&genstamp=" + firstBlock.getBlock().getGenerationStamp() + "&filename=" + URLEncoder.encode(dir, "UTF-8") + "&datanodePort=" + datanodePort + "&namenodeInfoPort=" + namenodeInfoPort + "&delegation=" + tokenString;
                    resp.sendRedirect(redirectLocation);
                }
                return;
            }
            String[] headings = new String[]{"Name", "Type", "Size", "Replication", "Block Size", "Modification Time", "Permission", "Owner", "Group"};
            out.print("<h3>Contents of directory ");
            JspHelper.printPathWithLinks(dir, out, namenodeInfoPort, tokenString);
            out.print("</h3><hr>");
            JspHelper.printGotoForm(out, namenodeInfoPort, tokenString, dir);
            out.print("<hr>");
            File f = new File(dir);
            String parent = f.getParent();
            if (parent != null) {
                out.print("<a href=\"" + req.getRequestURL() + "?dir=" + parent + "&namenodeInfoPort=" + namenodeInfoPort + "&delegation=" + tokenString + "\">Go to parent directory</a><br>");
            }
            if ((thisListing = dfs.listPaths(target, HdfsFileStatus.EMPTY_NAME)) == null || thisListing.getPartialListing().length == 0) {
                out.print("Empty directory");
            } else {
                JspHelper.addTableHeader(out);
                int row = 0;
                JspHelper.addTableRow(out, headings, row++);
                String[] cols = new String[headings.length];
                do {
                    HdfsFileStatus[] files = thisListing.getPartialListing();
                    for (int i = 0; i < files.length; ++i) {
                        String localFileName = files[i].getLocalName();
                        if (!files[i].isDir()) {
                            cols[1] = "file";
                            cols[2] = StringUtils.byteDesc((long)files[i].getLen());
                            cols[3] = Short.toString(files[i].getReplication());
                            cols[4] = StringUtils.byteDesc((long)files[i].getBlockSize());
                        } else {
                            cols[1] = "dir";
                            cols[2] = "";
                            cols[3] = "";
                            cols[4] = "";
                        }
                        String datanodeUrl = req.getRequestURL() + "?dir=" + URLEncoder.encode(files[i].getFullName(target), "UTF-8") + "&namenodeInfoPort=" + namenodeInfoPort + "&delegation=" + tokenString;
                        cols[0] = "<a href=\"" + datanodeUrl + "\">" + localFileName + "</a>";
                        cols[5] = FsShell.dateForm.format(new Date(files[i].getModificationTime()));
                        cols[6] = files[i].getPermission().toString();
                        cols[7] = files[i].getOwner();
                        cols[8] = files[i].getGroup();
                        JspHelper.addTableRow(out, cols, row++);
                    }
                } while (thisListing.hasMore() && (thisListing = dfs.listPaths(target, thisListing.getLastName())) != null);
                JspHelper.addTableFooter(out);
            }
        }
        String namenodeHost = datanode.getNameNodeAddr().getHostName();
        out.print("<br><a href=\"http://" + InetAddress.getByName(namenodeHost).getCanonicalHostName() + ":" + namenodeInfoPort + "/dfshealth.jsp\">Go back to DFS home</a>");
        dfs.close();
    }

    static void generateFileDetails(JspWriter out, HttpServletRequest req, Configuration conf) throws IOException, InterruptedException {
        DatanodeInfo chosenNode;
        long startOffset = 0L;
        Long blockId = JspHelper.validateLong(req.getParameter("blockId"));
        if (blockId == null) {
            out.print("Invalid input (blockId absent)");
            return;
        }
        String tokenString = req.getParameter("delegation");
        UserGroupInformation ugi = JspHelper.getUGI(req, conf);
        String datanodePortStr = req.getParameter("datanodePort");
        if (datanodePortStr == null) {
            out.print("Invalid input (datanodePort absent)");
            return;
        }
        int datanodePort = Integer.parseInt(datanodePortStr);
        String namenodeInfoPortStr = req.getParameter("namenodeInfoPort");
        int namenodeInfoPort = -1;
        if (namenodeInfoPortStr != null) {
            namenodeInfoPort = Integer.parseInt(namenodeInfoPortStr);
        }
        int chunkSizeToView = JspHelper.string2ChunkSizeToView(req.getParameter("chunkSizeToView"), DatanodeJspHelper.getDefaultChunkSize(conf));
        String startOffsetStr = req.getParameter("startOffset");
        startOffset = startOffsetStr == null || Long.parseLong(startOffsetStr) < 0L ? 0L : Long.parseLong(startOffsetStr);
        String filename = JspHelper.validatePath(req.getParameter("filename"));
        if (filename == null) {
            out.print("Invalid input");
            return;
        }
        String blockSizeStr = req.getParameter("blockSize");
        long blockSize = 0L;
        if (blockSizeStr == null || blockSizeStr.length() == 0) {
            out.print("Invalid input");
            return;
        }
        blockSize = Long.parseLong(blockSizeStr);
        DFSClient dfs = DatanodeJspHelper.getDFSClient(ugi, datanode.getNameNodeAddr(), conf);
        List<LocatedBlock> blocks = dfs.getNamenode().getBlockLocations(filename, 0L, Long.MAX_VALUE).getLocatedBlocks();
        String downloadUrl = "http://" + req.getServerName() + ":" + req.getServerPort() + "/streamFile?" + "filename=" + URLEncoder.encode(filename, "UTF-8") + "&delegation=" + tokenString;
        out.print("<a name=\"viewOptions\"></a>");
        out.print("<a href=\"" + downloadUrl + "\">Download this file</a><br>");
        LocatedBlock lastBlk = blocks.get(blocks.size() - 1);
        try {
            chosenNode = JspHelper.bestNode(lastBlk);
        }
        catch (IOException e) {
            out.print(e.toString());
            dfs.close();
            return;
        }
        String fqdn = InetAddress.getByName(chosenNode.getHost()).getCanonicalHostName();
        String tailUrl = "http://" + fqdn + ":" + chosenNode.getInfoPort() + "/tail.jsp?filename=" + URLEncoder.encode(filename, "UTF-8") + "&namenodeInfoPort=" + namenodeInfoPort + "&chunkSizeToView=" + chunkSizeToView + "&delegation=" + tokenString + "&referrer=" + URLEncoder.encode(req.getRequestURL() + "?" + req.getQueryString(), "UTF-8");
        out.print("<a href=\"" + tailUrl + "\">Tail this file</a><br>");
        out.print("<form action=\"/browseBlock.jsp\" method=GET>");
        out.print("<b>Chunk size to view (in bytes, up to file's DFS block size): </b>");
        out.print("<input type=\"hidden\" name=\"blockId\" value=\"" + blockId + "\">");
        out.print("<input type=\"hidden\" name=\"blockSize\" value=\"" + blockSize + "\">");
        out.print("<input type=\"hidden\" name=\"startOffset\" value=\"" + startOffset + "\">");
        out.print("<input type=\"hidden\" name=\"filename\" value=\"" + filename + "\">");
        out.print("<input type=\"hidden\" name=\"datanodePort\" value=\"" + datanodePort + "\">");
        out.print("<input type=\"hidden\" name=\"namenodeInfoPort\" value=\"" + namenodeInfoPort + "\">");
        out.print("<input type=\"text\" name=\"chunkSizeToView\" value=" + chunkSizeToView + " size=10 maxlength=10>");
        out.print("&nbsp;&nbsp;<input type=\"submit\" name=\"submit\" value=\"Refresh\">");
        out.print("</form>");
        out.print("<hr>");
        out.print("<a name=\"blockDetails\"></a>");
        out.print("<B>Total number of blocks: " + blocks.size() + "</B><br>");
        out.println("\n<table>");
        String namenodeHost = datanode.getNameNodeAddr().getHostName();
        String namenodeHostName = InetAddress.getByName(namenodeHost).getCanonicalHostName();
        for (LocatedBlock cur : blocks) {
            out.print("<tr>");
            String blockidstring = Long.toString(cur.getBlock().getBlockId());
            blockSize = cur.getBlock().getNumBytes();
            out.print("<td>" + blockidstring + ":</td>");
            DatanodeInfo[] locs = cur.getLocations();
            for (int j = 0; j < locs.length; ++j) {
                String datanodeAddr = locs[j].getName();
                datanodePort = Integer.parseInt(datanodeAddr.substring(datanodeAddr.indexOf(58) + 1, datanodeAddr.length()));
                fqdn = InetAddress.getByName(locs[j].getHost()).getCanonicalHostName();
                String blockUrl = "http://" + fqdn + ":" + locs[j].getInfoPort() + "/browseBlock.jsp?blockId=" + blockidstring + "&blockSize=" + blockSize + "&filename=" + URLEncoder.encode(filename, "UTF-8") + "&datanodePort=" + datanodePort + "&genstamp=" + cur.getBlock().getGenerationStamp() + "&namenodeInfoPort=" + namenodeInfoPort + "&chunkSizeToView=" + chunkSizeToView + "&delegation=" + tokenString;
                String blockInfoUrl = "http://" + namenodeHostName + ":" + namenodeInfoPort + "/block_info_xml.jsp?blockId=" + blockidstring;
                out.print("<td>&nbsp</td><td><a href=\"" + blockUrl + "\">" + datanodeAddr + "</a></td><td>" + "<a href=\"" + blockInfoUrl + "\">View Block Info</a></td>");
            }
            out.println("</tr>");
        }
        out.println("</table>");
        out.print("<hr>");
        out.print("<br><a href=\"http://" + InetAddress.getByName(namenodeHost).getCanonicalHostName() + ":" + namenodeInfoPort + "/dfshealth.jsp\">Go back to DFS home</a>");
        dfs.close();
    }

    static void generateFileChunks(JspWriter out, HttpServletRequest req, Configuration conf) throws IOException, InterruptedException {
        Long genStamp;
        String filename;
        long startOffset = 0L;
        int datanodePort = 0;
        String namenodeInfoPortStr = req.getParameter("namenodeInfoPort");
        String tokenString = req.getParameter("delegation");
        UserGroupInformation ugi = JspHelper.getUGI(req, conf);
        int namenodeInfoPort = -1;
        if (namenodeInfoPortStr != null) {
            namenodeInfoPort = Integer.parseInt(namenodeInfoPortStr);
        }
        if ((filename = JspHelper.validatePath(req.getParameter("filename"))) == null) {
            out.print("Invalid input (filename absent)");
            return;
        }
        Long blockId = JspHelper.validateLong(req.getParameter("blockId"));
        if (blockId == null) {
            out.print("Invalid input (blockId absent)");
            return;
        }
        DFSClient dfs = DatanodeJspHelper.getDFSClient(ugi, datanode.getNameNodeAddr(), conf);
        BlockAccessToken accessToken = BlockAccessToken.DUMMY_TOKEN;
        if (conf.getBoolean("dfs.block.access.token.enable", false)) {
            List<LocatedBlock> blks = dfs.getNamenode().getBlockLocations(filename, 0L, Long.MAX_VALUE).getLocatedBlocks();
            if (blks == null || blks.size() == 0) {
                out.print("Can't locate file blocks");
                dfs.close();
                return;
            }
            for (int i = 0; i < blks.size(); ++i) {
                if (blks.get(i).getBlock().getBlockId() != blockId.longValue()) continue;
                accessToken = blks.get(i).getAccessToken();
                break;
            }
        }
        if ((genStamp = JspHelper.validateLong(req.getParameter("genstamp"))) == null) {
            out.print("Invalid input (genstamp absent)");
            return;
        }
        long blockSize = 0L;
        String blockSizeStr = req.getParameter("blockSize");
        if (blockSizeStr == null) {
            out.print("Invalid input (blockSize absent)");
            return;
        }
        blockSize = Long.parseLong(blockSizeStr);
        int chunkSizeToView = JspHelper.string2ChunkSizeToView(req.getParameter("chunkSizeToView"), DatanodeJspHelper.getDefaultChunkSize(conf));
        String startOffsetStr = req.getParameter("startOffset");
        startOffset = startOffsetStr == null || Long.parseLong(startOffsetStr) < 0L ? 0L : Long.parseLong(startOffsetStr);
        String datanodePortStr = req.getParameter("datanodePort");
        if (datanodePortStr == null) {
            out.print("Invalid input (datanodePort absent)");
            return;
        }
        datanodePort = Integer.parseInt(datanodePortStr);
        out.print("<h3>File: ");
        JspHelper.printPathWithLinks(filename, out, namenodeInfoPort, tokenString);
        out.print("</h3><hr>");
        String parent = new File(filename).getParent();
        JspHelper.printGotoForm(out, namenodeInfoPort, tokenString, parent);
        out.print("<hr>");
        out.print("<a href=\"http://" + req.getServerName() + ":" + req.getServerPort() + "/browseDirectory.jsp?dir=" + URLEncoder.encode(parent, "UTF-8") + "&namenodeInfoPort=" + namenodeInfoPort + "&delegation=" + tokenString + "\"><i>Go back to dir listing</i></a><br>");
        out.print("<a href=\"#viewOptions\">Advanced view/download options</a><br>");
        out.print("<hr>");
        long nextStartOffset = 0L;
        long nextBlockSize = 0L;
        String nextBlockIdStr = null;
        String nextGenStamp = null;
        String nextHost = req.getServerName();
        int nextPort = req.getServerPort();
        int nextDatanodePort = datanodePort;
        if (startOffset + (long)chunkSizeToView >= blockSize) {
            List<LocatedBlock> blocks = dfs.getNamenode().getBlockLocations(filename, 0L, Long.MAX_VALUE).getLocatedBlocks();
            for (int i = 0; i < blocks.size(); ++i) {
                if (blocks.get(i).getBlock().getBlockId() != blockId.longValue() || i == blocks.size() - 1) continue;
                LocatedBlock nextBlock = blocks.get(i + 1);
                nextBlockIdStr = Long.toString(nextBlock.getBlock().getBlockId());
                nextGenStamp = Long.toString(nextBlock.getBlock().getGenerationStamp());
                nextStartOffset = 0L;
                nextBlockSize = nextBlock.getBlock().getNumBytes();
                DatanodeInfo d = JspHelper.bestNode(nextBlock);
                String datanodeAddr = d.getName();
                nextDatanodePort = Integer.parseInt(datanodeAddr.substring(datanodeAddr.indexOf(58) + 1, datanodeAddr.length()));
                nextHost = InetAddress.getByName(d.getHost()).getCanonicalHostName();
                nextPort = d.getInfoPort();
            }
        } else {
            nextBlockIdStr = blockId.toString();
            nextStartOffset = startOffset + (long)chunkSizeToView;
            nextBlockSize = blockSize;
            nextGenStamp = genStamp.toString();
        }
        String nextUrl = null;
        if (nextBlockIdStr != null) {
            nextUrl = "http://" + nextHost + ":" + nextPort + "/browseBlock.jsp?blockId=" + nextBlockIdStr + "&blockSize=" + nextBlockSize + "&startOffset=" + nextStartOffset + "&genstamp=" + nextGenStamp + "&filename=" + URLEncoder.encode(filename, "UTF-8") + "&chunkSizeToView=" + chunkSizeToView + "&datanodePort=" + nextDatanodePort + "&namenodeInfoPort=" + namenodeInfoPort + "&delegation=" + tokenString;
            out.print("<a href=\"" + nextUrl + "\">View Next chunk</a>&nbsp;&nbsp;");
        }
        String prevBlockIdStr = null;
        String prevGenStamp = null;
        long prevStartOffset = 0L;
        long prevBlockSize = 0L;
        String prevHost = req.getServerName();
        int prevPort = req.getServerPort();
        int prevDatanodePort = datanodePort;
        if (startOffset == 0L) {
            List<LocatedBlock> blocks = dfs.getNamenode().getBlockLocations(filename, 0L, Long.MAX_VALUE).getLocatedBlocks();
            for (int i = 0; i < blocks.size(); ++i) {
                if (blocks.get(i).getBlock().getBlockId() != blockId.longValue() || i == 0) continue;
                LocatedBlock prevBlock = blocks.get(i - 1);
                prevBlockIdStr = Long.toString(prevBlock.getBlock().getBlockId());
                prevGenStamp = Long.toString(prevBlock.getBlock().getGenerationStamp());
                prevStartOffset = prevBlock.getBlock().getNumBytes() - (long)chunkSizeToView;
                if (prevStartOffset < 0L) {
                    prevStartOffset = 0L;
                }
                prevBlockSize = prevBlock.getBlock().getNumBytes();
                DatanodeInfo d = JspHelper.bestNode(prevBlock);
                String datanodeAddr = d.getName();
                prevDatanodePort = Integer.parseInt(datanodeAddr.substring(datanodeAddr.indexOf(58) + 1, datanodeAddr.length()));
                prevHost = InetAddress.getByName(d.getHost()).getCanonicalHostName();
                prevPort = d.getInfoPort();
            }
        } else {
            prevBlockIdStr = blockId.toString();
            prevStartOffset = startOffset - (long)chunkSizeToView;
            if (prevStartOffset < 0L) {
                prevStartOffset = 0L;
            }
            prevBlockSize = blockSize;
            prevGenStamp = genStamp.toString();
        }
        String prevUrl = null;
        if (prevBlockIdStr != null) {
            prevUrl = "http://" + prevHost + ":" + prevPort + "/browseBlock.jsp?blockId=" + prevBlockIdStr + "&blockSize=" + prevBlockSize + "&startOffset=" + prevStartOffset + "&filename=" + URLEncoder.encode(filename, "UTF-8") + "&chunkSizeToView=" + chunkSizeToView + "&genstamp=" + prevGenStamp + "&datanodePort=" + prevDatanodePort + "&namenodeInfoPort=" + namenodeInfoPort + "&delegation=" + tokenString;
            out.print("<a href=\"" + prevUrl + "\">View Prev chunk</a>&nbsp;&nbsp;");
        }
        out.print("<hr>");
        out.print("<textarea cols=\"100\" rows=\"25\" wrap=\"virtual\" style=\"width:100%\" READONLY>");
        try {
            JspHelper.streamBlockInAscii(new InetSocketAddress(req.getServerName(), datanodePort), blockId, accessToken, genStamp, blockSize, startOffset, chunkSizeToView, out, conf);
        }
        catch (Exception e) {
            out.print((Object)e);
        }
        out.print("</textarea>");
        dfs.close();
    }

    static void generateFileChunksForTail(JspWriter out, HttpServletRequest req, Configuration conf) throws IOException, InterruptedException {
        DatanodeInfo chosenNode;
        DFSClient dfs;
        List<LocatedBlock> blocks;
        String filename;
        String referrer = JspHelper.validateURL(req.getParameter("referrer"));
        boolean noLink = false;
        if (referrer == null) {
            noLink = true;
        }
        if ((filename = JspHelper.validatePath(req.getParameter("filename"))) == null) {
            out.print("Invalid input (file name absent)");
            return;
        }
        String tokenString = req.getParameter("delegation");
        UserGroupInformation ugi = JspHelper.getUGI(req, conf);
        String namenodeInfoPortStr = req.getParameter("namenodeInfoPort");
        int namenodeInfoPort = -1;
        if (namenodeInfoPortStr != null) {
            namenodeInfoPort = Integer.parseInt(namenodeInfoPortStr);
        }
        int chunkSizeToView = JspHelper.string2ChunkSizeToView(req.getParameter("chunkSizeToView"), DatanodeJspHelper.getDefaultChunkSize(conf));
        if (!noLink) {
            out.print("<h3>Tail of File: ");
            JspHelper.printPathWithLinks(filename, out, namenodeInfoPort, tokenString);
            out.print("</h3><hr>");
            out.print("<a href=\"" + referrer + "\">Go Back to File View</a><hr>");
        } else {
            out.print("<h3>" + filename + "</h3>");
        }
        out.print("<b>Chunk size to view (in bytes, up to file's DFS block size): </b>");
        out.print("<input type=\"text\" name=\"chunkSizeToView\" value=" + chunkSizeToView + " size=10 maxlength=10>");
        out.print("&nbsp;&nbsp;<input type=\"submit\" name=\"submit\" value=\"Refresh\"><hr>");
        out.print("<input type=\"hidden\" name=\"filename\" value=\"" + filename + "\">");
        out.print("<input type=\"hidden\" name=\"namenodeInfoPort\" value=\"" + namenodeInfoPort + "\">");
        if (!noLink) {
            out.print("<input type=\"hidden\" name=\"referrer\" value=\"" + referrer + "\">");
        }
        if ((blocks = (dfs = DatanodeJspHelper.getDFSClient(ugi, datanode.getNameNodeAddr(), conf)).getNamenode().getBlockLocations(filename, 0L, Long.MAX_VALUE).getLocatedBlocks()) == null || blocks.size() == 0) {
            out.print("No datanodes contain blocks of file " + filename);
            dfs.close();
            return;
        }
        LocatedBlock lastBlk = blocks.get(blocks.size() - 1);
        long blockSize = lastBlk.getBlock().getNumBytes();
        long blockId = lastBlk.getBlock().getBlockId();
        BlockAccessToken accessToken = lastBlk.getAccessToken();
        long genStamp = lastBlk.getBlock().getGenerationStamp();
        try {
            chosenNode = JspHelper.bestNode(lastBlk);
        }
        catch (IOException e) {
            out.print(e.toString());
            dfs.close();
            return;
        }
        InetSocketAddress addr = NetUtils.createSocketAddr((String)chosenNode.getName());
        long startOffset = blockSize >= (long)chunkSizeToView ? blockSize - (long)chunkSizeToView : 0L;
        out.print("<textarea cols=\"100\" rows=\"25\" wrap=\"virtual\" style=\"width:100%\" READONLY>");
        JspHelper.streamBlockInAscii(addr, blockId, accessToken, genStamp, blockSize, startOffset, chunkSizeToView, out, conf);
        out.print("</textarea>");
        dfs.close();
    }
}

