/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.protocol;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.common.HdfsConstants;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class ReplicaRecoveryInfo
extends Block {
    private HdfsConstants.ReplicaState originalState;
    public static final String __PARANAMER_DATA = "<init> long,long,long,org.apache.hadoop.hdfs.server.common.HdfsConstants.ReplicaState blockId,diskLen,gs,rState \nequals java.lang.Object o \nreadFields java.io.DataInput in \nwrite java.io.DataOutput out \n";

    public ReplicaRecoveryInfo() {
    }

    public ReplicaRecoveryInfo(long blockId, long diskLen, long gs, HdfsConstants.ReplicaState rState) {
        this.set(blockId, diskLen, gs);
        this.originalState = rState;
    }

    public HdfsConstants.ReplicaState getOriginalReplicaState() {
        return this.originalState;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.originalState = HdfsConstants.ReplicaState.read(in);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        this.originalState.write(out);
    }

    static {
        WritableFactories.setFactory(ReplicaRecoveryInfo.class, (WritableFactory)new WritableFactory(){

            public Writable newInstance() {
                return new ReplicaRecoveryInfo();
            }
        });
    }
}

