/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.SocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.FsStatus;
import org.apache.hadoop.fs.InvalidPathException;
import org.apache.hadoop.fs.MD5MD5CRC32FileChecksum;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.ParentNotDirectoryException;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSInputStream;
import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.LeaseRenewer;
import org.apache.hadoop.hdfs.SocketCache;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.CorruptFileBlocks;
import org.apache.hadoop.hdfs.protocol.DSQuotaExceededException;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.HdfsProtoUtil;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.NSQuotaExceededException;
import org.apache.hadoop.hdfs.protocol.UnresolvedPathException;
import org.apache.hadoop.hdfs.protocol.datatransfer.Op;
import org.apache.hadoop.hdfs.protocol.datatransfer.ReplaceDatanodeOnFailure;
import org.apache.hadoop.hdfs.protocol.datatransfer.Sender;
import org.apache.hadoop.hdfs.protocol.proto.DataTransferProtos;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.UpgradeStatusReport;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.SafeModeException;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.MD5Hash;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.Client;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenRenewer;
import org.apache.hadoop.util.DataChecksum;
import org.apache.hadoop.util.Progressable;

@InterfaceAudience.Private
public class DFSClient
implements Closeable {
    public static final Log LOG = LogFactory.getLog(DFSClient.class);
    public static final long SERVER_DEFAULTS_VALIDITY_PERIOD = 3600000L;
    static final int TCP_WINDOW_SIZE = 131072;
    final ClientProtocol namenode;
    final ClientProtocol rpcNamenode;
    private final InetSocketAddress nnAddress;
    final UserGroupInformation ugi;
    volatile boolean clientRunning = true;
    private volatile FsServerDefaults serverDefaults;
    private volatile long serverDefaultsLastUpdate;
    final String clientName;
    Configuration conf;
    SocketFactory socketFactory;
    final ReplaceDatanodeOnFailure dtpReplaceDatanodeOnFailure;
    final FileSystem.Statistics stats;
    final int hdfsTimeout;
    final LeaseRenewer leaserenewer;
    final SocketCache socketCache;
    final Conf dfsClientConf;
    private final Map<String, DFSOutputStream> filesBeingWritten = new HashMap<String, DFSOutputStream>();

    Conf getConf() {
        return this.dfsClientConf;
    }

    @Deprecated
    public DFSClient(Configuration conf) throws IOException {
        this(NameNode.getAddress(conf), conf);
    }

    public DFSClient(InetSocketAddress nameNodeAddr, Configuration conf) throws IOException {
        this(nameNodeAddr, conf, null);
    }

    public DFSClient(InetSocketAddress nameNodeAddr, Configuration conf, FileSystem.Statistics stats) throws IOException {
        this(nameNodeAddr, null, conf, stats);
    }

    DFSClient(InetSocketAddress nameNodeAddr, ClientProtocol rpcNamenode, Configuration conf, FileSystem.Statistics stats) throws IOException {
        this.dfsClientConf = new Conf(conf);
        this.conf = conf;
        this.stats = stats;
        this.nnAddress = nameNodeAddr;
        this.socketFactory = NetUtils.getSocketFactory((Configuration)conf, ClientProtocol.class);
        this.dtpReplaceDatanodeOnFailure = ReplaceDatanodeOnFailure.get(conf);
        this.hdfsTimeout = Client.getTimeout((Configuration)conf);
        this.ugi = UserGroupInformation.getCurrentUser();
        String authority = nameNodeAddr == null ? "null" : nameNodeAddr.getHostName() + ":" + nameNodeAddr.getPort();
        this.leaserenewer = LeaseRenewer.getInstance(authority, this.ugi, this);
        this.clientName = this.leaserenewer.getClientName(this.dfsClientConf.taskId);
        this.socketCache = new SocketCache(this.dfsClientConf.socketCacheCapacity);
        if (nameNodeAddr != null && rpcNamenode == null) {
            this.rpcNamenode = DFSUtil.createRPCNamenode(nameNodeAddr, conf, this.ugi);
            this.namenode = DFSUtil.createNamenode(this.rpcNamenode);
        } else if (nameNodeAddr == null && rpcNamenode != null) {
            this.namenode = this.rpcNamenode = rpcNamenode;
        } else {
            throw new IllegalArgumentException("Expecting exactly one of nameNodeAddr and rpcNamenode being null: nameNodeAddr=" + nameNodeAddr + ", rpcNamenode=" + rpcNamenode);
        }
    }

    int getMaxBlockAcquireFailures() {
        return this.dfsClientConf.maxBlockAcquireFailures;
    }

    int getDatanodeWriteTimeout(int numNodes) {
        return this.dfsClientConf.confTime > 0 ? this.dfsClientConf.confTime + HdfsServerConstants.WRITE_TIMEOUT_EXTENSION * numNodes : 0;
    }

    int getDatanodeReadTimeout(int numNodes) {
        return this.dfsClientConf.socketTimeout > 0 ? HdfsServerConstants.READ_TIMEOUT_EXTENSION * numNodes + this.dfsClientConf.socketTimeout : 0;
    }

    int getHdfsTimeout() {
        return this.hdfsTimeout;
    }

    String getClientName() {
        return this.clientName;
    }

    void checkOpen() throws IOException {
        if (!this.clientRunning) {
            IOException result = new IOException("Filesystem closed");
            throw result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void putFileBeingWritten(String src, DFSOutputStream out) {
        Map<String, DFSOutputStream> map = this.filesBeingWritten;
        synchronized (map) {
            this.filesBeingWritten.put(src, out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFileBeingWritten(String src) {
        Map<String, DFSOutputStream> map = this.filesBeingWritten;
        synchronized (map) {
            this.filesBeingWritten.remove(src);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isFilesBeingWrittenEmpty() {
        Map<String, DFSOutputStream> map = this.filesBeingWritten;
        synchronized (map) {
            return this.filesBeingWritten.isEmpty();
        }
    }

    boolean isClientRunning() {
        return this.clientRunning;
    }

    void renewLease() throws IOException {
        if (this.clientRunning && !this.isFilesBeingWrittenEmpty()) {
            this.namenode.renewLease(this.clientName);
        }
    }

    void abort() {
        this.clientRunning = false;
        this.closeAllFilesBeingWritten(true);
        RPC.stopProxy((Object)this.rpcNamenode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAllFilesBeingWritten(boolean abort) {
        while (true) {
            DFSOutputStream out;
            String src;
            Map<String, DFSOutputStream> map = this.filesBeingWritten;
            synchronized (map) {
                if (this.filesBeingWritten.isEmpty()) {
                    return;
                }
                src = this.filesBeingWritten.keySet().iterator().next();
                out = this.filesBeingWritten.remove(src);
            }
            if (out == null) continue;
            try {
                if (abort) {
                    out.abort();
                    continue;
                }
                out.close();
                continue;
            }
            catch (IOException ie) {
                LOG.error((Object)("Failed to " + (abort ? "abort" : "close") + " file " + src), (Throwable)ie);
                continue;
            }
            break;
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.clientRunning) {
            this.closeAllFilesBeingWritten(false);
            this.clientRunning = false;
            this.leaserenewer.closeClient(this);
            RPC.stopProxy((Object)this.rpcNamenode);
        }
    }

    public long getDefaultBlockSize() {
        return this.dfsClientConf.defaultBlockSize;
    }

    public long getBlockSize(String f) throws IOException {
        try {
            return this.namenode.getPreferredBlockSize(f);
        }
        catch (IOException ie) {
            LOG.warn((Object)"Problem getting block size", (Throwable)ie);
            throw ie;
        }
    }

    public FsServerDefaults getServerDefaults() throws IOException {
        long now = System.currentTimeMillis();
        if (now - this.serverDefaultsLastUpdate > 3600000L) {
            this.serverDefaults = this.namenode.getServerDefaults();
            this.serverDefaultsLastUpdate = now;
        }
        return this.serverDefaults;
    }

    public Token<DelegationTokenIdentifier> getDelegationToken(Text renewer) throws IOException {
        Token<DelegationTokenIdentifier> result = this.namenode.getDelegationToken(renewer);
        SecurityUtil.setTokenService(result, (InetSocketAddress)this.nnAddress);
        LOG.info((Object)("Created " + DelegationTokenIdentifier.stringifyToken(result)));
        return result;
    }

    public long renewDelegationToken(Token<DelegationTokenIdentifier> token) throws SecretManager.InvalidToken, IOException {
        LOG.info((Object)("Renewing " + DelegationTokenIdentifier.stringifyToken(token)));
        try {
            return token.renew(this.conf);
        }
        catch (InterruptedException ie) {
            throw new RuntimeException("caught interrupted", ie);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{SecretManager.InvalidToken.class, AccessControlException.class});
        }
    }

    public void cancelDelegationToken(Token<DelegationTokenIdentifier> token) throws SecretManager.InvalidToken, IOException {
        LOG.info((Object)("Cancelling " + DelegationTokenIdentifier.stringifyToken(token)));
        try {
            token.cancel(this.conf);
        }
        catch (InterruptedException ie) {
            throw new RuntimeException("caught interrupted", ie);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{SecretManager.InvalidToken.class, AccessControlException.class});
        }
    }

    public void reportBadBlocks(LocatedBlock[] blocks) throws IOException {
        this.namenode.reportBadBlocks(blocks);
    }

    public short getDefaultReplication() {
        return this.dfsClientConf.defaultReplication;
    }

    static LocatedBlocks callGetBlockLocations(ClientProtocol namenode, String src, long start, long length) throws IOException {
        try {
            return namenode.getBlockLocations(src, start, length);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, FileNotFoundException.class, UnresolvedPathException.class});
        }
    }

    boolean recoverLease(String src) throws IOException {
        this.checkOpen();
        try {
            return this.namenode.recoverLease(src, this.clientName);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{FileNotFoundException.class, AccessControlException.class});
        }
    }

    public BlockLocation[] getBlockLocations(String src, long start, long length) throws IOException, UnresolvedLinkException {
        LocatedBlocks blocks = DFSClient.callGetBlockLocations(this.namenode, src, start, length);
        return DFSUtil.locatedBlocks2Locations(blocks);
    }

    public DFSInputStream open(String src) throws IOException, UnresolvedLinkException {
        return this.open(src, this.dfsClientConf.ioBufferSize, true, null);
    }

    @Deprecated
    public DFSInputStream open(String src, int buffersize, boolean verifyChecksum, FileSystem.Statistics stats) throws IOException, UnresolvedLinkException {
        return this.open(src, buffersize, verifyChecksum);
    }

    public DFSInputStream open(String src, int buffersize, boolean verifyChecksum) throws IOException, UnresolvedLinkException {
        this.checkOpen();
        return new DFSInputStream(this, src, buffersize, verifyChecksum);
    }

    public ClientProtocol getNamenode() {
        return this.namenode;
    }

    public OutputStream create(String src, boolean overwrite) throws IOException {
        return this.create(src, overwrite, this.dfsClientConf.defaultReplication, this.dfsClientConf.defaultBlockSize, null);
    }

    public OutputStream create(String src, boolean overwrite, Progressable progress) throws IOException {
        return this.create(src, overwrite, this.dfsClientConf.defaultReplication, this.dfsClientConf.defaultBlockSize, progress);
    }

    public OutputStream create(String src, boolean overwrite, short replication, long blockSize) throws IOException {
        return this.create(src, overwrite, replication, blockSize, null);
    }

    public OutputStream create(String src, boolean overwrite, short replication, long blockSize, Progressable progress) throws IOException {
        return this.create(src, overwrite, replication, blockSize, progress, this.dfsClientConf.ioBufferSize);
    }

    public OutputStream create(String src, boolean overwrite, short replication, long blockSize, Progressable progress, int buffersize) throws IOException {
        return this.create(src, FsPermission.getDefault(), overwrite ? EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE) : EnumSet.of(CreateFlag.CREATE), replication, blockSize, progress, buffersize);
    }

    public OutputStream create(String src, FsPermission permission, EnumSet<CreateFlag> flag, short replication, long blockSize, Progressable progress, int buffersize) throws IOException {
        return this.create(src, permission, flag, true, replication, blockSize, progress, buffersize);
    }

    public OutputStream create(String src, FsPermission permission, EnumSet<CreateFlag> flag, boolean createParent, short replication, long blockSize, Progressable progress, int buffersize) throws IOException {
        this.checkOpen();
        if (permission == null) {
            permission = FsPermission.getDefault();
        }
        FsPermission masked = permission.applyUMask(this.dfsClientConf.uMask);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(src + ": masked=" + masked));
        }
        DFSOutputStream result = new DFSOutputStream(this, src, masked, flag, createParent, replication, blockSize, progress, buffersize, this.dfsClientConf.createChecksum());
        this.leaserenewer.put(src, result, this);
        return result;
    }

    private DFSOutputStream primitiveAppend(String src, EnumSet<CreateFlag> flag, int buffersize, Progressable progress) throws IOException {
        if (flag.contains(CreateFlag.APPEND)) {
            HdfsFileStatus stat = this.getFileInfo(src);
            if (stat == null) {
                if (!flag.contains(CreateFlag.CREATE)) {
                    throw new FileNotFoundException("failed to append to non-existent file " + src + " on client " + this.clientName);
                }
                return null;
            }
            return this.callAppend(stat, src, buffersize, progress);
        }
        return null;
    }

    public OutputStream primitiveCreate(String src, FsPermission absPermission, EnumSet<CreateFlag> flag, boolean createParent, short replication, long blockSize, Progressable progress, int buffersize, int bytesPerChecksum) throws IOException, UnresolvedLinkException {
        this.checkOpen();
        CreateFlag.validate(flag);
        DFSOutputStream result = this.primitiveAppend(src, flag, buffersize, progress);
        if (result == null) {
            DataChecksum checksum = DataChecksum.newDataChecksum((int)this.dfsClientConf.checksumType, (int)bytesPerChecksum);
            result = new DFSOutputStream(this, src, absPermission, flag, createParent, replication, blockSize, progress, buffersize, checksum);
        }
        this.leaserenewer.put(src, result, this);
        return result;
    }

    public void createSymlink(String target, String link, boolean createParent) throws IOException {
        try {
            FsPermission dirPerm = FsPermission.getDefault().applyUMask(this.dfsClientConf.uMask);
            this.namenode.createSymlink(target, link, dirPerm, createParent);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, FileAlreadyExistsException.class, FileNotFoundException.class, ParentNotDirectoryException.class, NSQuotaExceededException.class, DSQuotaExceededException.class, UnresolvedPathException.class});
        }
    }

    public String getLinkTarget(String path) throws IOException {
        this.checkOpen();
        try {
            return this.namenode.getLinkTarget(path);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, FileNotFoundException.class});
        }
    }

    private DFSOutputStream callAppend(HdfsFileStatus stat, String src, int buffersize, Progressable progress) throws IOException {
        LocatedBlock lastBlock = null;
        try {
            lastBlock = this.namenode.append(src, this.clientName);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, FileNotFoundException.class, SafeModeException.class, DSQuotaExceededException.class, UnsupportedOperationException.class, UnresolvedPathException.class});
        }
        return new DFSOutputStream(this, src, buffersize, progress, lastBlock, stat, this.dfsClientConf.createChecksum());
    }

    public FSDataOutputStream append(String src, int buffersize, Progressable progress, FileSystem.Statistics statistics) throws IOException {
        DFSOutputStream out = this.append(src, buffersize, progress);
        return new FSDataOutputStream((OutputStream)((Object)out), statistics, out.getInitialLen());
    }

    private DFSOutputStream append(String src, int buffersize, Progressable progress) throws IOException {
        this.checkOpen();
        HdfsFileStatus stat = this.getFileInfo(src);
        if (stat == null) {
            throw new FileNotFoundException("failed to append to non-existent file " + src + " on client " + this.clientName);
        }
        DFSOutputStream result = this.callAppend(stat, src, buffersize, progress);
        this.leaserenewer.put(src, result, this);
        return result;
    }

    public boolean setReplication(String src, short replication) throws IOException {
        try {
            return this.namenode.setReplication(src, replication);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, FileNotFoundException.class, SafeModeException.class, DSQuotaExceededException.class, UnresolvedPathException.class});
        }
    }

    @Deprecated
    public boolean rename(String src, String dst) throws IOException {
        this.checkOpen();
        try {
            return this.namenode.rename(src, dst);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, NSQuotaExceededException.class, DSQuotaExceededException.class, UnresolvedPathException.class});
        }
    }

    public void concat(String trg, String[] srcs) throws IOException {
        this.checkOpen();
        try {
            this.namenode.concat(trg, srcs);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, UnresolvedPathException.class});
        }
    }

    public void rename(String src, String dst, Options.Rename ... options) throws IOException {
        this.checkOpen();
        try {
            this.namenode.rename2(src, dst, options);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, DSQuotaExceededException.class, FileAlreadyExistsException.class, FileNotFoundException.class, ParentNotDirectoryException.class, SafeModeException.class, NSQuotaExceededException.class, UnresolvedPathException.class});
        }
    }

    @Deprecated
    public boolean delete(String src) throws IOException {
        this.checkOpen();
        return this.namenode.delete(src, true);
    }

    public boolean delete(String src, boolean recursive) throws IOException {
        this.checkOpen();
        try {
            return this.namenode.delete(src, recursive);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, FileNotFoundException.class, SafeModeException.class, UnresolvedPathException.class});
        }
    }

    public boolean exists(String src) throws IOException {
        this.checkOpen();
        return this.getFileInfo(src) != null;
    }

    public DirectoryListing listPaths(String src, byte[] startAfter) throws IOException {
        return this.listPaths(src, startAfter, false);
    }

    public DirectoryListing listPaths(String src, byte[] startAfter, boolean needLocation) throws IOException {
        this.checkOpen();
        try {
            return this.namenode.getListing(src, startAfter, needLocation);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, FileNotFoundException.class, UnresolvedPathException.class});
        }
    }

    public HdfsFileStatus getFileInfo(String src) throws IOException {
        this.checkOpen();
        try {
            return this.namenode.getFileInfo(src);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, FileNotFoundException.class, UnresolvedPathException.class});
        }
    }

    public HdfsFileStatus getFileLinkInfo(String src) throws IOException {
        this.checkOpen();
        try {
            return this.namenode.getFileLinkInfo(src);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, UnresolvedPathException.class});
        }
    }

    public MD5MD5CRC32FileChecksum getFileChecksum(String src) throws IOException {
        this.checkOpen();
        return DFSClient.getFileChecksum(src, this.namenode, this.socketFactory, this.dfsClientConf.socketTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static MD5MD5CRC32FileChecksum getFileChecksum(String src, ClientProtocol namenode, SocketFactory socketFactory, int socketTimeout) throws IOException {
        blockLocations = DFSClient.callGetBlockLocations(namenode, src, 0L, 0x7FFFFFFFFFFFFFFFL);
        if (null == blockLocations) {
            throw new FileNotFoundException("File does not exist: " + src);
        }
        locatedblocks = blockLocations.getLocatedBlocks();
        md5out = new DataOutputBuffer();
        bytesPerCRC = 0;
        crcPerBlock = 0L;
        refetchBlocks = false;
        lastRetriedIndex = -1;
        for (i = 0; i < locatedblocks.size(); ++i) {
            if (refetchBlocks) {
                blockLocations = DFSClient.callGetBlockLocations(namenode, src, 0L, 0x7FFFFFFFFFFFFFFFL);
                if (null == blockLocations) {
                    throw new FileNotFoundException("File does not exist: " + src);
                }
                locatedblocks = blockLocations.getLocatedBlocks();
                refetchBlocks = false;
            }
            lb = locatedblocks.get(i);
            block = lb.getBlock();
            datanodes = lb.getLocations();
            timeout = 3000 * datanodes.length + socketTimeout;
            done = false;
            for (j = 0; !done && j < datanodes.length; ++j) {
                block18: {
                    block17: {
                        sock = null;
                        out = null;
                        in = null;
                        sock = socketFactory.createSocket();
                        NetUtils.connect((Socket)sock, (SocketAddress)NetUtils.createSocketAddr((String)datanodes[j].getName()), (int)timeout);
                        sock.setSoTimeout(timeout);
                        out = new DataOutputStream(new BufferedOutputStream(NetUtils.getOutputStream((Socket)sock), HdfsConstants.SMALL_BUFFER_SIZE));
                        in = new DataInputStream(NetUtils.getInputStream((Socket)sock));
                        if (DFSClient.LOG.isDebugEnabled()) {
                            DFSClient.LOG.debug((Object)("write to " + datanodes[j].getName() + ": " + (Object)Op.BLOCK_CHECKSUM + ", block=" + block));
                        }
                        new Sender(out).blockChecksum(block, lb.getBlockToken());
                        reply = DataTransferProtos.BlockOpResponseProto.parseFrom(HdfsProtoUtil.vintPrefixed(in));
                        if (reply.getStatus() == DataTransferProtos.Status.SUCCESS) ** GOTO lbl50
                        if (reply.getStatus() != DataTransferProtos.Status.ERROR_ACCESS_TOKEN || i <= lastRetriedIndex) break block17;
                        if (DFSClient.LOG.isDebugEnabled()) {
                            DFSClient.LOG.debug((Object)("Got access token error in response to OP_BLOCK_CHECKSUM for file " + src + " for block " + block + " from datanode " + datanodes[j].getName() + ". Will retry the block once."));
                        }
                        lastRetriedIndex = i--;
                        done = true;
                        refetchBlocks = true;
                        IOUtils.closeStream((Closeable)in);
                        IOUtils.closeStream((Closeable)out);
                        IOUtils.closeSocket((Socket)sock);
                        break;
                    }
                    try {
                        throw new IOException("Bad response " + reply + " for block " + block + " from datanode " + datanodes[j].getName());
lbl50:
                        // 1 sources

                        checksumData = reply.getChecksumResponse();
                        bpc = checksumData.getBytesPerCrc();
                        if (i == 0) {
                            bytesPerCRC = bpc;
                        } else if (bpc != bytesPerCRC) {
                            throw new IOException("Byte-per-checksum not matched: bpc=" + bpc + " but bytesPerCRC=" + bytesPerCRC);
                        }
                        cpb = checksumData.getCrcPerBlock();
                        if (locatedblocks.size() > 1 && i == 0) {
                            crcPerBlock = cpb;
                        }
                        md5 = new MD5Hash(checksumData.getMd5().toByteArray());
                        md5.write((DataOutput)md5out);
                        done = true;
                        if (!DFSClient.LOG.isDebugEnabled()) break block18;
                        if (i == 0) {
                            DFSClient.LOG.debug((Object)("set bytesPerCRC=" + bytesPerCRC + ", crcPerBlock=" + crcPerBlock));
                        }
                        DFSClient.LOG.debug((Object)("got reply from " + datanodes[j].getName() + ": md5=" + md5));
                    }
                    catch (IOException ie) {
                        try {
                            DFSClient.LOG.warn((Object)("src=" + src + ", datanodes[" + j + "].getName()=" + datanodes[j].getName()), (Throwable)ie);
                        }
                        catch (Throwable var28_28) {
                            IOUtils.closeStream(in);
                            IOUtils.closeStream(out);
                            IOUtils.closeSocket((Socket)sock);
                            throw var28_28;
                        }
                        IOUtils.closeStream(in);
                        IOUtils.closeStream((Closeable)out);
                        IOUtils.closeSocket((Socket)sock);
                        continue;
                    }
                }
                IOUtils.closeStream((Closeable)in);
                IOUtils.closeStream((Closeable)out);
                IOUtils.closeSocket((Socket)sock);
                continue;
            }
            if (done) continue;
            throw new IOException("Fail to get block MD5 for " + block);
        }
        fileMD5 = MD5Hash.digest((byte[])md5out.getData());
        return new MD5MD5CRC32FileChecksum(bytesPerCRC, crcPerBlock, fileMD5);
    }

    public void setPermission(String src, FsPermission permission) throws IOException {
        this.checkOpen();
        try {
            this.namenode.setPermission(src, permission);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, FileNotFoundException.class, SafeModeException.class, UnresolvedPathException.class});
        }
    }

    public void setOwner(String src, String username, String groupname) throws IOException {
        this.checkOpen();
        try {
            this.namenode.setOwner(src, username, groupname);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, FileNotFoundException.class, SafeModeException.class, UnresolvedPathException.class});
        }
    }

    public FsStatus getDiskStatus() throws IOException {
        long[] rawNums = this.namenode.getStats();
        return new FsStatus(rawNums[0], rawNums[1], rawNums[2]);
    }

    public long getMissingBlocksCount() throws IOException {
        return this.namenode.getStats()[5];
    }

    public long getUnderReplicatedBlocksCount() throws IOException {
        return this.namenode.getStats()[3];
    }

    public long getCorruptBlocksCount() throws IOException {
        return this.namenode.getStats()[4];
    }

    public CorruptFileBlocks listCorruptFileBlocks(String path, String cookie) throws IOException {
        return this.namenode.listCorruptFileBlocks(path, cookie);
    }

    public DatanodeInfo[] datanodeReport(HdfsConstants.DatanodeReportType type) throws IOException {
        return this.namenode.getDatanodeReport(type);
    }

    public boolean setSafeMode(HdfsConstants.SafeModeAction action) throws IOException {
        return this.namenode.setSafeMode(action);
    }

    void saveNamespace() throws AccessControlException, IOException {
        try {
            this.namenode.saveNamespace();
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class});
        }
    }

    boolean restoreFailedStorage(String arg) throws AccessControlException {
        return this.namenode.restoreFailedStorage(arg);
    }

    public void refreshNodes() throws IOException {
        this.namenode.refreshNodes();
    }

    public void metaSave(String pathname) throws IOException {
        this.namenode.metaSave(pathname);
    }

    public void setBalancerBandwidth(long bandwidth) throws IOException {
        this.namenode.setBalancerBandwidth(bandwidth);
    }

    public void finalizeUpgrade() throws IOException {
        this.namenode.finalizeUpgrade();
    }

    public UpgradeStatusReport distributedUpgradeProgress(HdfsConstants.UpgradeAction action) throws IOException {
        return this.namenode.distributedUpgradeProgress(action);
    }

    @Deprecated
    public boolean mkdirs(String src) throws IOException {
        return this.mkdirs(src, null, true);
    }

    public boolean mkdirs(String src, FsPermission permission, boolean createParent) throws IOException {
        this.checkOpen();
        if (permission == null) {
            permission = FsPermission.getDefault();
        }
        FsPermission masked = permission.applyUMask(this.dfsClientConf.uMask);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(src + ": masked=" + masked));
        }
        try {
            return this.namenode.mkdirs(src, masked, createParent);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, InvalidPathException.class, FileAlreadyExistsException.class, FileNotFoundException.class, ParentNotDirectoryException.class, SafeModeException.class, NSQuotaExceededException.class, UnresolvedPathException.class});
        }
    }

    public boolean primitiveMkdir(String src, FsPermission absPermission) throws IOException {
        this.checkOpen();
        if (absPermission == null) {
            absPermission = FsPermission.getDefault().applyUMask(this.dfsClientConf.uMask);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(src + ": masked=" + absPermission));
        }
        try {
            return this.namenode.mkdirs(src, absPermission, true);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, NSQuotaExceededException.class, DSQuotaExceededException.class, UnresolvedPathException.class});
        }
    }

    ContentSummary getContentSummary(String src) throws IOException {
        try {
            return this.namenode.getContentSummary(src);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, FileNotFoundException.class, UnresolvedPathException.class});
        }
    }

    void setQuota(String src, long namespaceQuota, long diskspaceQuota) throws IOException {
        if (namespaceQuota <= 0L && namespaceQuota != Long.MAX_VALUE && namespaceQuota != -1L || diskspaceQuota <= 0L && diskspaceQuota != Long.MAX_VALUE && diskspaceQuota != -1L) {
            throw new IllegalArgumentException("Invalid values for quota : " + namespaceQuota + " and " + diskspaceQuota);
        }
        try {
            this.namenode.setQuota(src, namespaceQuota, diskspaceQuota);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, FileNotFoundException.class, NSQuotaExceededException.class, DSQuotaExceededException.class, UnresolvedPathException.class});
        }
    }

    public void setTimes(String src, long mtime, long atime) throws IOException {
        this.checkOpen();
        try {
            this.namenode.setTimes(src, mtime, atime);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, FileNotFoundException.class, UnresolvedPathException.class});
        }
    }

    void reportChecksumFailure(String file, ExtendedBlock blk, DatanodeInfo dn) {
        DatanodeInfo[] dnArr = new DatanodeInfo[]{dn};
        LocatedBlock[] lblocks = new LocatedBlock[]{new LocatedBlock(blk, dnArr)};
        this.reportChecksumFailure(file, lblocks);
    }

    void reportChecksumFailure(String file, LocatedBlock[] lblocks) {
        try {
            this.reportBadBlocks(lblocks);
        }
        catch (IOException ie) {
            LOG.info((Object)("Found corruption while reading " + file + ".  Error repairing corrupt blocks.  Bad blocks remain."), (Throwable)ie);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[clientName=" + this.clientName + ", ugi=" + this.ugi + "]";
    }

    @InterfaceAudience.Private
    public static class DFSDataInputStream
    extends FSDataInputStream {
        public DFSDataInputStream(DFSInputStream in) throws IOException {
            super((InputStream)((Object)in));
        }

        public DatanodeInfo getCurrentDatanode() {
            return ((DFSInputStream)((Object)this.in)).getCurrentDatanode();
        }

        public ExtendedBlock getCurrentBlock() {
            return ((DFSInputStream)((Object)this.in)).getCurrentBlock();
        }

        synchronized List<LocatedBlock> getAllBlocks() throws IOException {
            return ((DFSInputStream)((Object)this.in)).getAllBlocks();
        }

        public long getVisibleLength() throws IOException {
            return ((DFSInputStream)((Object)this.in)).getFileLength();
        }
    }

    @InterfaceAudience.Private
    public static class Renewer
    extends TokenRenewer {
        public boolean handleKind(Text kind) {
            return DelegationTokenIdentifier.HDFS_DELEGATION_KIND.equals((Object)kind);
        }

        public long renew(Token<?> token, Configuration conf) throws IOException {
            Token<?> delToken = token;
            LOG.info((Object)("Renewing " + DelegationTokenIdentifier.stringifyToken(delToken)));
            ClientProtocol nn = DFSUtil.createRPCNamenode(NameNode.getAddress(token.getService().toString()), conf, UserGroupInformation.getCurrentUser());
            try {
                return nn.renewDelegationToken(delToken);
            }
            catch (RemoteException re) {
                throw re.unwrapRemoteException(new Class[]{SecretManager.InvalidToken.class, AccessControlException.class});
            }
        }

        public void cancel(Token<?> token, Configuration conf) throws IOException {
            Token<?> delToken = token;
            LOG.info((Object)("Cancelling " + DelegationTokenIdentifier.stringifyToken(delToken)));
            ClientProtocol nn = DFSUtil.createRPCNamenode(NameNode.getAddress(token.getService().toString()), conf, UserGroupInformation.getCurrentUser());
            try {
                nn.cancelDelegationToken(delToken);
            }
            catch (RemoteException re) {
                throw re.unwrapRemoteException(new Class[]{SecretManager.InvalidToken.class, AccessControlException.class});
            }
        }

        public boolean isManaged(Token<?> token) throws IOException {
            return true;
        }
    }

    static class Conf {
        final int maxBlockAcquireFailures;
        final int confTime;
        final int ioBufferSize;
        final int checksumType;
        final int bytesPerChecksum;
        final int writePacketSize;
        final int socketTimeout;
        final int socketCacheCapacity;
        final int timeWindow;
        final int nCachedConnRetry;
        final int nBlockWriteRetry;
        final int nBlockWriteLocateFollowingRetry;
        final long defaultBlockSize;
        final long prefetchSize;
        final short defaultReplication;
        final String taskId;
        final FsPermission uMask;
        final boolean useLegacyBlockReader;

        Conf(Configuration conf) {
            this.maxBlockAcquireFailures = conf.getInt("dfs.client.max.block.acquire.failures", 3);
            this.confTime = conf.getInt("dfs.datanode.socket.write.timeout", HdfsServerConstants.WRITE_TIMEOUT);
            this.ioBufferSize = conf.getInt("io.file.buffer.size", 4096);
            this.checksumType = this.getChecksumType(conf);
            this.bytesPerChecksum = conf.getInt("dfs.bytes-per-checksum", 512);
            this.socketTimeout = conf.getInt("dfs.client.socket-timeout", HdfsServerConstants.READ_TIMEOUT);
            this.writePacketSize = conf.getInt("dfs.client-write-packet-size", 65536);
            this.defaultBlockSize = conf.getLong("dfs.blocksize", 0x4000000L);
            this.defaultReplication = (short)conf.getInt("dfs.replication", 3);
            this.taskId = conf.get("mapreduce.task.attempt.id", "NONMAPREDUCE");
            this.socketCacheCapacity = conf.getInt("dfs.client.socketcache.capacity", 16);
            this.prefetchSize = conf.getLong("dfs.client.read.prefetch.size", 10L * this.defaultBlockSize);
            this.timeWindow = conf.getInt("dfs.client.retry.window.base", 3000);
            this.nCachedConnRetry = conf.getInt("dfs.client.cached.conn.retry", 3);
            this.nBlockWriteRetry = conf.getInt("dfs.client.block.write.retries", 3);
            this.nBlockWriteLocateFollowingRetry = conf.getInt("dfs.client.block.write.locateFollowingBlock.retries", 5);
            this.uMask = FsPermission.getUMask((Configuration)conf);
            this.useLegacyBlockReader = conf.getBoolean("dfs.client.use.legacy.blockreader", false);
        }

        private int getChecksumType(Configuration conf) {
            String checksum = conf.get("dfs.checksum.type", "CRC32C");
            if ("CRC32".equals(checksum)) {
                return 1;
            }
            if ("CRC32C".equals(checksum)) {
                return 2;
            }
            if ("NULL".equals(checksum)) {
                return 0;
            }
            LOG.warn((Object)("Bad checksum type: " + checksum + ". Using default."));
            return 2;
        }

        private DataChecksum createChecksum() {
            return DataChecksum.newDataChecksum((int)this.checksumType, (int)this.bytesPerChecksum);
        }
    }
}

