/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public class CorruptFileBlocks
implements Writable {
    private static final int PRIME = 16777619;
    private String[] files;
    private String cookie;

    public CorruptFileBlocks() {
        this(new String[0], "");
    }

    public CorruptFileBlocks(String[] files, String cookie) {
        this.files = files;
        this.cookie = cookie;
    }

    public String[] getFiles() {
        return this.files;
    }

    public String getCookie() {
        return this.cookie;
    }

    public void readFields(DataInput in) throws IOException {
        int fileCount = in.readInt();
        this.files = new String[fileCount];
        for (int i = 0; i < fileCount; ++i) {
            this.files[i] = Text.readString((DataInput)in);
        }
        this.cookie = Text.readString((DataInput)in);
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.files.length);
        for (int i = 0; i < this.files.length; ++i) {
            Text.writeString((DataOutput)out, (String)this.files[i]);
        }
        Text.writeString((DataOutput)out, (String)this.cookie);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CorruptFileBlocks)) {
            return false;
        }
        CorruptFileBlocks other = (CorruptFileBlocks)obj;
        return this.cookie.equals(other.cookie) && Arrays.equals(this.files, other.files);
    }

    public int hashCode() {
        int result = this.cookie.hashCode();
        for (String file : this.files) {
            result = 16777619 * result + file.hashCode();
        }
        return result;
    }
}

