/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.balancer;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import org.apache.commons.logging.Log;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.AlreadyBeingCreatedException;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenSecretManager;
import org.apache.hadoop.hdfs.security.token.block.ExportedBlockKeys;
import org.apache.hadoop.hdfs.server.balancer.Balancer;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocol;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.io.retry.RetryProxy;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.Daemon;

@InterfaceAudience.Private
class NameNodeConnector {
    private static final Log LOG = Balancer.LOG;
    private static final Path BALANCER_ID_PATH = new Path("/system/balancer.id");
    final InetSocketAddress namenodeAddress;
    final String blockpoolID;
    final NamenodeProtocol namenode;
    final ClientProtocol client;
    final FileSystem fs;
    final OutputStream out;
    private final boolean isBlockTokenEnabled;
    private boolean shouldRun;
    private long keyUpdaterInterval;
    private BlockTokenSecretManager blockTokenSecretManager;
    private Daemon keyupdaterthread;

    NameNodeConnector(InetSocketAddress namenodeAddress, Configuration conf) throws IOException {
        this.namenodeAddress = namenodeAddress;
        this.namenode = NameNodeConnector.createNamenode(namenodeAddress, conf);
        this.client = DFSUtil.createNamenode(conf);
        this.fs = FileSystem.get((URI)NameNode.getUri(namenodeAddress), (Configuration)conf);
        NamespaceInfo namespaceinfo = this.namenode.versionRequest();
        this.blockpoolID = namespaceinfo.getBlockPoolID();
        ExportedBlockKeys keys = this.namenode.getBlockKeys();
        this.isBlockTokenEnabled = keys.isBlockTokenEnabled();
        if (this.isBlockTokenEnabled) {
            long blockKeyUpdateInterval = keys.getKeyUpdateInterval();
            long blockTokenLifetime = keys.getTokenLifetime();
            LOG.info((Object)("Block token params received from NN: keyUpdateInterval=" + blockKeyUpdateInterval / 60000L + " min(s), tokenLifetime=" + blockTokenLifetime / 60000L + " min(s)"));
            this.blockTokenSecretManager = new BlockTokenSecretManager(false, blockKeyUpdateInterval, blockTokenLifetime);
            this.blockTokenSecretManager.setKeys(keys);
            this.keyUpdaterInterval = blockKeyUpdateInterval / 4L;
            LOG.info((Object)("Balancer will update its block keys every " + this.keyUpdaterInterval / 60000L + " minute(s)"));
            this.keyupdaterthread = new Daemon((Runnable)new BlockKeyUpdater());
            this.shouldRun = true;
            this.keyupdaterthread.start();
        }
        this.out = this.checkAndMarkRunningBalancer();
        if (this.out == null) {
            throw new IOException("Another balancer is running");
        }
    }

    Token<BlockTokenIdentifier> getAccessToken(ExtendedBlock eb) throws IOException {
        if (!this.isBlockTokenEnabled) {
            return BlockTokenSecretManager.DUMMY_TOKEN;
        }
        return this.blockTokenSecretManager.generateToken(null, eb, EnumSet.of(BlockTokenSecretManager.AccessMode.REPLACE, BlockTokenSecretManager.AccessMode.COPY));
    }

    private OutputStream checkAndMarkRunningBalancer() throws IOException {
        try {
            FSDataOutputStream out = this.fs.create(BALANCER_ID_PATH);
            out.writeBytes(InetAddress.getLocalHost().getHostName());
            out.flush();
            return out;
        }
        catch (RemoteException e) {
            if (AlreadyBeingCreatedException.class.getName().equals(e.getClassName())) {
                return null;
            }
            throw e;
        }
    }

    void close() {
        this.shouldRun = false;
        try {
            if (this.keyupdaterthread != null) {
                this.keyupdaterthread.interrupt();
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Exception shutting down access key updater thread", (Throwable)e);
        }
        IOUtils.closeStream((Closeable)this.out);
        if (this.fs != null) {
            try {
                this.fs.delete(BALANCER_ID_PATH, true);
            }
            catch (IOException ioe) {
                LOG.warn((Object)("Failed to delete " + BALANCER_ID_PATH), (Throwable)ioe);
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[namenodeAddress=" + this.namenodeAddress + ", id=" + this.blockpoolID + "]";
    }

    private static NamenodeProtocol createNamenode(InetSocketAddress address, Configuration conf) throws IOException {
        RetryPolicy timeoutPolicy = RetryPolicies.exponentialBackoffRetry((int)5, (long)200L, (TimeUnit)TimeUnit.MILLISECONDS);
        HashMap exceptionToPolicyMap = new HashMap();
        RetryPolicy methodPolicy = RetryPolicies.retryByException((RetryPolicy)timeoutPolicy, exceptionToPolicyMap);
        HashMap<String, RetryPolicy> methodNameToPolicyMap = new HashMap<String, RetryPolicy>();
        methodNameToPolicyMap.put("getBlocks", methodPolicy);
        methodNameToPolicyMap.put("getAccessKeys", methodPolicy);
        return (NamenodeProtocol)RetryProxy.create(NamenodeProtocol.class, (Object)RPC.getProxy(NamenodeProtocol.class, (long)6L, (InetSocketAddress)address, (UserGroupInformation)UserGroupInformation.getCurrentUser(), (Configuration)conf, (SocketFactory)NetUtils.getDefaultSocketFactory((Configuration)conf)), methodNameToPolicyMap);
    }

    class BlockKeyUpdater
    implements Runnable {
        BlockKeyUpdater() {
        }

        @Override
        public void run() {
            while (NameNodeConnector.this.shouldRun) {
                try {
                    NameNodeConnector.this.blockTokenSecretManager.setKeys(NameNodeConnector.this.namenode.getBlockKeys());
                }
                catch (Exception e) {
                    LOG.error((Object)"Failed to set keys", (Throwable)e);
                }
                try {
                    Thread.sleep(NameNodeConnector.this.keyUpdaterInterval);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

