/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.ipc.Server;

@InterfaceAudience.Private
public class CorruptReplicasMap {
    private SortedMap<Block, Collection<DatanodeDescriptor>> corruptReplicasMap = new TreeMap<Block, Collection<DatanodeDescriptor>>();

    public void addToCorruptReplicasMap(Block blk, DatanodeDescriptor dn) {
        Collection<DatanodeDescriptor> nodes = this.getNodes(blk);
        if (nodes == null) {
            nodes = new TreeSet<DatanodeDescriptor>();
            this.corruptReplicasMap.put(blk, nodes);
        }
        if (!nodes.contains(dn)) {
            nodes.add(dn);
            NameNode.stateChangeLog.info((Object)("BLOCK NameSystem.addToCorruptReplicasMap: " + blk.getBlockName() + " added as corrupt on " + dn.getName() + " by " + Server.getRemoteIp()));
        } else {
            NameNode.stateChangeLog.info((Object)("BLOCK NameSystem.addToCorruptReplicasMap: duplicate requested for " + blk.getBlockName() + " to add as corrupt " + "on " + dn.getName() + " by " + Server.getRemoteIp()));
        }
    }

    void removeFromCorruptReplicasMap(Block blk) {
        if (this.corruptReplicasMap != null) {
            this.corruptReplicasMap.remove(blk);
        }
    }

    boolean removeFromCorruptReplicasMap(Block blk, DatanodeDescriptor datanode) {
        Collection datanodes = (Collection)this.corruptReplicasMap.get(blk);
        if (datanodes == null) {
            return false;
        }
        if (datanodes.remove(datanode)) {
            if (datanodes.isEmpty()) {
                this.corruptReplicasMap.remove(blk);
            }
            return true;
        }
        return false;
    }

    Collection<DatanodeDescriptor> getNodes(Block blk) {
        return (Collection)this.corruptReplicasMap.get(blk);
    }

    boolean isReplicaCorrupt(Block blk, DatanodeDescriptor node) {
        Collection<DatanodeDescriptor> nodes = this.getNodes(blk);
        return nodes != null && nodes.contains(node);
    }

    public int numCorruptReplicas(Block blk) {
        Collection<DatanodeDescriptor> nodes = this.getNodes(blk);
        return nodes == null ? 0 : nodes.size();
    }

    public int size() {
        return this.corruptReplicasMap.size();
    }

    long[] getCorruptReplicaBlockIds(int numExpectedBlocks, Long startingBlockId) {
        if (numExpectedBlocks < 0 || numExpectedBlocks > 100) {
            return null;
        }
        Iterator<Block> blockIt = this.corruptReplicasMap.keySet().iterator();
        if (startingBlockId != null) {
            boolean isBlockFound = false;
            while (blockIt.hasNext()) {
                Block b = blockIt.next();
                if (b.getBlockId() != startingBlockId.longValue()) continue;
                isBlockFound = true;
                break;
            }
            if (!isBlockFound) {
                return null;
            }
        }
        ArrayList<Long> corruptReplicaBlockIds = new ArrayList<Long>();
        for (int i = 0; i < numExpectedBlocks && blockIt.hasNext(); ++i) {
            corruptReplicaBlockIds.add(blockIt.next().getBlockId());
        }
        long[] ret = new long[corruptReplicaBlockIds.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (Long)corruptReplicaBlockIds.get(i);
        }
        return ret;
    }
}

