/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.File;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.datanode.FSDataset;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInfo;
import org.apache.hadoop.hdfs.server.protocol.ReplicaRecoveryInfo;

class ReplicaUnderRecovery
extends ReplicaInfo {
    private ReplicaInfo original;
    private long recoveryId;

    ReplicaUnderRecovery(ReplicaInfo replica, long recoveryId) {
        super(replica.getBlockId(), replica.getNumBytes(), replica.getGenerationStamp(), replica.getVolume(), replica.getDir());
        if (replica.getState() != HdfsServerConstants.ReplicaState.FINALIZED && replica.getState() != HdfsServerConstants.ReplicaState.RBW && replica.getState() != HdfsServerConstants.ReplicaState.RWR) {
            throw new IllegalArgumentException("Cannot recover replica: " + replica);
        }
        this.original = replica;
        this.recoveryId = recoveryId;
    }

    ReplicaUnderRecovery(ReplicaUnderRecovery from) {
        super(from);
        this.original = from.getOriginalReplica();
        this.recoveryId = from.getRecoveryID();
    }

    long getRecoveryID() {
        return this.recoveryId;
    }

    void setRecoveryID(long recoveryId) {
        if (recoveryId <= this.recoveryId) {
            throw new IllegalArgumentException("The new rcovery id: " + recoveryId + " must be greater than the current one: " + this.recoveryId);
        }
        this.recoveryId = recoveryId;
    }

    ReplicaInfo getOriginalReplica() {
        return this.original;
    }

    HdfsServerConstants.ReplicaState getOrignalReplicaState() {
        return this.original.getState();
    }

    @Override
    boolean isUnlinked() {
        return this.original.isUnlinked();
    }

    @Override
    void setUnlinked() {
        this.original.setUnlinked();
    }

    @Override
    public HdfsServerConstants.ReplicaState getState() {
        return HdfsServerConstants.ReplicaState.RUR;
    }

    @Override
    public long getVisibleLength() {
        return this.original.getVisibleLength();
    }

    @Override
    public long getBytesOnDisk() {
        return this.original.getBytesOnDisk();
    }

    @Override
    public void setBlockId(long blockId) {
        super.setBlockId(blockId);
        this.original.setBlockId(blockId);
    }

    @Override
    public void setGenerationStamp(long gs) {
        super.setGenerationStamp(gs);
        this.original.setGenerationStamp(gs);
    }

    @Override
    public void setNumBytes(long numBytes) {
        super.setNumBytes(numBytes);
        this.original.setNumBytes(numBytes);
    }

    @Override
    void setDir(File dir) {
        super.setDir(dir);
        this.original.setDir(dir);
    }

    @Override
    void setVolume(FSDataset.FSVolume vol) {
        super.setVolume(vol);
        this.original.setVolume(vol);
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String toString() {
        return super.toString() + "\n  recoveryId=" + this.recoveryId + "\n  original=" + this.original;
    }

    ReplicaRecoveryInfo createInfo() {
        return new ReplicaRecoveryInfo(this.original.getBlockId(), this.original.getBytesOnDisk(), this.original.getGenerationStamp(), this.getOrignalReplicaState());
    }
}

