/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.offlineEditsViewer;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.tools.offlineEditsViewer.Tokenizer;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class XmlTokenizer
implements Tokenizer {
    FileInputStream is = null;
    XMLStreamReader in;

    public XmlTokenizer(String filename) throws IOException {
        XMLInputFactory f = XMLInputFactory.newInstance();
        try {
            this.is = new FileInputStream(filename);
            this.in = f.createXMLStreamReader(this.is);
        }
        catch (XMLStreamException e) {
            throw new IOException("Cannot create XML stream", e);
        }
        catch (FileNotFoundException e) {
            throw new IOException("Cannot open input file " + filename, e);
        }
    }

    private String getNextElementsValue(String wantedName) throws IOException {
        boolean gotSTART_ELEMENT = false;
        try {
            int eventType = this.in.getEventType();
            while (true) {
                switch (eventType) {
                    case 4: {
                        if (!gotSTART_ELEMENT) break;
                        return this.in.getText().trim();
                    }
                    case 8: {
                        throw new IOException("End of XML while looking for element [" + wantedName + "]");
                    }
                    case 1: {
                        if (gotSTART_ELEMENT) {
                            throw new IOException("START_ELEMENT [" + this.in.getName() + " event when expecting CHARACTERS event for [" + wantedName + "]");
                        }
                        if (this.in.getName().toString().equals(wantedName)) {
                            gotSTART_ELEMENT = true;
                            break;
                        }
                        throw new IOException("unexpected element name [" + this.in.getName() + "], was expecting [" + wantedName + "]");
                    }
                    case 2: 
                    case 5: 
                    case 6: 
                    case 7: {
                        break;
                    }
                    default: {
                        throw new IOException("Unsupported event type [" + eventType + "] (see XMLStreamConstants)");
                    }
                }
                if (this.in.hasNext()) {
                    eventType = this.in.next();
                    continue;
                }
                break;
            }
        }
        catch (XMLStreamException e) {
            throw new IOException("Error reading XML stream", e);
        }
        throw new IOException("Error reading XML stream, should never reach this line, most likely XML does not have elements we are loking for");
    }

    @Override
    public Tokenizer.Token read(Tokenizer.Token t) throws IOException {
        t.fromString(this.getNextElementsValue(t.getEditsElement().toString()));
        return t;
    }
}

