/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.hdfs.protocol.AlreadyBeingCreatedException;
import org.apache.hadoop.hdfs.protocol.ClientDatanodeProtocol;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.io.retry.RetryProxy;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.net.NodeBase;
import org.apache.hadoop.security.UserGroupInformation;

@InterfaceAudience.Private
public class DFSUtil {
    private static final ThreadLocal<Random> RANDOM = new ThreadLocal<Random>(){

        @Override
        protected Random initialValue() {
            return new Random();
        }
    };
    private static final ThreadLocal<SecureRandom> SECURE_RANDOM = new ThreadLocal<SecureRandom>(){

        @Override
        protected SecureRandom initialValue() {
            return new SecureRandom();
        }
    };
    public static final Comparator<DatanodeInfo> DECOM_COMPARATOR = new Comparator<DatanodeInfo>(){

        @Override
        public int compare(DatanodeInfo a, DatanodeInfo b) {
            return a.isDecommissioned() == b.isDecommissioned() ? 0 : (a.isDecommissioned() ? 1 : -1);
        }
    };

    public static Random getRandom() {
        return RANDOM.get();
    }

    public static SecureRandom getSecureRandom() {
        return SECURE_RANDOM.get();
    }

    public static boolean isValidName(String src) {
        if (!src.startsWith("/")) {
            return false;
        }
        StringTokenizer tokens = new StringTokenizer(src, "/");
        while (tokens.hasMoreTokens()) {
            String element = tokens.nextToken();
            if (!element.equals("..") && !element.equals(".") && element.indexOf(":") < 0 && element.indexOf("/") < 0) continue;
            return false;
        }
        return true;
    }

    public static String bytes2String(byte[] bytes) {
        try {
            return new String(bytes, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            assert (false) : "UTF8 encoding is not supported ";
            return null;
        }
    }

    public static byte[] string2Bytes(String str) {
        try {
            return str.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            assert (false) : "UTF8 encoding is not supported ";
            return null;
        }
    }

    public static String byteArray2String(byte[][] pathComponents) {
        if (pathComponents.length == 0) {
            return "";
        }
        if (pathComponents.length == 1 && pathComponents[0].length == 0) {
            return "/";
        }
        try {
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < pathComponents.length; ++i) {
                result.append(new String(pathComponents[i], "UTF-8"));
                if (i >= pathComponents.length - 1) continue;
                result.append('/');
            }
            return result.toString();
        }
        catch (UnsupportedEncodingException ex) {
            assert (false) : "UTF8 encoding is not supported ";
            return null;
        }
    }

    public static byte[][] bytes2byteArray(byte[] bytes, byte separator) {
        return DFSUtil.bytes2byteArray(bytes, bytes.length, separator);
    }

    public static byte[][] bytes2byteArray(byte[] bytes, int len, byte separator) {
        assert (len <= bytes.length);
        int splits = 0;
        if (len == 0) {
            return new byte[][]{null};
        }
        for (int i = 0; i < len; ++i) {
            if (bytes[i] != separator) continue;
            ++splits;
        }
        int last = len - 1;
        while (last > -1 && bytes[last--] == separator) {
            --splits;
        }
        if (splits == 0 && bytes[0] == separator) {
            return new byte[][]{null};
        }
        byte[][] result = new byte[++splits][];
        int startIndex = 0;
        int nextIndex = 0;
        for (int index = 0; index < splits; ++index) {
            while (nextIndex < len && bytes[nextIndex] != separator) {
                ++nextIndex;
            }
            result[index] = new byte[nextIndex - startIndex];
            System.arraycopy(bytes, startIndex, result[index], 0, nextIndex - startIndex);
            nextIndex = startIndex = nextIndex + 1;
        }
        return result;
    }

    public static BlockLocation[] locatedBlocks2Locations(LocatedBlocks blocks) {
        if (blocks == null) {
            return new BlockLocation[0];
        }
        int nrBlocks = blocks.locatedBlockCount();
        BlockLocation[] blkLocations = new BlockLocation[nrBlocks];
        if (nrBlocks == 0) {
            return blkLocations;
        }
        int idx = 0;
        for (LocatedBlock blk : blocks.getLocatedBlocks()) {
            assert (idx < nrBlocks) : "Incorrect index";
            DatanodeInfo[] locations = blk.getLocations();
            String[] hosts = new String[locations.length];
            String[] names = new String[locations.length];
            String[] racks = new String[locations.length];
            for (int hCnt = 0; hCnt < locations.length; ++hCnt) {
                hosts[hCnt] = locations[hCnt].getHostName();
                names[hCnt] = locations[hCnt].getName();
                NodeBase node = new NodeBase(names[hCnt], locations[hCnt].getNetworkLocation());
                racks[hCnt] = node.toString();
            }
            blkLocations[idx] = new BlockLocation(names, hosts, racks, blk.getStartOffset(), blk.getBlockSize(), blk.isCorrupt());
            ++idx;
        }
        return blkLocations;
    }

    public static Collection<String> getNameServiceIds(Configuration conf) {
        return conf.getStringCollection("dfs.federation.nameservices");
    }

    private static String getConfValue(String defaultValue, String keySuffix, Configuration conf, String ... keys) {
        String value = null;
        for (String key : keys) {
            if (keySuffix != null) {
                key = key + "." + keySuffix;
            }
            if ((value = conf.get(key)) != null) break;
        }
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    private static List<InetSocketAddress> getAddresses(Configuration conf, String defaultAddress, String ... keys) {
        Collection<String> nameserviceIds = DFSUtil.getNameServiceIds(conf);
        ArrayList<InetSocketAddress> isas = new ArrayList<InetSocketAddress>();
        if (nameserviceIds == null || nameserviceIds.isEmpty()) {
            String address = DFSUtil.getConfValue(defaultAddress, null, conf, keys);
            if (address == null) {
                return null;
            }
            isas.add(NetUtils.createSocketAddr((String)address));
        } else {
            for (String nameserviceId : nameserviceIds) {
                String address = DFSUtil.getConfValue(null, nameserviceId, conf, keys);
                if (address == null) {
                    return null;
                }
                isas.add(NetUtils.createSocketAddr((String)address));
            }
        }
        return isas;
    }

    public static List<InetSocketAddress> getBackupNodeAddresses(Configuration conf) throws IOException {
        List<InetSocketAddress> addressList = DFSUtil.getAddresses(conf, null, "dfs.namenode.backup.address");
        if (addressList == null) {
            throw new IOException("Incorrect configuration: backup node address dfs.namenode.backup.address is not configured.");
        }
        return addressList;
    }

    public static List<InetSocketAddress> getSecondaryNameNodeAddresses(Configuration conf) throws IOException {
        List<InetSocketAddress> addressList = DFSUtil.getAddresses(conf, null, "dfs.namenode.secondary.http-address");
        if (addressList == null) {
            throw new IOException("Incorrect configuration: secondary namenode address dfs.namenode.secondary.http-address is not configured.");
        }
        return addressList;
    }

    public static List<InetSocketAddress> getNNServiceRpcAddresses(Configuration conf) throws IOException {
        String defaultAddress;
        try {
            defaultAddress = NameNode.getHostPortString(NameNode.getAddress(conf));
        }
        catch (IllegalArgumentException e) {
            defaultAddress = null;
        }
        List<InetSocketAddress> addressList = DFSUtil.getAddresses(conf, defaultAddress, "dfs.namenode.servicerpc-address", "dfs.namenode.rpc-address");
        if (addressList == null) {
            throw new IOException("Incorrect configuration: namenode address dfs.namenode.servicerpc-address or dfs.namenode.rpc-address is not configured.");
        }
        return addressList;
    }

    public static String getNameServiceIdFromAddress(Configuration conf, InetSocketAddress address, String ... keys) {
        Collection<String> nameserviceIds = DFSUtil.getNameServiceIds(conf);
        if (nameserviceIds == null || nameserviceIds.isEmpty()) {
            return null;
        }
        for (String nameserviceId : nameserviceIds) {
            for (String key : keys) {
                String candidateAddress = conf.get(DFSUtil.getNameServiceIdKey(key, nameserviceId));
                if (candidateAddress == null || !address.equals(NetUtils.createSocketAddr((String)candidateAddress))) continue;
                return nameserviceId;
            }
        }
        return null;
    }

    public static String getInfoServer(InetSocketAddress namenode, Configuration conf, boolean httpsAddress) {
        String nameServiceId;
        String httpAddressDefault;
        String httpAddress = null;
        String httpAddressKey = UserGroupInformation.isSecurityEnabled() && httpsAddress ? "dfs.namenode.https-address" : "dfs.namenode.http-address";
        String string = httpAddressDefault = UserGroupInformation.isSecurityEnabled() && httpsAddress ? "0.0.0.0:50470" : "0.0.0.0:50070";
        if (namenode != null && (nameServiceId = DFSUtil.getNameServiceIdFromAddress(conf, namenode, "dfs.namenode.servicerpc-address", "dfs.namenode.rpc-address")) != null) {
            httpAddress = conf.get(DFSUtil.getNameServiceIdKey(httpAddressKey, nameServiceId));
        }
        if (httpAddress == null) {
            httpAddress = conf.get(httpAddressKey, httpAddressDefault);
        }
        return httpAddress;
    }

    public static boolean isDefaultNamenodeAddress(Configuration conf, InetSocketAddress address, String ... keys) {
        for (String key : keys) {
            String candidateAddress = conf.get(key);
            if (candidateAddress == null || !address.equals(NetUtils.createSocketAddr((String)candidateAddress))) continue;
            return true;
        }
        return false;
    }

    public static String getNameServiceIdKey(String key, String nameserviceId) {
        return key + "." + nameserviceId;
    }

    public static void setGenericConf(Configuration conf, String nameserviceId, String ... keys) {
        for (String key : keys) {
            String value = conf.get(DFSUtil.getNameServiceIdKey(key, nameserviceId));
            if (value == null) continue;
            conf.set(key, value);
        }
    }

    public static float getPercentUsed(long used, long capacity) {
        return capacity <= 0L ? 100.0f : (float)used * 100.0f / (float)capacity;
    }

    public static float getPercentRemaining(long remaining, long capacity) {
        return capacity <= 0L ? 0.0f : (float)remaining * 100.0f / (float)capacity;
    }

    public static int roundBytesToGB(long bytes) {
        return Math.round((float)bytes / 1024.0f / 1024.0f / 1024.0f);
    }

    public static ClientProtocol createNamenode(Configuration conf) throws IOException {
        return DFSUtil.createNamenode(NameNode.getAddress(conf), conf);
    }

    public static ClientProtocol createNamenode(InetSocketAddress nameNodeAddr, Configuration conf) throws IOException {
        return DFSUtil.createNamenode(DFSUtil.createRPCNamenode(nameNodeAddr, conf, UserGroupInformation.getCurrentUser()));
    }

    static ClientProtocol createRPCNamenode(InetSocketAddress nameNodeAddr, Configuration conf, UserGroupInformation ugi) throws IOException {
        return (ClientProtocol)RPC.getProxy(ClientProtocol.class, (long)69L, (InetSocketAddress)nameNodeAddr, (UserGroupInformation)ugi, (Configuration)conf, (SocketFactory)NetUtils.getSocketFactory((Configuration)conf, ClientProtocol.class));
    }

    static ClientProtocol createNamenode(ClientProtocol rpcNamenode) throws IOException {
        RetryPolicy createPolicy = RetryPolicies.retryUpToMaximumCountWithFixedSleep((int)5, (long)60000L, (TimeUnit)TimeUnit.MILLISECONDS);
        HashMap<Class<AlreadyBeingCreatedException>, RetryPolicy> remoteExceptionToPolicyMap = new HashMap<Class<AlreadyBeingCreatedException>, RetryPolicy>();
        remoteExceptionToPolicyMap.put(AlreadyBeingCreatedException.class, createPolicy);
        HashMap<Class<RemoteException>, RetryPolicy> exceptionToPolicyMap = new HashMap<Class<RemoteException>, RetryPolicy>();
        exceptionToPolicyMap.put(RemoteException.class, RetryPolicies.retryByRemoteException((RetryPolicy)RetryPolicies.TRY_ONCE_THEN_FAIL, remoteExceptionToPolicyMap));
        RetryPolicy methodPolicy = RetryPolicies.retryByException((RetryPolicy)RetryPolicies.TRY_ONCE_THEN_FAIL, exceptionToPolicyMap);
        HashMap<String, RetryPolicy> methodNameToPolicyMap = new HashMap<String, RetryPolicy>();
        methodNameToPolicyMap.put("create", methodPolicy);
        return (ClientProtocol)RetryProxy.create(ClientProtocol.class, (Object)rpcNamenode, methodNameToPolicyMap);
    }

    static ClientDatanodeProtocol createClientDatanodeProtocolProxy(DatanodeID datanodeid, Configuration conf, int socketTimeout) throws IOException {
        InetSocketAddress addr = NetUtils.createSocketAddr((String)(datanodeid.getHost() + ":" + datanodeid.getIpcPort()));
        if (ClientDatanodeProtocol.LOG.isDebugEnabled()) {
            ClientDatanodeProtocol.LOG.info((Object)("ClientDatanodeProtocol addr=" + addr));
        }
        return (ClientDatanodeProtocol)RPC.getProxy(ClientDatanodeProtocol.class, (long)9L, (InetSocketAddress)addr, (UserGroupInformation)UserGroupInformation.getCurrentUser(), (Configuration)conf, (SocketFactory)NetUtils.getDefaultSocketFactory((Configuration)conf), (int)socketTimeout);
    }

    public static ClientDatanodeProtocol createClientDatanodeProtocolProxy(DatanodeID datanodeid, Configuration conf, int socketTimeout, LocatedBlock locatedBlock) throws IOException {
        InetSocketAddress addr = NetUtils.createSocketAddr((String)(datanodeid.getHost() + ":" + datanodeid.getIpcPort()));
        if (ClientDatanodeProtocol.LOG.isDebugEnabled()) {
            ClientDatanodeProtocol.LOG.debug((Object)("ClientDatanodeProtocol addr=" + addr));
        }
        Configuration confWithNoIpcIdle = new Configuration(conf);
        confWithNoIpcIdle.setInt("ipc.client.connection.maxidletime", 0);
        UserGroupInformation ticket = UserGroupInformation.createRemoteUser((String)locatedBlock.getBlock().getLocalBlock().toString());
        ticket.addToken(locatedBlock.getBlockToken());
        return (ClientDatanodeProtocol)RPC.getProxy(ClientDatanodeProtocol.class, (long)9L, (InetSocketAddress)addr, (UserGroupInformation)ticket, (Configuration)confWithNoIpcIdle, (SocketFactory)NetUtils.getDefaultSocketFactory((Configuration)conf), (int)socketTimeout);
    }

    public static String getNamenodeNameServiceId(Configuration conf) {
        return DFSUtil.getNameServiceId(conf, "dfs.namenode.rpc-address");
    }

    public static String getBackupNameServiceId(Configuration conf) {
        return DFSUtil.getNameServiceId(conf, "dfs.namenode.backup.address");
    }

    public static String getSecondaryNameServiceId(Configuration conf) {
        return DFSUtil.getNameServiceId(conf, "dfs.namenode.secondary.http-address");
    }

    private static String getNameServiceId(Configuration conf, String addressKey) {
        String nameserviceId = conf.get("dfs.federation.nameservice.id");
        if (nameserviceId != null) {
            return nameserviceId;
        }
        Collection<String> ids = DFSUtil.getNameServiceIds(conf);
        if (ids == null || ids.size() == 0) {
            return null;
        }
        int found = 0;
        for (String id : ids) {
            String addr = conf.get(DFSUtil.getNameServiceIdKey(addressKey, id));
            InetSocketAddress s = NetUtils.createSocketAddr((String)addr);
            if (!NetUtils.isLocalAddress((InetAddress)s.getAddress())) continue;
            nameserviceId = id;
            ++found;
        }
        if (found > 1) {
            throw new HadoopIllegalArgumentException("Configuration has multiple RPC addresses that matches the local node's address. Please configure the system with the parameter dfs.federation.nameservice.id");
        }
        if (found == 0) {
            throw new HadoopIllegalArgumentException("Configuration address " + addressKey + " is missing in configuration with name service Id");
        }
        return nameserviceId;
    }

    public static URI createUri(String scheme, InetSocketAddress address) {
        try {
            return new URI(scheme, null, address.getHostName(), address.getPort(), null, null, null);
        }
        catch (URISyntaxException ue) {
            throw new IllegalArgumentException(ue);
        }
    }

    @InterfaceAudience.Private
    public static class ErrorSimulator {
        private static boolean[] simulation = null;

        public static void initializeErrorSimulationEvent(int numberOfEvents) {
            simulation = new boolean[numberOfEvents];
            for (int i = 0; i < numberOfEvents; ++i) {
                ErrorSimulator.simulation[i] = false;
            }
        }

        public static boolean getErrorSimulation(int index) {
            if (simulation == null) {
                return false;
            }
            assert (index < simulation.length);
            return simulation[index];
        }

        public static void setErrorSimulation(int index) {
            assert (index < simulation.length);
            ErrorSimulator.simulation[index] = true;
        }

        public static void clearErrorSimulation(int index) {
            assert (index < simulation.length);
            ErrorSimulator.simulation[index] = false;
        }
    }
}

