/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.DeprecatedUTF8;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class ExtendedBlock
implements Writable {
    private String poolId;
    private Block block;

    public ExtendedBlock() {
        this(null, 0L, 0L, 0L);
    }

    public ExtendedBlock(ExtendedBlock b) {
        this(b.poolId, new Block(b.block));
    }

    public ExtendedBlock(String poolId, long blockId) {
        this(poolId, blockId, 0L, 0L);
    }

    public ExtendedBlock(String poolId, Block b) {
        this.poolId = poolId;
        this.block = b;
    }

    public ExtendedBlock(String poolId, long blkid, long len, long genstamp) {
        this.poolId = poolId;
        this.block = new Block(blkid, len, genstamp);
    }

    public void write(DataOutput out) throws IOException {
        DeprecatedUTF8.writeString(out, this.poolId);
        this.block.writeHelper(out);
    }

    public void readFields(DataInput in) throws IOException {
        this.poolId = DeprecatedUTF8.readString(in);
        this.block.readHelper(in);
    }

    public void writeId(DataOutput out) throws IOException {
        DeprecatedUTF8.writeString(out, this.poolId);
        this.block.writeId(out);
    }

    public void readId(DataInput in) throws IOException {
        this.poolId = DeprecatedUTF8.readString(in);
        this.block.readId(in);
    }

    public String getBlockPoolId() {
        return this.poolId;
    }

    public String getBlockName() {
        return this.block.getBlockName();
    }

    public long getNumBytes() {
        return this.block.getNumBytes();
    }

    public long getBlockId() {
        return this.block.getBlockId();
    }

    public long getGenerationStamp() {
        return this.block.getGenerationStamp();
    }

    public void setBlockId(long bid) {
        this.block.setBlockId(bid);
    }

    public void setGenerationStamp(long genStamp) {
        this.block.setGenerationStamp(genStamp);
    }

    public void setNumBytes(long len) {
        this.block.setNumBytes(len);
    }

    public void set(String poolId, Block blk) {
        this.poolId = poolId;
        this.block = blk;
    }

    public static Block getLocalBlock(ExtendedBlock b) {
        return b == null ? null : b.getLocalBlock();
    }

    public Block getLocalBlock() {
        return this.block;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExtendedBlock)) {
            return false;
        }
        ExtendedBlock b = (ExtendedBlock)o;
        return b.block.equals(this.block) && b.poolId.equals(this.poolId);
    }

    public int hashCode() {
        return this.block.hashCode();
    }

    public String toString() {
        return this.poolId + ":" + this.block;
    }

    static {
        WritableFactories.setFactory(ExtendedBlock.class, (WritableFactory)new WritableFactory(){

            public Writable newInstance() {
                return new ExtendedBlock();
            }
        });
    }
}

