/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol.datatransfer;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.datatransfer.BlockConstructionStage;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.DataChecksum;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public interface DataTransferProtocol {
    public static final Log LOG = LogFactory.getLog(DataTransferProtocol.class);
    public static final int DATA_TRANSFER_VERSION = 28;

    public void readBlock(ExtendedBlock var1, Token<BlockTokenIdentifier> var2, String var3, long var4, long var6) throws IOException;

    public void writeBlock(ExtendedBlock var1, Token<BlockTokenIdentifier> var2, String var3, DatanodeInfo[] var4, DatanodeInfo var5, BlockConstructionStage var6, int var7, long var8, long var10, long var12, DataChecksum var14) throws IOException;

    public void transferBlock(ExtendedBlock var1, Token<BlockTokenIdentifier> var2, String var3, DatanodeInfo[] var4) throws IOException;

    public void replaceBlock(ExtendedBlock var1, Token<BlockTokenIdentifier> var2, String var3, DatanodeInfo var4) throws IOException;

    public void copyBlock(ExtendedBlock var1, Token<BlockTokenIdentifier> var2) throws IOException;

    public void blockChecksum(ExtendedBlock var1, Token<BlockTokenIdentifier> var2) throws IOException;
}

