/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol.datatransfer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.protocol.HdfsProtoUtil;
import org.apache.hadoop.hdfs.protocol.proto.DataTransferProtos;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class PipelineAck {
    DataTransferProtos.PipelineAckProto proto;
    public static final long UNKOWN_SEQNO = -2L;

    public PipelineAck() {
    }

    public PipelineAck(long seqno, DataTransferProtos.Status[] replies) {
        this.proto = DataTransferProtos.PipelineAckProto.newBuilder().setSeqno(seqno).addAllStatus(Arrays.asList(replies)).build();
    }

    public long getSeqno() {
        return this.proto.getSeqno();
    }

    public short getNumOfReplies() {
        return (short)this.proto.getStatusCount();
    }

    public DataTransferProtos.Status getReply(int i) {
        return this.proto.getStatus(i);
    }

    public boolean isSuccess() {
        for (DataTransferProtos.Status reply : this.proto.getStatusList()) {
            if (reply == DataTransferProtos.Status.SUCCESS) continue;
            return false;
        }
        return true;
    }

    public void readFields(InputStream in) throws IOException {
        this.proto = DataTransferProtos.PipelineAckProto.parseFrom(HdfsProtoUtil.vintPrefixed(in));
    }

    public void write(OutputStream out) throws IOException {
        this.proto.writeDelimitedTo(out);
    }

    public String toString() {
        return this.proto.toString();
    }
}

