/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.datatransfer.PacketHeader;
import org.apache.hadoop.hdfs.server.datanode.BlockMetadataHeader;
import org.apache.hadoop.hdfs.server.datanode.ChunkChecksum;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.FSDatasetInterface;
import org.apache.hadoop.hdfs.server.datanode.Replica;
import org.apache.hadoop.hdfs.server.datanode.ReplicaBeingWritten;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInPipeline;
import org.apache.hadoop.hdfs.server.datanode.ReplicaNotFoundException;
import org.apache.hadoop.hdfs.util.DataTransferThrottler;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.ReadaheadPool;
import org.apache.hadoop.io.nativeio.NativeIO;
import org.apache.hadoop.net.SocketOutputStream;
import org.apache.hadoop.util.DataChecksum;

class BlockSender
implements Closeable {
    static final Log LOG = DataNode.LOG;
    static final Log ClientTraceLog = DataNode.ClientTraceLog;
    private static final boolean is32Bit = System.getProperty("sun.arch.data.model").equals("32");
    private static final int MIN_BUFFER_WITH_TRANSFERTO = 65536;
    private static final int TRANSFERTO_BUFFER_SIZE = Math.max(HdfsConstants.IO_FILE_BUFFER_SIZE, 65536);
    private final ExtendedBlock block;
    private final Replica replica;
    private final long replicaVisibleLength;
    private InputStream blockIn;
    private long blockInPosition = -1L;
    private DataInputStream checksumIn;
    private final DataChecksum checksum;
    private long initialOffset;
    private long offset;
    private final long endOffset;
    private final int chunkSize;
    private final int checksumSize;
    private final boolean corruptChecksumOk;
    private long seqno;
    private final boolean transferToAllowed;
    private boolean sentEntireByteRange;
    private final boolean verifyChecksum;
    private final String clientTraceFmt;
    private volatile ChunkChecksum lastChunkChecksum = null;
    private FileDescriptor blockInFd;
    private final long readaheadLength;
    private boolean shouldDropCacheBehindRead;
    private ReadaheadPool.ReadaheadRequest curReadahead;
    private long lastCacheDropOffset;
    private static final long CACHE_DROP_INTERVAL_BYTES = 0x100000L;
    private static final long LONG_READ_THRESHOLD_BYTES = 262144L;
    private static ReadaheadPool readaheadPool = ReadaheadPool.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BlockSender(ExtendedBlock block, long startOffset, long length, boolean corruptChecksumOk, boolean verifyChecksum, DataNode datanode, String clientTraceFmt) throws IOException {
        try {
            long checksumSkip;
            long end;
            DataChecksum csum;
            this.block = block;
            this.corruptChecksumOk = corruptChecksumOk;
            this.verifyChecksum = verifyChecksum;
            this.clientTraceFmt = clientTraceFmt;
            this.readaheadLength = datanode.getDnConf().readaheadLength;
            this.shouldDropCacheBehindRead = datanode.getDnConf().dropCacheBehindReads;
            FSDatasetInterface fSDatasetInterface = datanode.data;
            synchronized (fSDatasetInterface) {
                this.replica = BlockSender.getReplica(block, datanode);
                this.replicaVisibleLength = this.replica.getVisibleLength();
            }
            ChunkChecksum chunkChecksum = null;
            if (this.replica instanceof ReplicaBeingWritten) {
                long minEndOffset = startOffset + length;
                BlockSender.waitForMinLength((ReplicaBeingWritten)this.replica, minEndOffset);
                ReplicaInPipeline rip = (ReplicaInPipeline)this.replica;
                chunkChecksum = rip.getLastChecksumAndDataLen();
            }
            if (this.replica.getGenerationStamp() < block.getGenerationStamp()) {
                throw new IOException("Replica gen stamp < block genstamp, block=" + block + ", replica=" + this.replica);
            }
            if (this.replicaVisibleLength < 0L) {
                throw new IOException("Replica is not readable, block=" + block + ", replica=" + this.replica);
            }
            if (DataNode.LOG.isDebugEnabled()) {
                DataNode.LOG.debug((Object)("block=" + block + ", replica=" + this.replica));
            }
            boolean bl = this.transferToAllowed = datanode.getDnConf().transferToAllowed && (!is32Bit || length <= Integer.MAX_VALUE);
            if (!corruptChecksumOk || datanode.data.metaFileExists(block)) {
                this.checksumIn = new DataInputStream(new BufferedInputStream(datanode.data.getMetaDataInputStream(block), HdfsConstants.IO_FILE_BUFFER_SIZE));
                BlockMetadataHeader header = BlockMetadataHeader.readHeader(this.checksumIn);
                short version = header.getVersion();
                if (version != 1) {
                    LOG.warn((Object)("Wrong version (" + version + ") for metadata file for " + block + " ignoring ..."));
                }
                csum = header.getChecksum();
            } else {
                LOG.warn((Object)("Could not find metadata file for " + block));
                csum = DataChecksum.newDataChecksum((int)0, (int)16384);
            }
            int size = csum.getBytesPerChecksum();
            if (size > 0xA00000 && (long)size > this.replicaVisibleLength) {
                csum = DataChecksum.newDataChecksum((int)csum.getChecksumType(), (int)Math.max((int)this.replicaVisibleLength, 0xA00000));
                size = csum.getBytesPerChecksum();
            }
            this.chunkSize = size;
            this.checksum = csum;
            this.checksumSize = this.checksum.getChecksumSize();
            length = length < 0L ? this.replicaVisibleLength : length;
            long l = end = chunkChecksum != null ? chunkChecksum.getDataLength() : this.replica.getBytesOnDisk();
            if (startOffset < 0L || startOffset > end || length + startOffset > end) {
                String msg = " Offset " + startOffset + " and length " + length + " don't match block " + block + " ( blockLen " + end + " )";
                LOG.warn((Object)(datanode.getDNRegistrationForBP(block.getBlockPoolId()) + ":sendBlock() : " + msg));
                throw new IOException(msg);
            }
            this.offset = startOffset - startOffset % (long)this.chunkSize;
            if (length >= 0L) {
                long tmpLen = startOffset + length;
                if (tmpLen % (long)this.chunkSize != 0L) {
                    tmpLen += (long)this.chunkSize - tmpLen % (long)this.chunkSize;
                }
                if (tmpLen < end) {
                    end = tmpLen;
                } else if (chunkChecksum != null) {
                    this.lastChunkChecksum = chunkChecksum;
                }
            }
            this.endOffset = end;
            if (this.offset > 0L && (checksumSkip = this.offset / (long)this.chunkSize * (long)this.checksumSize) > 0L) {
                IOUtils.skipFully((InputStream)this.checksumIn, (long)checksumSkip);
            }
            this.seqno = 0L;
            if (DataNode.LOG.isDebugEnabled()) {
                DataNode.LOG.debug((Object)("replica=" + this.replica));
            }
            this.blockIn = datanode.data.getBlockInputStream(block, this.offset);
            this.blockInFd = this.blockIn instanceof FileInputStream ? ((FileInputStream)this.blockIn).getFD() : null;
        }
        catch (IOException ioe) {
            IOUtils.closeStream((Closeable)this);
            IOUtils.closeStream((Closeable)this.blockIn);
            throw ioe;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.blockInFd != null && this.shouldDropCacheBehindRead && this.isLongRead()) {
            try {
                NativeIO.posixFadviseIfPossible((FileDescriptor)this.blockInFd, (long)this.lastCacheDropOffset, (long)(this.offset - this.lastCacheDropOffset), (int)4);
            }
            catch (Exception e) {
                LOG.warn((Object)"Unable to drop cache on file close", (Throwable)e);
            }
        }
        if (this.curReadahead != null) {
            this.curReadahead.cancel();
        }
        IOException ioe = null;
        if (this.checksumIn != null) {
            try {
                this.checksumIn.close();
            }
            catch (IOException e) {
                ioe = e;
            }
            this.checksumIn = null;
        }
        if (this.blockIn != null) {
            try {
                this.blockIn.close();
            }
            catch (IOException e) {
                ioe = e;
            }
            this.blockIn = null;
            this.blockInFd = null;
        }
        if (ioe != null) {
            throw ioe;
        }
    }

    private static Replica getReplica(ExtendedBlock block, DataNode datanode) throws ReplicaNotFoundException {
        Replica replica = datanode.data.getReplica(block.getBlockPoolId(), block.getBlockId());
        if (replica == null) {
            throw new ReplicaNotFoundException(block);
        }
        return replica;
    }

    private static void waitForMinLength(ReplicaBeingWritten rbw, long len) throws IOException {
        for (int i = 0; i < 30 && rbw.getBytesOnDisk() < len; ++i) {
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException ie) {
                throw new IOException(ie);
            }
        }
        long bytesOnDisk = rbw.getBytesOnDisk();
        if (bytesOnDisk < len) {
            throw new IOException(String.format("Need %d bytes, but only %d bytes available", len, bytesOnDisk));
        }
    }

    private static IOException ioeToSocketException(IOException ioe) {
        if (ioe.getClass().equals(IOException.class)) {
            SocketException se = new SocketException("Original Exception : " + ioe);
            se.initCause(ioe);
            se.setStackTrace(ioe.getStackTrace());
            return se;
        }
        return ioe;
    }

    private int numberOfChunks(long datalen) {
        return (int)((datalen + (long)this.chunkSize - 1L) / (long)this.chunkSize);
    }

    private int sendPacket(ByteBuffer pkt, int maxChunks, OutputStream out, boolean transferTo, DataTransferThrottler throttler) throws IOException {
        int dataLen = (int)Math.min(this.endOffset - this.offset, (long)this.chunkSize * (long)maxChunks);
        int numChunks = this.numberOfChunks(dataLen);
        int checksumDataLen = numChunks * this.checksumSize;
        int packetLen = dataLen + checksumDataLen + 4;
        boolean lastDataPacket = this.offset + (long)dataLen == this.endOffset && dataLen > 0;
        this.writePacketHeader(pkt, dataLen, packetLen);
        int checksumOff = pkt.position();
        byte[] buf = pkt.array();
        if (this.checksumSize > 0 && this.checksumIn != null) {
            this.readChecksum(buf, checksumOff, checksumDataLen);
            if (lastDataPacket && this.lastChunkChecksum != null) {
                int start = checksumOff + checksumDataLen - this.checksumSize;
                byte[] updatedChecksum = this.lastChunkChecksum.getChecksum();
                if (updatedChecksum != null) {
                    System.arraycopy(updatedChecksum, 0, buf, start, this.checksumSize);
                }
            }
        }
        int dataOff = checksumOff + checksumDataLen;
        if (!transferTo) {
            IOUtils.readFully((InputStream)this.blockIn, (byte[])buf, (int)dataOff, (int)dataLen);
            if (this.verifyChecksum) {
                this.verifyChecksum(buf, dataOff, dataLen, numChunks, checksumOff);
            }
        }
        try {
            if (transferTo) {
                SocketOutputStream sockOut = (SocketOutputStream)out;
                sockOut.write(buf, 0, dataOff);
                sockOut.transferToFully(((FileInputStream)this.blockIn).getChannel(), this.blockInPosition, dataLen);
                this.blockInPosition += (long)dataLen;
            } else {
                out.write(buf, 0, dataOff + dataLen);
            }
        }
        catch (IOException e) {
            String ioem = e.getMessage();
            if (!ioem.startsWith("Broken pipe") && !ioem.startsWith("Connection reset")) {
                LOG.error((Object)"BlockSender.sendChunks() exception: ", (Throwable)e);
            }
            throw BlockSender.ioeToSocketException(e);
        }
        if (throttler != null) {
            throttler.throttle(packetLen);
        }
        return dataLen;
    }

    private void readChecksum(byte[] buf, int checksumOffset, int checksumLen) throws IOException {
        if (this.checksumSize <= 0 && this.checksumIn == null) {
            return;
        }
        try {
            this.checksumIn.readFully(buf, checksumOffset, checksumLen);
        }
        catch (IOException e) {
            LOG.warn((Object)(" Could not read or failed to veirfy checksum for data at offset " + this.offset + " for block " + this.block), (Throwable)e);
            IOUtils.closeStream((Closeable)this.checksumIn);
            this.checksumIn = null;
            if (this.corruptChecksumOk) {
                if (checksumOffset < checksumLen) {
                    Arrays.fill(buf, checksumOffset, checksumLen, (byte)0);
                }
            }
            throw e;
        }
    }

    public void verifyChecksum(byte[] buf, int dataOffset, int datalen, int numChunks, int checksumOffset) throws ChecksumException {
        int dOff = dataOffset;
        int cOff = checksumOffset;
        int dLeft = datalen;
        for (int i = 0; i < numChunks; ++i) {
            this.checksum.reset();
            int dLen = Math.min(dLeft, this.chunkSize);
            this.checksum.update(buf, dOff, dLen);
            if (!this.checksum.compare(buf, cOff)) {
                long failedPos = this.offset + (long)datalen - (long)dLeft;
                throw new ChecksumException("Checksum failed at " + failedPos, failedPos);
            }
            dLeft -= dLen;
            dOff += dLen;
            cOff += this.checksumSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    long sendBlock(DataOutputStream out, OutputStream baseStream, DataTransferThrottler throttler) throws IOException {
        long totalRead;
        block10: {
            if (out == null) {
                throw new IOException("out stream is null");
            }
            this.initialOffset = this.offset;
            totalRead = 0L;
            DataOutputStream dataOutputStream = out;
            this.lastCacheDropOffset = this.initialOffset;
            if (this.isLongRead() && this.blockInFd != null) {
                NativeIO.posixFadviseIfPossible((FileDescriptor)this.blockInFd, (long)0L, (long)0L, (int)2);
            }
            this.manageOsCache();
            long startTime = ClientTraceLog.isInfoEnabled() ? System.nanoTime() : 0L;
            try {
                void var6_7;
                int maxChunksPerPacket;
                boolean transferTo;
                int pktSize = PacketHeader.PKT_HEADER_LEN;
                boolean bl = transferTo = this.transferToAllowed && !this.verifyChecksum && baseStream instanceof SocketOutputStream && this.blockIn instanceof FileInputStream;
                if (transferTo) {
                    FileChannel fileChannel = ((FileInputStream)this.blockIn).getChannel();
                    this.blockInPosition = fileChannel.position();
                    OutputStream outputStream = baseStream;
                    maxChunksPerPacket = this.numberOfChunks(TRANSFERTO_BUFFER_SIZE);
                    pktSize += this.checksumSize * maxChunksPerPacket;
                } else {
                    maxChunksPerPacket = Math.max(1, this.numberOfChunks(HdfsConstants.IO_FILE_BUFFER_SIZE));
                    pktSize += (this.chunkSize + this.checksumSize) * maxChunksPerPacket;
                }
                ByteBuffer pktBuf = ByteBuffer.allocate(pktSize);
                while (this.endOffset > this.offset) {
                    this.manageOsCache();
                    long len = this.sendPacket(pktBuf, maxChunksPerPacket, (OutputStream)var6_7, transferTo, throttler);
                    this.offset += len;
                    totalRead += len + (long)(this.numberOfChunks(len) * this.checksumSize);
                    ++this.seqno;
                }
                try {
                    this.sendPacket(pktBuf, maxChunksPerPacket, (OutputStream)var6_7, transferTo, throttler);
                    out.flush();
                }
                catch (IOException e) {
                    throw BlockSender.ioeToSocketException(e);
                }
                this.sentEntireByteRange = true;
                if (this.clientTraceFmt == null) break block10;
            }
            catch (Throwable throwable) {
                if (this.clientTraceFmt != null) {
                    long endTime = System.nanoTime();
                    ClientTraceLog.info((Object)String.format(this.clientTraceFmt, totalRead, this.initialOffset, endTime - startTime));
                }
                this.close();
                throw throwable;
            }
            long endTime = System.nanoTime();
            ClientTraceLog.info((Object)String.format(this.clientTraceFmt, totalRead, this.initialOffset, endTime - startTime));
        }
        this.close();
        return totalRead;
    }

    private void manageOsCache() throws IOException {
        if (!this.isLongRead() || this.blockInFd == null) {
            return;
        }
        if (this.readaheadLength > 0L && readaheadPool != null) {
            this.curReadahead = readaheadPool.readaheadStream(this.clientTraceFmt, this.blockInFd, this.offset, this.readaheadLength, Long.MAX_VALUE, this.curReadahead);
        }
        long nextCacheDropOffset = this.lastCacheDropOffset + 0x100000L;
        if (this.shouldDropCacheBehindRead && this.offset >= nextCacheDropOffset) {
            long dropLength = this.offset - this.lastCacheDropOffset;
            if (dropLength >= 1024L) {
                NativeIO.posixFadviseIfPossible((FileDescriptor)this.blockInFd, (long)this.lastCacheDropOffset, (long)dropLength, (int)4);
            }
            this.lastCacheDropOffset += 0x100000L;
        }
    }

    private boolean isLongRead() {
        return this.endOffset - this.offset > 262144L;
    }

    private void writePacketHeader(ByteBuffer pkt, int dataLen, int packetLen) {
        pkt.clear();
        PacketHeader header = new PacketHeader(packetLen, this.offset, this.seqno, dataLen == 0, dataLen);
        header.putInBuffer(pkt);
    }

    boolean didSendEntireByteRange() {
        return this.sentEntireByteRange;
    }

    DataChecksum getChecksum() {
        return this.checksum;
    }

    long getOffset() {
        return this.offset;
    }
}

