/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.protocol;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableFactory;

public class BalancerBandwidthCommand
extends DatanodeCommand {
    private static final long BBC_DEFAULTBANDWIDTH = 0L;
    private long bandwidth;

    BalancerBandwidthCommand() {
        this(0L);
    }

    public BalancerBandwidthCommand(long bandwidth) {
        super(8);
        this.bandwidth = bandwidth;
    }

    public long getBalancerBandwidthValue() {
        return this.bandwidth;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeLong(this.bandwidth);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.bandwidth = in.readLong();
    }

    static {
        WritableFactories.setFactory(BalancerBandwidthCommand.class, (WritableFactory)new WritableFactory(){

            public Writable newInstance() {
                return new BalancerBandwidthCommand();
            }
        });
    }
}

