/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.protocol;

import com.google.common.base.Function;
import com.google.common.collect.ComparisonChain;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;

public class RemoteEditLog
implements Writable,
Comparable<RemoteEditLog> {
    private long startTxId = -12345L;
    private long endTxId = -12345L;
    public static final Function<RemoteEditLog, Long> GET_START_TXID = new Function<RemoteEditLog, Long>(){

        public Long apply(RemoteEditLog log) {
            return log.getStartTxId();
        }
    };

    public RemoteEditLog() {
    }

    public RemoteEditLog(long startTxId, long endTxId) {
        this.startTxId = startTxId;
        this.endTxId = endTxId;
    }

    public long getStartTxId() {
        return this.startTxId;
    }

    public long getEndTxId() {
        return this.endTxId;
    }

    public String toString() {
        return "[" + this.startTxId + "," + this.endTxId + "]";
    }

    public void write(DataOutput out) throws IOException {
        out.writeLong(this.startTxId);
        out.writeLong(this.endTxId);
    }

    public void readFields(DataInput in) throws IOException {
        this.startTxId = in.readLong();
        this.endTxId = in.readLong();
    }

    @Override
    public int compareTo(RemoteEditLog log) {
        return ComparisonChain.start().compare(this.startTxId, log.startTxId).compare(this.endTxId, log.endTxId).result();
    }

    public boolean equals(Object o) {
        if (!(o instanceof RemoteEditLog)) {
            return false;
        }
        return this.compareTo((RemoteEditLog)o) == 0;
    }

    public int hashCode() {
        return (int)(this.startTxId * this.endTxId);
    }
}

