/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools;

import java.io.IOException;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class GetConf
extends Configured
implements Tool {
    private static final String DESCRIPTION = "hdfs getconf is utility for getting configuration information from the config file.\n";
    static final String USAGE;
    private final PrintStream out;
    private final PrintStream err;

    GetConf(Configuration conf) {
        this(conf, System.out, System.err);
    }

    GetConf(Configuration conf, PrintStream out, PrintStream err) {
        super(conf);
        this.out = out;
        this.err = err;
    }

    void printError(String message) {
        this.err.println(message);
    }

    void printOut(String message) {
        this.out.println(message);
    }

    void printList(List<InetSocketAddress> list) {
        StringBuilder buffer = new StringBuilder();
        for (InetSocketAddress address : list) {
            if (buffer.length() > 0) {
                buffer.append(" ");
            }
            buffer.append(address.getHostName());
        }
        this.printOut(buffer.toString());
    }

    private void printUsage() {
        this.printError(USAGE);
    }

    private int doWork(String[] args) {
        CommandHandler handler;
        if (args.length == 1 && (handler = Command.getHandler(args[0])) != null) {
            return handler.doWork(this);
        }
        this.printUsage();
        return -1;
    }

    public int run(final String[] args) throws Exception {
        try {
            return (Integer)UserGroupInformation.getCurrentUser().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Integer>(){

                @Override
                public Integer run() throws Exception {
                    return GetConf.this.doWork(args);
                }
            });
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Tool)new GetConf(new HdfsConfiguration()), (String[])args);
        System.exit(res);
    }

    static {
        HdfsConfiguration.init();
        StringBuilder usage = new StringBuilder(DESCRIPTION);
        usage.append("\nhadoop getconf \n");
        for (Command cmd : Command.values()) {
            usage.append("\t[" + cmd.getName() + "]\t\t\t" + cmd.getDescription() + "\n");
        }
        USAGE = usage.toString();
    }

    static class NNRpcAddressesCommandHandler
    extends CommandHandler {
        NNRpcAddressesCommandHandler() {
        }

        @Override
        public int doWorkInternal(GetConf tool) throws IOException {
            Configuration config = tool.getConf();
            List<InetSocketAddress> rpclist = DFSUtil.getNNServiceRpcAddresses(config);
            if (rpclist != null) {
                for (InetSocketAddress rpc : rpclist) {
                    tool.printOut(rpc.getHostName() + ":" + rpc.getPort());
                }
                return 0;
            }
            tool.printError("Did not get namenode service rpc addresses.");
            return -1;
        }
    }

    static class SecondaryNameNodesCommandHandler
    extends CommandHandler {
        SecondaryNameNodesCommandHandler() {
        }

        @Override
        public int doWorkInternal(GetConf tool) throws IOException {
            tool.printList(DFSUtil.getSecondaryNameNodeAddresses(tool.getConf()));
            return 0;
        }
    }

    static class BackupNodesCommandHandler
    extends CommandHandler {
        BackupNodesCommandHandler() {
        }

        @Override
        public int doWorkInternal(GetConf tool) throws IOException {
            tool.printList(DFSUtil.getBackupNodeAddresses(tool.getConf()));
            return 0;
        }
    }

    static class NameNodesCommandHandler
    extends CommandHandler {
        NameNodesCommandHandler() {
        }

        @Override
        int doWorkInternal(GetConf tool) throws IOException {
            tool.printList(DFSUtil.getNNServiceRpcAddresses(tool.getConf()));
            return 0;
        }
    }

    static class CommandHandler {
        final String key;

        CommandHandler() {
            this(null);
        }

        CommandHandler(String key) {
            this.key = key;
        }

        final int doWork(GetConf tool) {
            try {
                return this.doWorkInternal(tool);
            }
            catch (Exception e) {
                tool.printError(e.getMessage());
                return -1;
            }
        }

        int doWorkInternal(GetConf tool) throws Exception {
            String value = tool.getConf().get(this.key);
            if (value != null) {
                tool.printOut(value);
                return 0;
            }
            tool.printError("Configuration " + this.key + " is missing.");
            return -1;
        }
    }

    static enum Command {
        NAMENODE("-namenodes", "gets list of namenodes in the cluster."),
        SECONDARY("-secondaryNameNodes", "gets list of secondary namenodes in the cluster."),
        BACKUP("-backupNodes", "gets list of backup nodes in the cluster."),
        INCLUDE_FILE("-includeFile", "gets the include file path that defines the datanodes that can join the cluster."),
        EXCLUDE_FILE("-excludeFile", "gets the exclude file path that defines the datanodes that need to decommissioned."),
        NNRPCADDRESSES("-nnRpcAddresses", "gets the namenode rpc addresses");

        private static Map<String, CommandHandler> map;
        private final String cmd;
        private final String description;

        private Command(String cmd, String description) {
            this.cmd = cmd;
            this.description = description;
        }

        public String getName() {
            return this.cmd;
        }

        public String getDescription() {
            return this.description;
        }

        public static CommandHandler getHandler(String name) {
            return map.get(name.toLowerCase());
        }

        static {
            map = new HashMap<String, CommandHandler>();
            map.put(NAMENODE.getName().toLowerCase(), new NameNodesCommandHandler());
            map.put(SECONDARY.getName().toLowerCase(), new SecondaryNameNodesCommandHandler());
            map.put(BACKUP.getName().toLowerCase(), new BackupNodesCommandHandler());
            map.put(INCLUDE_FILE.getName().toLowerCase(), new CommandHandler("DFSConfigKeys.DFS_HOSTS"));
            map.put(EXCLUDE_FILE.getName().toLowerCase(), new CommandHandler("DFSConfigKeys.DFS_HOSTS_EXCLUDE"));
            map.put(NNRPCADDRESSES.getName().toLowerCase(), new NNRpcAddressesCommandHandler());
        }
    }
}

