/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.offlineEditsViewer;

import java.io.IOException;
import java.util.LinkedList;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.tools.offlineEditsViewer.EditsElement;
import org.apache.hadoop.hdfs.tools.offlineEditsViewer.TextEditsVisitor;
import org.apache.hadoop.hdfs.tools.offlineEditsViewer.Tokenizer;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.DepthCounter;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class XmlEditsVisitor
extends TextEditsVisitor {
    private final LinkedList<EditsElement> tagQ = new LinkedList();
    private final DepthCounter depthCounter = new DepthCounter();
    private static final String[] indents = new String[]{"", "  ", "    ", "      ", "        ", "          ", "            "};

    public XmlEditsVisitor(String filename, Tokenizer tokenizer) throws IOException {
        super(filename, tokenizer, false);
    }

    public XmlEditsVisitor(String filename, Tokenizer tokenizer, boolean printToScreen) throws IOException {
        super(filename, tokenizer, printToScreen);
    }

    @Override
    void start() throws IOException {
        this.write("<?xml version=\"1.0\"?>\n");
    }

    @Override
    void finish() throws IOException {
        super.finish();
    }

    @Override
    void finishAbnormally() throws IOException {
        this.write("\n<!-- Error processing EditLog file.  Exiting -->\n");
        super.finishAbnormally();
    }

    @Override
    Tokenizer.Token visit(Tokenizer.Token value) throws IOException {
        this.writeTag(value.getEditsElement().toString(), value.toString());
        return value;
    }

    @Override
    void visitEnclosingElement(Tokenizer.Token value) throws IOException {
        this.printIndents();
        this.write("<" + value.getEditsElement().toString() + ">\n");
        this.tagQ.push(value.getEditsElement());
        this.depthCounter.incLevel();
    }

    @Override
    void leaveEnclosingElement() throws IOException {
        this.depthCounter.decLevel();
        if (this.tagQ.size() == 0) {
            throw new IOException("Tried to exit non-existent enclosing element in EditLog file");
        }
        EditsElement element = this.tagQ.pop();
        this.printIndents();
        this.write("</" + element.toString() + ">\n");
    }

    private void writeTag(String tag, String value) throws IOException {
        this.printIndents();
        if (value.length() > 0) {
            this.write("<" + tag + ">" + value + "</" + tag + ">\n");
        } else {
            this.write("<" + tag + "/>\n");
        }
    }

    private void printIndents() throws IOException {
        try {
            this.write(indents[this.depthCounter.getLevel()]);
        }
        catch (IndexOutOfBoundsException e) {
            for (int i = 0; i < this.depthCounter.getLevel(); ++i) {
                this.write("  ");
            }
        }
    }
}

