/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.offlineImageViewer;

import java.io.IOException;

abstract class ImageVisitor {
    ImageVisitor() {
    }

    abstract void start() throws IOException;

    abstract void finish() throws IOException;

    abstract void finishAbnormally() throws IOException;

    abstract void visit(ImageElement var1, String var2) throws IOException;

    void visit(ImageElement element, int value) throws IOException {
        this.visit(element, Integer.toString(value));
    }

    void visit(ImageElement element, long value) throws IOException {
        this.visit(element, Long.toString(value));
    }

    abstract void visitEnclosingElement(ImageElement var1) throws IOException;

    abstract void visitEnclosingElement(ImageElement var1, ImageElement var2, String var3) throws IOException;

    void visitEnclosingElement(ImageElement element, ImageElement key, int value) throws IOException {
        this.visitEnclosingElement(element, key, Integer.toString(value));
    }

    void visitEnclosingElement(ImageElement element, ImageElement key, long value) throws IOException {
        this.visitEnclosingElement(element, key, Long.toString(value));
    }

    abstract void leaveEnclosingElement() throws IOException;

    public static enum ImageElement {
        FS_IMAGE,
        IMAGE_VERSION,
        NAMESPACE_ID,
        IS_COMPRESSED,
        COMPRESS_CODEC,
        LAYOUT_VERSION,
        NUM_INODES,
        GENERATION_STAMP,
        INODES,
        INODE,
        INODE_PATH,
        REPLICATION,
        MODIFICATION_TIME,
        ACCESS_TIME,
        BLOCK_SIZE,
        NUM_BLOCKS,
        BLOCKS,
        BLOCK,
        BLOCK_ID,
        NUM_BYTES,
        NS_QUOTA,
        DS_QUOTA,
        PERMISSIONS,
        SYMLINK,
        NUM_INODES_UNDER_CONSTRUCTION,
        INODES_UNDER_CONSTRUCTION,
        INODE_UNDER_CONSTRUCTION,
        PREFERRED_BLOCK_SIZE,
        CLIENT_NAME,
        CLIENT_MACHINE,
        USER_NAME,
        GROUP_NAME,
        PERMISSION_STRING,
        CURRENT_DELEGATION_KEY_ID,
        NUM_DELEGATION_KEYS,
        DELEGATION_KEYS,
        DELEGATION_KEY,
        DELEGATION_TOKEN_SEQUENCE_NUMBER,
        NUM_DELEGATION_TOKENS,
        DELEGATION_TOKENS,
        DELEGATION_TOKEN_IDENTIFIER,
        DELEGATION_TOKEN_EXPIRY_TIME,
        TRANSACTION_ID;

    }
}

